/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionNiciraSetNsi;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionNiciraSetNsiVer11
implements OFActionNiciraSetNsi {
    private static final Logger logger = LoggerFactory.getLogger(OFActionNiciraSetNsiVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int LENGTH = 16;
    private static final short DEFAULT_NSI = 0;
    private final short nsi;
    static final OFActionNiciraSetNsiVer11 DEFAULT = new OFActionNiciraSetNsiVer11(0);
    static final Reader READER = new Reader();
    static final OFActionNiciraSetNsiVer11Funnel FUNNEL = new OFActionNiciraSetNsiVer11Funnel();
    static final Writer WRITER = new Writer();

    OFActionNiciraSetNsiVer11(short nsi) {
        this.nsi = nsi;
    }

    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 8992L;
    }

    @Override
    public int getSubtype() {
        return 33;
    }

    @Override
    public short getNsi() {
        return this.nsi;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFActionNiciraSetNsi.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionNiciraSetNsiVer11(");
        b.append("nsi=").append(this.nsi);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionNiciraSetNsiVer11 other = (OFActionNiciraSetNsiVer11)obj;
        return this.nsi == other.nsi;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.nsi;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionNiciraSetNsiVer11> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFActionNiciraSetNsiVer11 message) {
            bb.writeShort(-1);
            bb.writeShort(16);
            bb.writeInt(8992);
            bb.writeShort(33);
            bb.writeByte((int)U8.t(message.nsi));
            bb.writeZero(5);
        }
    }

    static class OFActionNiciraSetNsiVer11Funnel
    implements Funnel<OFActionNiciraSetNsiVer11> {
        private static final long serialVersionUID = 1L;

        OFActionNiciraSetNsiVer11Funnel() {
        }

        public void funnel(OFActionNiciraSetNsiVer11 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)16);
            sink.putInt(8992);
            sink.putShort((short)33);
            sink.putShort(message.nsi);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionNiciraSetNsi> {
        Reader() {
        }

        @Override
        public OFActionNiciraSetNsi readFrom(ChannelBuffer bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 16) {
                throw new OFParseError("Wrong length: Expected=16(16), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 8992) {
                throw new OFParseError("Wrong experimenter: Expected=0x2320L(0x2320L), got=" + experimenter);
            }
            short subtype = bb.readShort();
            if (subtype != 33) {
                throw new OFParseError("Wrong subtype: Expected=0x21(0x21), got=" + subtype);
            }
            short nsi = U8.f(bb.readByte());
            bb.skipBytes(5);
            OFActionNiciraSetNsiVer11 actionNiciraSetNsiVer11 = new OFActionNiciraSetNsiVer11(nsi);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionNiciraSetNsiVer11);
            }
            return actionNiciraSetNsiVer11;
        }
    }

    static class Builder
    implements OFActionNiciraSetNsi.Builder {
        private boolean nsiSet;
        private short nsi;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.EXPERIMENTER;
        }

        @Override
        public long getExperimenter() {
            return 8992L;
        }

        @Override
        public int getSubtype() {
            return 33;
        }

        @Override
        public short getNsi() {
            return this.nsi;
        }

        @Override
        public OFActionNiciraSetNsi.Builder setNsi(short nsi) {
            this.nsi = nsi;
            this.nsiSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFActionNiciraSetNsi build() {
            short nsi = this.nsiSet ? this.nsi : (short)0;
            return new OFActionNiciraSetNsiVer11(nsi);
        }
    }

    static class BuilderWithParent
    implements OFActionNiciraSetNsi.Builder {
        final OFActionNiciraSetNsiVer11 parentMessage;
        private boolean nsiSet;
        private short nsi;

        BuilderWithParent(OFActionNiciraSetNsiVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.EXPERIMENTER;
        }

        @Override
        public long getExperimenter() {
            return 8992L;
        }

        @Override
        public int getSubtype() {
            return 33;
        }

        @Override
        public short getNsi() {
            return this.nsi;
        }

        @Override
        public OFActionNiciraSetNsi.Builder setNsi(short nsi) {
            this.nsi = nsi;
            this.nsiSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFActionNiciraSetNsi build() {
            short nsi = this.nsiSet ? this.nsi : this.parentMessage.nsi;
            return new OFActionNiciraSetNsiVer11(nsi);
        }
    }
}

