/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.List;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFCapabilities;
import org.projectfloodlight.openflow.protocol.OFFeaturesReply;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortDesc;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver11.OFCapabilitiesSerializerVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFPortDescVer11;
import org.projectfloodlight.openflow.types.DatapathId;
import org.projectfloodlight.openflow.types.OFAuxId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U8;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFFeaturesReplyVer11
implements OFFeaturesReply {
    private static final Logger logger = LoggerFactory.getLogger(OFFeaturesReplyVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int MINIMUM_LENGTH = 32;
    private static final long DEFAULT_XID = 0L;
    private static final DatapathId DEFAULT_DATAPATH_ID = DatapathId.NONE;
    private static final long DEFAULT_N_BUFFERS = 0L;
    private static final short DEFAULT_N_TABLES = 0;
    private static final Set<OFCapabilities> DEFAULT_CAPABILITIES = ImmutableSet.of();
    private static final long DEFAULT_RESERVED = 0L;
    private static final List<OFPortDesc> DEFAULT_PORTS = ImmutableList.of();
    private final long xid;
    private final DatapathId datapathId;
    private final long nBuffers;
    private final short nTables;
    private final Set<OFCapabilities> capabilities;
    private final long reserved;
    private final List<OFPortDesc> ports;
    static final OFFeaturesReplyVer11 DEFAULT = new OFFeaturesReplyVer11(0L, DEFAULT_DATAPATH_ID, 0L, 0, DEFAULT_CAPABILITIES, 0L, DEFAULT_PORTS);
    static final Reader READER = new Reader();
    static final OFFeaturesReplyVer11Funnel FUNNEL = new OFFeaturesReplyVer11Funnel();
    static final Writer WRITER = new Writer();

    OFFeaturesReplyVer11(long xid, DatapathId datapathId, long nBuffers, short nTables, Set<OFCapabilities> capabilities, long reserved, List<OFPortDesc> ports) {
        if (datapathId == null) {
            throw new NullPointerException("OFFeaturesReplyVer11: property datapathId cannot be null");
        }
        if (capabilities == null) {
            throw new NullPointerException("OFFeaturesReplyVer11: property capabilities cannot be null");
        }
        if (ports == null) {
            throw new NullPointerException("OFFeaturesReplyVer11: property ports cannot be null");
        }
        this.xid = xid;
        this.datapathId = datapathId;
        this.nBuffers = nBuffers;
        this.nTables = nTables;
        this.capabilities = capabilities;
        this.reserved = reserved;
        this.ports = ports;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFType getType() {
        return OFType.FEATURES_REPLY;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public DatapathId getDatapathId() {
        return this.datapathId;
    }

    @Override
    public long getNBuffers() {
        return this.nBuffers;
    }

    @Override
    public short getNTables() {
        return this.nTables;
    }

    @Override
    public Set<OFCapabilities> getCapabilities() {
        return this.capabilities;
    }

    @Override
    public long getReserved() {
        return this.reserved;
    }

    @Override
    public List<OFPortDesc> getPorts() {
        return this.ports;
    }

    @Override
    public Set<OFActionType> getActions() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property actions not supported in version 1.1");
    }

    @Override
    public OFAuxId getAuxiliaryId() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property auxiliaryId not supported in version 1.1");
    }

    @Override
    public OFFeaturesReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFFeaturesReplyVer11(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("datapathId=").append(this.datapathId);
        b.append(", ");
        b.append("nBuffers=").append(this.nBuffers);
        b.append(", ");
        b.append("nTables=").append(this.nTables);
        b.append(", ");
        b.append("capabilities=").append(this.capabilities);
        b.append(", ");
        b.append("reserved=").append(this.reserved);
        b.append(", ");
        b.append("ports=").append(this.ports);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFFeaturesReplyVer11 other = (OFFeaturesReplyVer11)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.datapathId == null ? other.datapathId != null : !this.datapathId.equals(other.datapathId)) {
            return false;
        }
        if (this.nBuffers != other.nBuffers) {
            return false;
        }
        if (this.nTables != other.nTables) {
            return false;
        }
        if (this.capabilities == null ? other.capabilities != null : !this.capabilities.equals(other.capabilities)) {
            return false;
        }
        if (this.reserved != other.reserved) {
            return false;
        }
        return !(this.ports == null ? other.ports != null : !this.ports.equals(other.ports));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.datapathId == null ? 0 : this.datapathId.hashCode());
        result = 31 * (int)(this.nBuffers ^ this.nBuffers >>> 32);
        result = 31 * result + this.nTables;
        result = 31 * result + (this.capabilities == null ? 0 : this.capabilities.hashCode());
        result = 31 * (int)(this.reserved ^ this.reserved >>> 32);
        result = 31 * result + (this.ports == null ? 0 : this.ports.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFFeaturesReplyVer11> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFFeaturesReplyVer11 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(2);
            bb.writeByte(6);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeLong(message.datapathId.getLong());
            bb.writeInt(U32.t(message.nBuffers));
            bb.writeByte((int)U8.t(message.nTables));
            bb.writeZero(3);
            OFCapabilitiesSerializerVer11.writeTo(bb, message.capabilities);
            bb.writeInt(U32.t(message.reserved));
            ChannelUtils.writeList(bb, message.ports);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFFeaturesReplyVer11Funnel
    implements Funnel<OFFeaturesReplyVer11> {
        private static final long serialVersionUID = 1L;

        OFFeaturesReplyVer11Funnel() {
        }

        public void funnel(OFFeaturesReplyVer11 message, PrimitiveSink sink) {
            sink.putByte((byte)2);
            sink.putByte((byte)6);
            sink.putLong(message.xid);
            message.datapathId.putTo(sink);
            sink.putLong(message.nBuffers);
            sink.putShort(message.nTables);
            OFCapabilitiesSerializerVer11.putTo(message.capabilities, sink);
            sink.putLong(message.reserved);
            FunnelUtils.putList(message.ports, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFFeaturesReply> {
        Reader() {
        }

        @Override
        public OFFeaturesReply readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 2) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_11(2), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 6) {
                throw new OFParseError("Wrong type: Expected=OFType.FEATURES_REPLY(6), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 32) {
                throw new OFParseError("Wrong length: Expected to be >= 32, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            DatapathId datapathId = DatapathId.of(bb.readLong());
            long nBuffers = U32.f(bb.readInt());
            short nTables = U8.f(bb.readByte());
            bb.skipBytes(3);
            Set<OFCapabilities> capabilities = OFCapabilitiesSerializerVer11.readFrom(bb);
            long reserved = U32.f(bb.readInt());
            List<OFPortDesc> ports = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFPortDescVer11.READER);
            OFFeaturesReplyVer11 featuresReplyVer11 = new OFFeaturesReplyVer11(xid, datapathId, nBuffers, nTables, capabilities, reserved, ports);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)featuresReplyVer11);
            }
            return featuresReplyVer11;
        }
    }

    static class Builder
    implements OFFeaturesReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean datapathIdSet;
        private DatapathId datapathId;
        private boolean nBuffersSet;
        private long nBuffers;
        private boolean nTablesSet;
        private short nTables;
        private boolean capabilitiesSet;
        private Set<OFCapabilities> capabilities;
        private boolean reservedSet;
        private long reserved;
        private boolean portsSet;
        private List<OFPortDesc> ports;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.FEATURES_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFFeaturesReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public DatapathId getDatapathId() {
            return this.datapathId;
        }

        @Override
        public OFFeaturesReply.Builder setDatapathId(DatapathId datapathId) {
            this.datapathId = datapathId;
            this.datapathIdSet = true;
            return this;
        }

        @Override
        public long getNBuffers() {
            return this.nBuffers;
        }

        @Override
        public OFFeaturesReply.Builder setNBuffers(long nBuffers) {
            this.nBuffers = nBuffers;
            this.nBuffersSet = true;
            return this;
        }

        @Override
        public short getNTables() {
            return this.nTables;
        }

        @Override
        public OFFeaturesReply.Builder setNTables(short nTables) {
            this.nTables = nTables;
            this.nTablesSet = true;
            return this;
        }

        @Override
        public Set<OFCapabilities> getCapabilities() {
            return this.capabilities;
        }

        @Override
        public OFFeaturesReply.Builder setCapabilities(Set<OFCapabilities> capabilities) {
            this.capabilities = capabilities;
            this.capabilitiesSet = true;
            return this;
        }

        @Override
        public long getReserved() {
            return this.reserved;
        }

        @Override
        public OFFeaturesReply.Builder setReserved(long reserved) {
            this.reserved = reserved;
            this.reservedSet = true;
            return this;
        }

        @Override
        public List<OFPortDesc> getPorts() {
            return this.ports;
        }

        @Override
        public OFFeaturesReply.Builder setPorts(List<OFPortDesc> ports) {
            this.ports = ports;
            this.portsSet = true;
            return this;
        }

        @Override
        public Set<OFActionType> getActions() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property actions not supported in version 1.1");
        }

        @Override
        public OFFeaturesReply.Builder setActions(Set<OFActionType> actions) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property actions not supported in version 1.1");
        }

        @Override
        public OFAuxId getAuxiliaryId() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property auxiliaryId not supported in version 1.1");
        }

        @Override
        public OFFeaturesReply.Builder setAuxiliaryId(OFAuxId auxiliaryId) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property auxiliaryId not supported in version 1.1");
        }

        @Override
        public OFFeaturesReply build() {
            List<OFPortDesc> ports;
            Set<OFCapabilities> capabilities;
            DatapathId datapathId;
            long xid = this.xidSet ? this.xid : 0L;
            DatapathId datapathId2 = datapathId = this.datapathIdSet ? this.datapathId : DEFAULT_DATAPATH_ID;
            if (datapathId == null) {
                throw new NullPointerException("Property datapathId must not be null");
            }
            long nBuffers = this.nBuffersSet ? this.nBuffers : 0L;
            short nTables = this.nTablesSet ? this.nTables : (short)0;
            Set<OFCapabilities> set = capabilities = this.capabilitiesSet ? this.capabilities : DEFAULT_CAPABILITIES;
            if (capabilities == null) {
                throw new NullPointerException("Property capabilities must not be null");
            }
            long reserved = this.reservedSet ? this.reserved : 0L;
            List<OFPortDesc> list = ports = this.portsSet ? this.ports : DEFAULT_PORTS;
            if (ports == null) {
                throw new NullPointerException("Property ports must not be null");
            }
            return new OFFeaturesReplyVer11(xid, datapathId, nBuffers, nTables, capabilities, reserved, ports);
        }
    }

    static class BuilderWithParent
    implements OFFeaturesReply.Builder {
        final OFFeaturesReplyVer11 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean datapathIdSet;
        private DatapathId datapathId;
        private boolean nBuffersSet;
        private long nBuffers;
        private boolean nTablesSet;
        private short nTables;
        private boolean capabilitiesSet;
        private Set<OFCapabilities> capabilities;
        private boolean reservedSet;
        private long reserved;
        private boolean portsSet;
        private List<OFPortDesc> ports;

        BuilderWithParent(OFFeaturesReplyVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.FEATURES_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFFeaturesReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public DatapathId getDatapathId() {
            return this.datapathId;
        }

        @Override
        public OFFeaturesReply.Builder setDatapathId(DatapathId datapathId) {
            this.datapathId = datapathId;
            this.datapathIdSet = true;
            return this;
        }

        @Override
        public long getNBuffers() {
            return this.nBuffers;
        }

        @Override
        public OFFeaturesReply.Builder setNBuffers(long nBuffers) {
            this.nBuffers = nBuffers;
            this.nBuffersSet = true;
            return this;
        }

        @Override
        public short getNTables() {
            return this.nTables;
        }

        @Override
        public OFFeaturesReply.Builder setNTables(short nTables) {
            this.nTables = nTables;
            this.nTablesSet = true;
            return this;
        }

        @Override
        public Set<OFCapabilities> getCapabilities() {
            return this.capabilities;
        }

        @Override
        public OFFeaturesReply.Builder setCapabilities(Set<OFCapabilities> capabilities) {
            this.capabilities = capabilities;
            this.capabilitiesSet = true;
            return this;
        }

        @Override
        public long getReserved() {
            return this.reserved;
        }

        @Override
        public OFFeaturesReply.Builder setReserved(long reserved) {
            this.reserved = reserved;
            this.reservedSet = true;
            return this;
        }

        @Override
        public List<OFPortDesc> getPorts() {
            return this.ports;
        }

        @Override
        public OFFeaturesReply.Builder setPorts(List<OFPortDesc> ports) {
            this.ports = ports;
            this.portsSet = true;
            return this;
        }

        @Override
        public Set<OFActionType> getActions() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property actions not supported in version 1.1");
        }

        @Override
        public OFFeaturesReply.Builder setActions(Set<OFActionType> actions) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property actions not supported in version 1.1");
        }

        @Override
        public OFAuxId getAuxiliaryId() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property auxiliaryId not supported in version 1.1");
        }

        @Override
        public OFFeaturesReply.Builder setAuxiliaryId(OFAuxId auxiliaryId) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property auxiliaryId not supported in version 1.1");
        }

        @Override
        public OFFeaturesReply build() {
            List ports;
            Set capabilities;
            DatapathId datapathId;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            DatapathId datapathId2 = datapathId = this.datapathIdSet ? this.datapathId : this.parentMessage.datapathId;
            if (datapathId == null) {
                throw new NullPointerException("Property datapathId must not be null");
            }
            long nBuffers = this.nBuffersSet ? this.nBuffers : this.parentMessage.nBuffers;
            short nTables = this.nTablesSet ? this.nTables : this.parentMessage.nTables;
            Set set = capabilities = this.capabilitiesSet ? this.capabilities : this.parentMessage.capabilities;
            if (capabilities == null) {
                throw new NullPointerException("Property capabilities must not be null");
            }
            long reserved = this.reservedSet ? this.reserved : this.parentMessage.reserved;
            List list = ports = this.portsSet ? this.ports : this.parentMessage.ports;
            if (ports == null) {
                throw new NullPointerException("Property ports must not be null");
            }
            return new OFFeaturesReplyVer11(xid, datapathId, nBuffers, nTables, capabilities, reserved, ports);
        }
    }
}

