/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBucket;
import org.projectfloodlight.openflow.protocol.OFGroupDescStatsEntry;
import org.projectfloodlight.openflow.protocol.OFGroupType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver11.OFBucketVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFGroupTypeSerializerVer11;
import org.projectfloodlight.openflow.types.OFGroup;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFGroupDescStatsEntryVer11
implements OFGroupDescStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFGroupDescStatsEntryVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int MINIMUM_LENGTH = 8;
    private static final OFGroup DEFAULT_GROUP_ID = OFGroup.ALL;
    private static final List<OFBucket> DEFAULT_BUCKETS = ImmutableList.of();
    private final OFGroupType groupType;
    private final OFGroup group;
    private final List<OFBucket> buckets;
    static final Reader READER = new Reader();
    static final OFGroupDescStatsEntryVer11Funnel FUNNEL = new OFGroupDescStatsEntryVer11Funnel();
    static final Writer WRITER = new Writer();

    OFGroupDescStatsEntryVer11(OFGroupType groupType, OFGroup group, List<OFBucket> buckets) {
        if (groupType == null) {
            throw new NullPointerException("OFGroupDescStatsEntryVer11: property groupType cannot be null");
        }
        if (group == null) {
            throw new NullPointerException("OFGroupDescStatsEntryVer11: property group cannot be null");
        }
        if (buckets == null) {
            throw new NullPointerException("OFGroupDescStatsEntryVer11: property buckets cannot be null");
        }
        this.groupType = groupType;
        this.group = group;
        this.buckets = buckets;
    }

    @Override
    public OFGroupType getGroupType() {
        return this.groupType;
    }

    @Override
    public OFGroup getGroup() {
        return this.group;
    }

    @Override
    public List<OFBucket> getBuckets() {
        return this.buckets;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFGroupDescStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFGroupDescStatsEntryVer11(");
        b.append("groupType=").append((Object)this.groupType);
        b.append(", ");
        b.append("group=").append(this.group);
        b.append(", ");
        b.append("buckets=").append(this.buckets);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFGroupDescStatsEntryVer11 other = (OFGroupDescStatsEntryVer11)obj;
        if (this.groupType == null ? other.groupType != null : !this.groupType.equals((Object)other.groupType)) {
            return false;
        }
        if (this.group == null ? other.group != null : !this.group.equals(other.group)) {
            return false;
        }
        return !(this.buckets == null ? other.buckets != null : !this.buckets.equals(other.buckets));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.groupType == null ? 0 : this.groupType.hashCode());
        result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
        result = 31 * result + (this.buckets == null ? 0 : this.buckets.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFGroupDescStatsEntryVer11> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFGroupDescStatsEntryVer11 message) {
            int startIndex = bb.writerIndex();
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            OFGroupTypeSerializerVer11.writeTo(bb, message.groupType);
            bb.writeZero(1);
            message.group.write4Bytes(bb);
            ChannelUtils.writeList(bb, message.buckets);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFGroupDescStatsEntryVer11Funnel
    implements Funnel<OFGroupDescStatsEntryVer11> {
        private static final long serialVersionUID = 1L;

        OFGroupDescStatsEntryVer11Funnel() {
        }

        public void funnel(OFGroupDescStatsEntryVer11 message, PrimitiveSink sink) {
            OFGroupTypeSerializerVer11.putTo(message.groupType, sink);
            message.group.putTo(sink);
            FunnelUtils.putList(message.buckets, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFGroupDescStatsEntry> {
        Reader() {
        }

        @Override
        public OFGroupDescStatsEntry readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            int length = U16.f(bb.readShort());
            if (length < 8) {
                throw new OFParseError("Wrong length: Expected to be >= 8, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFGroupType groupType = OFGroupTypeSerializerVer11.readFrom(bb);
            bb.skipBytes(1);
            OFGroup group = OFGroup.read4Bytes(bb);
            List<OFBucket> buckets = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFBucketVer11.READER);
            OFGroupDescStatsEntryVer11 groupDescStatsEntryVer11 = new OFGroupDescStatsEntryVer11(groupType, group, buckets);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)groupDescStatsEntryVer11);
            }
            return groupDescStatsEntryVer11;
        }
    }

    static class Builder
    implements OFGroupDescStatsEntry.Builder {
        private boolean groupTypeSet;
        private OFGroupType groupType;
        private boolean groupSet;
        private OFGroup group;
        private boolean bucketsSet;
        private List<OFBucket> buckets;

        Builder() {
        }

        @Override
        public OFGroupType getGroupType() {
            return this.groupType;
        }

        @Override
        public OFGroupDescStatsEntry.Builder setGroupType(OFGroupType groupType) {
            this.groupType = groupType;
            this.groupTypeSet = true;
            return this;
        }

        @Override
        public OFGroup getGroup() {
            return this.group;
        }

        @Override
        public OFGroupDescStatsEntry.Builder setGroup(OFGroup group) {
            this.group = group;
            this.groupSet = true;
            return this;
        }

        @Override
        public List<OFBucket> getBuckets() {
            return this.buckets;
        }

        @Override
        public OFGroupDescStatsEntry.Builder setBuckets(List<OFBucket> buckets) {
            this.buckets = buckets;
            this.bucketsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFGroupDescStatsEntry build() {
            List<OFBucket> buckets;
            OFGroup group;
            if (!this.groupTypeSet) {
                throw new IllegalStateException("Property groupType doesn't have default value -- must be set");
            }
            if (this.groupType == null) {
                throw new NullPointerException("Property groupType must not be null");
            }
            OFGroup oFGroup = group = this.groupSet ? this.group : DEFAULT_GROUP_ID;
            if (group == null) {
                throw new NullPointerException("Property group must not be null");
            }
            List<OFBucket> list = buckets = this.bucketsSet ? this.buckets : DEFAULT_BUCKETS;
            if (buckets == null) {
                throw new NullPointerException("Property buckets must not be null");
            }
            return new OFGroupDescStatsEntryVer11(this.groupType, group, buckets);
        }
    }

    static class BuilderWithParent
    implements OFGroupDescStatsEntry.Builder {
        final OFGroupDescStatsEntryVer11 parentMessage;
        private boolean groupTypeSet;
        private OFGroupType groupType;
        private boolean groupSet;
        private OFGroup group;
        private boolean bucketsSet;
        private List<OFBucket> buckets;

        BuilderWithParent(OFGroupDescStatsEntryVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFGroupType getGroupType() {
            return this.groupType;
        }

        @Override
        public OFGroupDescStatsEntry.Builder setGroupType(OFGroupType groupType) {
            this.groupType = groupType;
            this.groupTypeSet = true;
            return this;
        }

        @Override
        public OFGroup getGroup() {
            return this.group;
        }

        @Override
        public OFGroupDescStatsEntry.Builder setGroup(OFGroup group) {
            this.group = group;
            this.groupSet = true;
            return this;
        }

        @Override
        public List<OFBucket> getBuckets() {
            return this.buckets;
        }

        @Override
        public OFGroupDescStatsEntry.Builder setBuckets(List<OFBucket> buckets) {
            this.buckets = buckets;
            this.bucketsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFGroupDescStatsEntry build() {
            List buckets;
            OFGroup group;
            OFGroupType groupType;
            OFGroupType oFGroupType = groupType = this.groupTypeSet ? this.groupType : this.parentMessage.groupType;
            if (groupType == null) {
                throw new NullPointerException("Property groupType must not be null");
            }
            OFGroup oFGroup = group = this.groupSet ? this.group : this.parentMessage.group;
            if (group == null) {
                throw new NullPointerException("Property group must not be null");
            }
            List list = buckets = this.bucketsSet ? this.buckets : this.parentMessage.buckets;
            if (buckets == null) {
                throw new NullPointerException("Property buckets must not be null");
            }
            return new OFGroupDescStatsEntryVer11(groupType, group, buckets);
        }
    }
}

