/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPacketQueue;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.queueprop.OFQueueProp;
import org.projectfloodlight.openflow.protocol.ver11.OFQueuePropVer11;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPacketQueueVer11
implements OFPacketQueue {
    private static final Logger logger = LoggerFactory.getLogger(OFPacketQueueVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int MINIMUM_LENGTH = 8;
    private static final long DEFAULT_QUEUE_ID = 0L;
    private static final List<OFQueueProp> DEFAULT_PROPERTIES = ImmutableList.of();
    private final long queueId;
    private final List<OFQueueProp> properties;
    static final OFPacketQueueVer11 DEFAULT = new OFPacketQueueVer11(0L, DEFAULT_PROPERTIES);
    static final Reader READER = new Reader();
    static final OFPacketQueueVer11Funnel FUNNEL = new OFPacketQueueVer11Funnel();
    static final Writer WRITER = new Writer();

    OFPacketQueueVer11(long queueId, List<OFQueueProp> properties) {
        if (properties == null) {
            throw new NullPointerException("OFPacketQueueVer11: property properties cannot be null");
        }
        this.queueId = queueId;
        this.properties = properties;
    }

    @Override
    public long getQueueId() {
        return this.queueId;
    }

    @Override
    public OFPort getPort() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property port not supported in version 1.1");
    }

    @Override
    public List<OFQueueProp> getProperties() {
        return this.properties;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFPacketQueue.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPacketQueueVer11(");
        b.append("queueId=").append(this.queueId);
        b.append(", ");
        b.append("properties=").append(this.properties);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPacketQueueVer11 other = (OFPacketQueueVer11)obj;
        if (this.queueId != other.queueId) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.queueId ^ this.queueId >>> 32);
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPacketQueueVer11> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFPacketQueueVer11 message) {
            int startIndex = bb.writerIndex();
            bb.writeInt(U32.t(message.queueId));
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeZero(2);
            ChannelUtils.writeList(bb, message.properties);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFPacketQueueVer11Funnel
    implements Funnel<OFPacketQueueVer11> {
        private static final long serialVersionUID = 1L;

        OFPacketQueueVer11Funnel() {
        }

        public void funnel(OFPacketQueueVer11 message, PrimitiveSink sink) {
            sink.putLong(message.queueId);
            FunnelUtils.putList(message.properties, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFPacketQueue> {
        Reader() {
        }

        @Override
        public OFPacketQueue readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            long queueId = U32.f(bb.readInt());
            int length = U16.f(bb.readShort());
            if (length < 8) {
                throw new OFParseError("Wrong length: Expected to be >= 8, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(2);
            List<OFQueueProp> properties = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFQueuePropVer11.READER);
            OFPacketQueueVer11 packetQueueVer11 = new OFPacketQueueVer11(queueId, properties);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)packetQueueVer11);
            }
            return packetQueueVer11;
        }
    }

    static class Builder
    implements OFPacketQueue.Builder {
        private boolean queueIdSet;
        private long queueId;
        private boolean propertiesSet;
        private List<OFQueueProp> properties;

        Builder() {
        }

        @Override
        public long getQueueId() {
            return this.queueId;
        }

        @Override
        public OFPacketQueue.Builder setQueueId(long queueId) {
            this.queueId = queueId;
            this.queueIdSet = true;
            return this;
        }

        @Override
        public OFPort getPort() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property port not supported in version 1.1");
        }

        @Override
        public OFPacketQueue.Builder setPort(OFPort port) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property port not supported in version 1.1");
        }

        @Override
        public List<OFQueueProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFPacketQueue.Builder setProperties(List<OFQueueProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFPacketQueue build() {
            List<OFQueueProp> properties;
            long queueId = this.queueIdSet ? this.queueId : 0L;
            List<OFQueueProp> list = properties = this.propertiesSet ? this.properties : DEFAULT_PROPERTIES;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFPacketQueueVer11(queueId, properties);
        }
    }

    static class BuilderWithParent
    implements OFPacketQueue.Builder {
        final OFPacketQueueVer11 parentMessage;
        private boolean queueIdSet;
        private long queueId;
        private boolean propertiesSet;
        private List<OFQueueProp> properties;

        BuilderWithParent(OFPacketQueueVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getQueueId() {
            return this.queueId;
        }

        @Override
        public OFPacketQueue.Builder setQueueId(long queueId) {
            this.queueId = queueId;
            this.queueIdSet = true;
            return this;
        }

        @Override
        public OFPort getPort() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property port not supported in version 1.1");
        }

        @Override
        public OFPacketQueue.Builder setPort(OFPort port) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property port not supported in version 1.1");
        }

        @Override
        public List<OFQueueProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFPacketQueue.Builder setProperties(List<OFQueueProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFPacketQueue build() {
            List properties;
            long queueId = this.queueIdSet ? this.queueId : this.parentMessage.queueId;
            List list = properties = this.propertiesSet ? this.properties : this.parentMessage.properties;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFPacketQueueVer11(queueId, properties);
        }
    }
}

