/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFConfigFlags;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFSetConfig;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver11.OFConfigFlagsSerializerVer11;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFSetConfigVer11
implements OFSetConfig {
    private static final Logger logger = LoggerFactory.getLogger(OFSetConfigVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int LENGTH = 12;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFConfigFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final int DEFAULT_MISS_SEND_LEN = 0;
    private final long xid;
    private final Set<OFConfigFlags> flags;
    private final int missSendLen;
    static final OFSetConfigVer11 DEFAULT = new OFSetConfigVer11(0L, DEFAULT_FLAGS, 0);
    static final Reader READER = new Reader();
    static final OFSetConfigVer11Funnel FUNNEL = new OFSetConfigVer11Funnel();
    static final Writer WRITER = new Writer();

    OFSetConfigVer11(long xid, Set<OFConfigFlags> flags, int missSendLen) {
        if (flags == null) {
            throw new NullPointerException("OFSetConfigVer11: property flags cannot be null");
        }
        this.xid = xid;
        this.flags = flags;
        this.missSendLen = missSendLen;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFType getType() {
        return OFType.SET_CONFIG;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public Set<OFConfigFlags> getFlags() {
        return this.flags;
    }

    @Override
    public int getMissSendLen() {
        return this.missSendLen;
    }

    @Override
    public OFSetConfig.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFSetConfigVer11(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("missSendLen=").append(this.missSendLen);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFSetConfigVer11 other = (OFSetConfigVer11)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return this.missSendLen == other.missSendLen;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + this.missSendLen;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFSetConfigVer11> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFSetConfigVer11 message) {
            bb.writeByte(2);
            bb.writeByte(9);
            bb.writeShort(12);
            bb.writeInt(U32.t(message.xid));
            OFConfigFlagsSerializerVer11.writeTo(bb, message.flags);
            bb.writeShort((int)U16.t(message.missSendLen));
        }
    }

    static class OFSetConfigVer11Funnel
    implements Funnel<OFSetConfigVer11> {
        private static final long serialVersionUID = 1L;

        OFSetConfigVer11Funnel() {
        }

        public void funnel(OFSetConfigVer11 message, PrimitiveSink sink) {
            sink.putByte((byte)2);
            sink.putByte((byte)9);
            sink.putShort((short)12);
            sink.putLong(message.xid);
            OFConfigFlagsSerializerVer11.putTo(message.flags, sink);
            sink.putInt(message.missSendLen);
        }
    }

    static class Reader
    implements OFMessageReader<OFSetConfig> {
        Reader() {
        }

        @Override
        public OFSetConfig readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 2) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_11(2), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 9) {
                throw new OFParseError("Wrong type: Expected=OFType.SET_CONFIG(9), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 12) {
                throw new OFParseError("Wrong length: Expected=12(12), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            Set<OFConfigFlags> flags = OFConfigFlagsSerializerVer11.readFrom(bb);
            int missSendLen = U16.f(bb.readShort());
            OFSetConfigVer11 setConfigVer11 = new OFSetConfigVer11(xid, flags, missSendLen);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)setConfigVer11);
            }
            return setConfigVer11;
        }
    }

    static class Builder
    implements OFSetConfig.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFConfigFlags> flags;
        private boolean missSendLenSet;
        private int missSendLen;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.SET_CONFIG;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFSetConfig.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public Set<OFConfigFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFSetConfig.Builder setFlags(Set<OFConfigFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public int getMissSendLen() {
            return this.missSendLen;
        }

        @Override
        public OFSetConfig.Builder setMissSendLen(int missSendLen) {
            this.missSendLen = missSendLen;
            this.missSendLenSet = true;
            return this;
        }

        @Override
        public OFSetConfig build() {
            Set<OFConfigFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFConfigFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            int missSendLen = this.missSendLenSet ? this.missSendLen : 0;
            return new OFSetConfigVer11(xid, flags, missSendLen);
        }
    }

    static class BuilderWithParent
    implements OFSetConfig.Builder {
        final OFSetConfigVer11 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFConfigFlags> flags;
        private boolean missSendLenSet;
        private int missSendLen;

        BuilderWithParent(OFSetConfigVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.SET_CONFIG;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFSetConfig.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public Set<OFConfigFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFSetConfig.Builder setFlags(Set<OFConfigFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public int getMissSendLen() {
            return this.missSendLen;
        }

        @Override
        public OFSetConfig.Builder setMissSendLen(int missSendLen) {
            this.missSendLen = missSendLen;
            this.missSendLenSet = true;
            return this;
        }

        @Override
        public OFSetConfig build() {
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            int missSendLen = this.missSendLenSet ? this.missSendLen : this.parentMessage.missSendLen;
            return new OFSetConfigVer11(xid, flags, missSendLen);
        }
    }
}

