/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionNiciraSetQueue;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionNiciraSetQueueVer12
implements OFActionNiciraSetQueue {
    private static final Logger logger = LoggerFactory.getLogger(OFActionNiciraSetQueueVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 16;
    private static final long DEFAULT_QUEUE_ID = 0L;
    private final long queueId;
    static final OFActionNiciraSetQueueVer12 DEFAULT = new OFActionNiciraSetQueueVer12(0L);
    static final Reader READER = new Reader();
    static final OFActionNiciraSetQueueVer12Funnel FUNNEL = new OFActionNiciraSetQueueVer12Funnel();
    static final Writer WRITER = new Writer();

    OFActionNiciraSetQueueVer12(long queueId) {
        this.queueId = queueId;
    }

    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 8992L;
    }

    @Override
    public int getSubtype() {
        return 4;
    }

    @Override
    public long getQueueId() {
        return this.queueId;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFActionNiciraSetQueue.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionNiciraSetQueueVer12(");
        b.append("queueId=").append(this.queueId);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionNiciraSetQueueVer12 other = (OFActionNiciraSetQueueVer12)obj;
        return this.queueId == other.queueId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.queueId ^ this.queueId >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionNiciraSetQueueVer12> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFActionNiciraSetQueueVer12 message) {
            bb.writeShort(-1);
            bb.writeShort(16);
            bb.writeInt(8992);
            bb.writeShort(4);
            bb.writeZero(2);
            bb.writeInt(U32.t(message.queueId));
        }
    }

    static class OFActionNiciraSetQueueVer12Funnel
    implements Funnel<OFActionNiciraSetQueueVer12> {
        private static final long serialVersionUID = 1L;

        OFActionNiciraSetQueueVer12Funnel() {
        }

        public void funnel(OFActionNiciraSetQueueVer12 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)16);
            sink.putInt(8992);
            sink.putShort((short)4);
            sink.putLong(message.queueId);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionNiciraSetQueue> {
        Reader() {
        }

        @Override
        public OFActionNiciraSetQueue readFrom(ChannelBuffer bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 16) {
                throw new OFParseError("Wrong length: Expected=16(16), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 8992) {
                throw new OFParseError("Wrong experimenter: Expected=0x2320L(0x2320L), got=" + experimenter);
            }
            short subtype = bb.readShort();
            if (subtype != 4) {
                throw new OFParseError("Wrong subtype: Expected=0x4(0x4), got=" + subtype);
            }
            bb.skipBytes(2);
            long queueId = U32.f(bb.readInt());
            OFActionNiciraSetQueueVer12 actionNiciraSetQueueVer12 = new OFActionNiciraSetQueueVer12(queueId);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionNiciraSetQueueVer12);
            }
            return actionNiciraSetQueueVer12;
        }
    }

    static class Builder
    implements OFActionNiciraSetQueue.Builder {
        private boolean queueIdSet;
        private long queueId;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.EXPERIMENTER;
        }

        @Override
        public long getExperimenter() {
            return 8992L;
        }

        @Override
        public int getSubtype() {
            return 4;
        }

        @Override
        public long getQueueId() {
            return this.queueId;
        }

        @Override
        public OFActionNiciraSetQueue.Builder setQueueId(long queueId) {
            this.queueId = queueId;
            this.queueIdSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFActionNiciraSetQueue build() {
            long queueId = this.queueIdSet ? this.queueId : 0L;
            return new OFActionNiciraSetQueueVer12(queueId);
        }
    }

    static class BuilderWithParent
    implements OFActionNiciraSetQueue.Builder {
        final OFActionNiciraSetQueueVer12 parentMessage;
        private boolean queueIdSet;
        private long queueId;

        BuilderWithParent(OFActionNiciraSetQueueVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.EXPERIMENTER;
        }

        @Override
        public long getExperimenter() {
            return 8992L;
        }

        @Override
        public int getSubtype() {
            return 4;
        }

        @Override
        public long getQueueId() {
            return this.queueId;
        }

        @Override
        public OFActionNiciraSetQueue.Builder setQueueId(long queueId) {
            this.queueId = queueId;
            this.queueIdSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFActionNiciraSetQueue build() {
            long queueId = this.queueIdSet ? this.queueId : this.parentMessage.queueId;
            return new OFActionNiciraSetQueueVer12(queueId);
        }
    }
}

