/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionSetMplsTtl;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionSetMplsTtlVer12
implements OFActionSetMplsTtl {
    private static final Logger logger = LoggerFactory.getLogger(OFActionSetMplsTtlVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 8;
    private static final short DEFAULT_MPLS_TTL = 0;
    private final short mplsTtl;
    static final OFActionSetMplsTtlVer12 DEFAULT = new OFActionSetMplsTtlVer12(0);
    static final Reader READER = new Reader();
    static final OFActionSetMplsTtlVer12Funnel FUNNEL = new OFActionSetMplsTtlVer12Funnel();
    static final Writer WRITER = new Writer();

    OFActionSetMplsTtlVer12(short mplsTtl) {
        this.mplsTtl = mplsTtl;
    }

    @Override
    public OFActionType getType() {
        return OFActionType.SET_MPLS_TTL;
    }

    @Override
    public short getMplsTtl() {
        return this.mplsTtl;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFActionSetMplsTtl.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionSetMplsTtlVer12(");
        b.append("mplsTtl=").append(this.mplsTtl);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionSetMplsTtlVer12 other = (OFActionSetMplsTtlVer12)obj;
        return this.mplsTtl == other.mplsTtl;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.mplsTtl;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionSetMplsTtlVer12> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFActionSetMplsTtlVer12 message) {
            bb.writeShort(15);
            bb.writeShort(8);
            bb.writeByte((int)U8.t(message.mplsTtl));
            bb.writeZero(3);
        }
    }

    static class OFActionSetMplsTtlVer12Funnel
    implements Funnel<OFActionSetMplsTtlVer12> {
        private static final long serialVersionUID = 1L;

        OFActionSetMplsTtlVer12Funnel() {
        }

        public void funnel(OFActionSetMplsTtlVer12 message, PrimitiveSink sink) {
            sink.putShort((short)15);
            sink.putShort((short)8);
            sink.putShort(message.mplsTtl);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionSetMplsTtl> {
        Reader() {
        }

        @Override
        public OFActionSetMplsTtl readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 15) {
                throw new OFParseError("Wrong type: Expected=OFActionType.SET_MPLS_TTL(15), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            short mplsTtl = U8.f(bb.readByte());
            bb.skipBytes(3);
            OFActionSetMplsTtlVer12 actionSetMplsTtlVer12 = new OFActionSetMplsTtlVer12(mplsTtl);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionSetMplsTtlVer12);
            }
            return actionSetMplsTtlVer12;
        }
    }

    static class Builder
    implements OFActionSetMplsTtl.Builder {
        private boolean mplsTtlSet;
        private short mplsTtl;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_MPLS_TTL;
        }

        @Override
        public short getMplsTtl() {
            return this.mplsTtl;
        }

        @Override
        public OFActionSetMplsTtl.Builder setMplsTtl(short mplsTtl) {
            this.mplsTtl = mplsTtl;
            this.mplsTtlSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFActionSetMplsTtl build() {
            short mplsTtl = this.mplsTtlSet ? this.mplsTtl : (short)0;
            return new OFActionSetMplsTtlVer12(mplsTtl);
        }
    }

    static class BuilderWithParent
    implements OFActionSetMplsTtl.Builder {
        final OFActionSetMplsTtlVer12 parentMessage;
        private boolean mplsTtlSet;
        private short mplsTtl;

        BuilderWithParent(OFActionSetMplsTtlVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_MPLS_TTL;
        }

        @Override
        public short getMplsTtl() {
            return this.mplsTtl;
        }

        @Override
        public OFActionSetMplsTtl.Builder setMplsTtl(short mplsTtl) {
            this.mplsTtl = mplsTtl;
            this.mplsTtlSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFActionSetMplsTtl build() {
            short mplsTtl = this.mplsTtlSet ? this.mplsTtl : this.parentMessage.mplsTtl;
            return new OFActionSetMplsTtlVer12(mplsTtl);
        }
    }
}

