/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnHeader;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.ver12.OFBsnBwClearDataReplyVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFBsnBwClearDataRequestVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFBsnBwEnableGetReplyVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFBsnBwEnableGetRequestVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFBsnBwEnableSetReplyVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFBsnBwEnableSetRequestVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFBsnGetInterfacesReplyVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFBsnGetInterfacesRequestVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFBsnGetMirroringReplyVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFBsnGetMirroringRequestVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFBsnPduRxReplyVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFBsnPduRxRequestVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFBsnPduRxTimeoutVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFBsnPduTxReplyVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFBsnPduTxRequestVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFBsnSetMirroringVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFBsnSetPktinSuppressionReplyVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFBsnSetPktinSuppressionRequestVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFBsnVirtualPortCreateReplyVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFBsnVirtualPortCreateRequestVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFBsnVirtualPortRemoveReplyVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFBsnVirtualPortRemoveRequestVer12;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;

abstract class OFBsnHeaderVer12 {
    static final byte WIRE_VERSION = 3;
    static final int MINIMUM_LENGTH = 16;
    public static final Reader READER = new Reader();

    OFBsnHeaderVer12() {
    }

    static class Reader
    implements OFMessageReader<OFBsnHeader> {
        Reader() {
        }

        @Override
        public OFBsnHeader readFrom(ChannelBuffer bb) throws OFParseError {
            if (bb.readableBytes() < 16) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 3) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_12(3), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            bb.readerIndex(start);
            switch (subtype) {
                case 22: {
                    return OFBsnBwClearDataReplyVer12.READER.readFrom(bb);
                }
                case 21: {
                    return OFBsnBwClearDataRequestVer12.READER.readFrom(bb);
                }
                case 20: {
                    return OFBsnBwEnableGetReplyVer12.READER.readFrom(bb);
                }
                case 19: {
                    return OFBsnBwEnableGetRequestVer12.READER.readFrom(bb);
                }
                case 23: {
                    return OFBsnBwEnableSetReplyVer12.READER.readFrom(bb);
                }
                case 18: {
                    return OFBsnBwEnableSetRequestVer12.READER.readFrom(bb);
                }
                case 10: {
                    return OFBsnGetInterfacesReplyVer12.READER.readFrom(bb);
                }
                case 9: {
                    return OFBsnGetInterfacesRequestVer12.READER.readFrom(bb);
                }
                case 5: {
                    return OFBsnGetMirroringReplyVer12.READER.readFrom(bb);
                }
                case 4: {
                    return OFBsnGetMirroringRequestVer12.READER.readFrom(bb);
                }
                case 34: {
                    return OFBsnPduRxReplyVer12.READER.readFrom(bb);
                }
                case 33: {
                    return OFBsnPduRxRequestVer12.READER.readFrom(bb);
                }
                case 35: {
                    return OFBsnPduRxTimeoutVer12.READER.readFrom(bb);
                }
                case 32: {
                    return OFBsnPduTxReplyVer12.READER.readFrom(bb);
                }
                case 31: {
                    return OFBsnPduTxRequestVer12.READER.readFrom(bb);
                }
                case 3: {
                    return OFBsnSetMirroringVer12.READER.readFrom(bb);
                }
                case 25: {
                    return OFBsnSetPktinSuppressionReplyVer12.READER.readFrom(bb);
                }
                case 11: {
                    return OFBsnSetPktinSuppressionRequestVer12.READER.readFrom(bb);
                }
                case 16: {
                    return OFBsnVirtualPortCreateReplyVer12.READER.readFrom(bb);
                }
                case 15: {
                    return OFBsnVirtualPortCreateRequestVer12.READER.readFrom(bb);
                }
                case 26: {
                    return OFBsnVirtualPortRemoveReplyVer12.READER.readFrom(bb);
                }
                case 17: {
                    return OFBsnVirtualPortRemoveRequestVer12.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator subtype of class OFBsnHeaderVer12: " + subtype);
        }
    }
}

