/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFGroupStatsRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFStatsRequestFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver12.OFStatsRequestFlagsSerializerVer12;
import org.projectfloodlight.openflow.types.OFGroup;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFGroupStatsRequestVer12
implements OFGroupStatsRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFGroupStatsRequestVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 24;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFStatsRequestFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final OFGroup DEFAULT_GROUP_ID = OFGroup.ALL;
    private final long xid;
    private final Set<OFStatsRequestFlags> flags;
    private final OFGroup group;
    static final OFGroupStatsRequestVer12 DEFAULT = new OFGroupStatsRequestVer12(0L, DEFAULT_FLAGS, DEFAULT_GROUP_ID);
    static final Reader READER = new Reader();
    static final OFGroupStatsRequestVer12Funnel FUNNEL = new OFGroupStatsRequestVer12Funnel();
    static final Writer WRITER = new Writer();

    OFGroupStatsRequestVer12(long xid, Set<OFStatsRequestFlags> flags, OFGroup group) {
        if (flags == null) {
            throw new NullPointerException("OFGroupStatsRequestVer12: property flags cannot be null");
        }
        if (group == null) {
            throw new NullPointerException("OFGroupStatsRequestVer12: property group cannot be null");
        }
        this.xid = xid;
        this.flags = flags;
        this.group = group;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REQUEST;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.GROUP;
    }

    @Override
    public Set<OFStatsRequestFlags> getFlags() {
        return this.flags;
    }

    @Override
    public OFGroup getGroup() {
        return this.group;
    }

    @Override
    public OFGroupStatsRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFGroupStatsRequestVer12(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("group=").append(this.group);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFGroupStatsRequestVer12 other = (OFGroupStatsRequestVer12)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return !(this.group == null ? other.group != null : !this.group.equals(other.group));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFGroupStatsRequestVer12> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFGroupStatsRequestVer12 message) {
            bb.writeByte(3);
            bb.writeByte(18);
            bb.writeShort(24);
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(6);
            OFStatsRequestFlagsSerializerVer12.writeTo(bb, message.flags);
            bb.writeZero(4);
            message.group.write4Bytes(bb);
            bb.writeZero(4);
        }
    }

    static class OFGroupStatsRequestVer12Funnel
    implements Funnel<OFGroupStatsRequestVer12> {
        private static final long serialVersionUID = 1L;

        OFGroupStatsRequestVer12Funnel() {
        }

        public void funnel(OFGroupStatsRequestVer12 message, PrimitiveSink sink) {
            sink.putByte((byte)3);
            sink.putByte((byte)18);
            sink.putShort((short)24);
            sink.putLong(message.xid);
            sink.putShort((short)6);
            OFStatsRequestFlagsSerializerVer12.putTo(message.flags, sink);
            message.group.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFGroupStatsRequest> {
        Reader() {
        }

        @Override
        public OFGroupStatsRequest readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 3) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_12(3), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 18) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REQUEST(18), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 24) {
                throw new OFParseError("Wrong length: Expected=24(24), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != 6) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.GROUP(6), got=" + statsType);
            }
            Set<OFStatsRequestFlags> flags = OFStatsRequestFlagsSerializerVer12.readFrom(bb);
            bb.skipBytes(4);
            OFGroup group = OFGroup.read4Bytes(bb);
            bb.skipBytes(4);
            OFGroupStatsRequestVer12 groupStatsRequestVer12 = new OFGroupStatsRequestVer12(xid, flags, group);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)groupStatsRequestVer12);
            }
            return groupStatsRequestVer12;
        }
    }

    static class Builder
    implements OFGroupStatsRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;
        private boolean groupSet;
        private OFGroup group;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFGroupStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.GROUP;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFGroupStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public OFGroup getGroup() {
            return this.group;
        }

        @Override
        public OFGroupStatsRequest.Builder setGroup(OFGroup group) {
            this.group = group;
            this.groupSet = true;
            return this;
        }

        @Override
        public OFGroupStatsRequest build() {
            OFGroup group;
            Set<OFStatsRequestFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFStatsRequestFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            OFGroup oFGroup = group = this.groupSet ? this.group : DEFAULT_GROUP_ID;
            if (group == null) {
                throw new NullPointerException("Property group must not be null");
            }
            return new OFGroupStatsRequestVer12(xid, flags, group);
        }
    }

    static class BuilderWithParent
    implements OFGroupStatsRequest.Builder {
        final OFGroupStatsRequestVer12 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;
        private boolean groupSet;
        private OFGroup group;

        BuilderWithParent(OFGroupStatsRequestVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFGroupStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.GROUP;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFGroupStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public OFGroup getGroup() {
            return this.group;
        }

        @Override
        public OFGroupStatsRequest.Builder setGroup(OFGroup group) {
            this.group = group;
            this.groupSet = true;
            return this;
        }

        @Override
        public OFGroupStatsRequest build() {
            OFGroup group;
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            OFGroup oFGroup = group = this.groupSet ? this.group : this.parentMessage.group;
            if (group == null) {
                throw new NullPointerException("Property group must not be null");
            }
            return new OFGroupStatsRequestVer12(xid, flags, group);
        }
    }
}

