/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmIpDscp;
import org.projectfloodlight.openflow.types.IpDscp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmIpDscpVer12
implements OFOxmIpDscp {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmIpDscpVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 5;
    private static final IpDscp DEFAULT_VALUE = IpDscp.NONE;
    private final IpDscp value;
    static final OFOxmIpDscpVer12 DEFAULT = new OFOxmIpDscpVer12(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmIpDscpVer12Funnel FUNNEL = new OFOxmIpDscpVer12Funnel();
    static final Writer WRITER = new Writer();

    OFOxmIpDscpVer12(IpDscp value) {
        if (value == null) {
            throw new NullPointerException("OFOxmIpDscpVer12: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 0x80001001L;
    }

    @Override
    public IpDscp getValue() {
        return this.value;
    }

    @Override
    public MatchField<IpDscp> getMatchField() {
        return MatchField.IP_DSCP;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<IpDscp> getCanonical() {
        return this;
    }

    @Override
    public IpDscp getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.2");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFOxmIpDscp.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmIpDscpVer12(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmIpDscpVer12 other = (OFOxmIpDscpVer12)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmIpDscpVer12> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmIpDscpVer12 message) {
            bb.writeInt(-2147479551);
            message.value.writeByte(bb);
        }
    }

    static class OFOxmIpDscpVer12Funnel
    implements Funnel<OFOxmIpDscpVer12> {
        private static final long serialVersionUID = 1L;

        OFOxmIpDscpVer12Funnel() {
        }

        public void funnel(OFOxmIpDscpVer12 message, PrimitiveSink sink) {
            sink.putInt(-2147479551);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmIpDscp> {
        Reader() {
        }

        @Override
        public OFOxmIpDscp readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147479551) {
                throw new OFParseError("Wrong typeLen: Expected=0x80001001L(0x80001001L), got=" + typeLen);
            }
            IpDscp value = IpDscp.readByte(bb);
            OFOxmIpDscpVer12 oxmIpDscpVer12 = new OFOxmIpDscpVer12(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmIpDscpVer12);
            }
            return oxmIpDscpVer12;
        }
    }

    static class Builder
    implements OFOxmIpDscp.Builder {
        private boolean valueSet;
        private IpDscp value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 0x80001001L;
        }

        @Override
        public IpDscp getValue() {
            return this.value;
        }

        @Override
        public OFOxmIpDscp.Builder setValue(IpDscp value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<IpDscp> getMatchField() {
            return MatchField.IP_DSCP;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<IpDscp> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public IpDscp getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmIpDscp build() {
            IpDscp value;
            IpDscp ipDscp = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmIpDscpVer12(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmIpDscp.Builder {
        final OFOxmIpDscpVer12 parentMessage;
        private boolean valueSet;
        private IpDscp value;

        BuilderWithParent(OFOxmIpDscpVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 0x80001001L;
        }

        @Override
        public IpDscp getValue() {
            return this.value;
        }

        @Override
        public OFOxmIpDscp.Builder setValue(IpDscp value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<IpDscp> getMatchField() {
            return MatchField.IP_DSCP;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<IpDscp> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public IpDscp getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmIpDscp build() {
            IpDscp value;
            IpDscp ipDscp = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmIpDscpVer12(value);
        }
    }
}

