/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmReg5;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmReg5Ver12
implements OFOxmReg5 {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmReg5Ver12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 8;
    private static final U32 DEFAULT_VALUE = U32.ZERO;
    private final U32 value;
    static final OFOxmReg5Ver12 DEFAULT = new OFOxmReg5Ver12(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmReg5Ver12Funnel FUNNEL = new OFOxmReg5Ver12Funnel();
    static final Writer WRITER = new Writer();

    OFOxmReg5Ver12(U32 value) {
        if (value == null) {
            throw new NullPointerException("OFOxmReg5Ver12: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 68100L;
    }

    @Override
    public U32 getValue() {
        return this.value;
    }

    @Override
    public MatchField<U32> getMatchField() {
        return MatchField.REG5;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<U32> getCanonical() {
        return this;
    }

    @Override
    public U32 getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.2");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFOxmReg5.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmReg5Ver12(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmReg5Ver12 other = (OFOxmReg5Ver12)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmReg5Ver12> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmReg5Ver12 message) {
            bb.writeInt(68100);
            bb.writeInt(message.value.getRaw());
        }
    }

    static class OFOxmReg5Ver12Funnel
    implements Funnel<OFOxmReg5Ver12> {
        private static final long serialVersionUID = 1L;

        OFOxmReg5Ver12Funnel() {
        }

        public void funnel(OFOxmReg5Ver12 message, PrimitiveSink sink) {
            sink.putInt(68100);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmReg5> {
        Reader() {
        }

        @Override
        public OFOxmReg5 readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 68100) {
                throw new OFParseError("Wrong typeLen: Expected=0x10a04L(0x10a04L), got=" + typeLen);
            }
            U32 value = U32.of(bb.readInt());
            OFOxmReg5Ver12 oxmReg5Ver12 = new OFOxmReg5Ver12(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmReg5Ver12);
            }
            return oxmReg5Ver12;
        }
    }

    static class Builder
    implements OFOxmReg5.Builder {
        private boolean valueSet;
        private U32 value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 68100L;
        }

        @Override
        public U32 getValue() {
            return this.value;
        }

        @Override
        public OFOxmReg5.Builder setValue(U32 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U32> getMatchField() {
            return MatchField.REG5;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U32> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public U32 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmReg5 build() {
            U32 value;
            U32 u32 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmReg5Ver12(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmReg5.Builder {
        final OFOxmReg5Ver12 parentMessage;
        private boolean valueSet;
        private U32 value;

        BuilderWithParent(OFOxmReg5Ver12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 68100L;
        }

        @Override
        public U32 getValue() {
            return this.value;
        }

        @Override
        public OFOxmReg5.Builder setValue(U32 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U32> getMatchField() {
            return MatchField.REG5;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U32> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public U32 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmReg5 build() {
            U32 value;
            U32 u32 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmReg5Ver12(value);
        }
    }
}

