/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmReg6;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmReg6Ver12
implements OFOxmReg6 {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmReg6Ver12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 8;
    private static final U32 DEFAULT_VALUE = U32.ZERO;
    private final U32 value;
    static final OFOxmReg6Ver12 DEFAULT = new OFOxmReg6Ver12(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmReg6Ver12Funnel FUNNEL = new OFOxmReg6Ver12Funnel();
    static final Writer WRITER = new Writer();

    OFOxmReg6Ver12(U32 value) {
        if (value == null) {
            throw new NullPointerException("OFOxmReg6Ver12: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 68612L;
    }

    @Override
    public U32 getValue() {
        return this.value;
    }

    @Override
    public MatchField<U32> getMatchField() {
        return MatchField.REG6;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<U32> getCanonical() {
        return this;
    }

    @Override
    public U32 getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.2");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFOxmReg6.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmReg6Ver12(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmReg6Ver12 other = (OFOxmReg6Ver12)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmReg6Ver12> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmReg6Ver12 message) {
            bb.writeInt(68612);
            bb.writeInt(message.value.getRaw());
        }
    }

    static class OFOxmReg6Ver12Funnel
    implements Funnel<OFOxmReg6Ver12> {
        private static final long serialVersionUID = 1L;

        OFOxmReg6Ver12Funnel() {
        }

        public void funnel(OFOxmReg6Ver12 message, PrimitiveSink sink) {
            sink.putInt(68612);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmReg6> {
        Reader() {
        }

        @Override
        public OFOxmReg6 readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 68612) {
                throw new OFParseError("Wrong typeLen: Expected=0x10c04L(0x10c04L), got=" + typeLen);
            }
            U32 value = U32.of(bb.readInt());
            OFOxmReg6Ver12 oxmReg6Ver12 = new OFOxmReg6Ver12(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmReg6Ver12);
            }
            return oxmReg6Ver12;
        }
    }

    static class Builder
    implements OFOxmReg6.Builder {
        private boolean valueSet;
        private U32 value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 68612L;
        }

        @Override
        public U32 getValue() {
            return this.value;
        }

        @Override
        public OFOxmReg6.Builder setValue(U32 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U32> getMatchField() {
            return MatchField.REG6;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U32> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public U32 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmReg6 build() {
            U32 value;
            U32 u32 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmReg6Ver12(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmReg6.Builder {
        final OFOxmReg6Ver12 parentMessage;
        private boolean valueSet;
        private U32 value;

        BuilderWithParent(OFOxmReg6Ver12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 68612L;
        }

        @Override
        public U32 getValue() {
            return this.value;
        }

        @Override
        public OFOxmReg6.Builder setValue(U32 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U32> getMatchField() {
            return MatchField.REG6;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U32> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public U32 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmReg6 build() {
            U32 value;
            U32 u32 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmReg6Ver12(value);
        }
    }
}

