/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmTcpDst;
import org.projectfloodlight.openflow.types.TransportPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmTcpDstVer12
implements OFOxmTcpDst {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmTcpDstVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 6;
    private static final TransportPort DEFAULT_VALUE = TransportPort.NONE;
    private final TransportPort value;
    static final OFOxmTcpDstVer12 DEFAULT = new OFOxmTcpDstVer12(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmTcpDstVer12Funnel FUNNEL = new OFOxmTcpDstVer12Funnel();
    static final Writer WRITER = new Writer();

    OFOxmTcpDstVer12(TransportPort value) {
        if (value == null) {
            throw new NullPointerException("OFOxmTcpDstVer12: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 2147490818L;
    }

    @Override
    public TransportPort getValue() {
        return this.value;
    }

    @Override
    public MatchField<TransportPort> getMatchField() {
        return MatchField.TCP_DST;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<TransportPort> getCanonical() {
        return this;
    }

    @Override
    public TransportPort getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.2");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFOxmTcpDst.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmTcpDstVer12(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmTcpDstVer12 other = (OFOxmTcpDstVer12)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmTcpDstVer12> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmTcpDstVer12 message) {
            bb.writeInt(-2147476478);
            message.value.write2Bytes(bb);
        }
    }

    static class OFOxmTcpDstVer12Funnel
    implements Funnel<OFOxmTcpDstVer12> {
        private static final long serialVersionUID = 1L;

        OFOxmTcpDstVer12Funnel() {
        }

        public void funnel(OFOxmTcpDstVer12 message, PrimitiveSink sink) {
            sink.putInt(-2147476478);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmTcpDst> {
        Reader() {
        }

        @Override
        public OFOxmTcpDst readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147476478) {
                throw new OFParseError("Wrong typeLen: Expected=0x80001c02L(0x80001c02L), got=" + typeLen);
            }
            TransportPort value = TransportPort.read2Bytes(bb);
            OFOxmTcpDstVer12 oxmTcpDstVer12 = new OFOxmTcpDstVer12(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmTcpDstVer12);
            }
            return oxmTcpDstVer12;
        }
    }

    static class Builder
    implements OFOxmTcpDst.Builder {
        private boolean valueSet;
        private TransportPort value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147490818L;
        }

        @Override
        public TransportPort getValue() {
            return this.value;
        }

        @Override
        public OFOxmTcpDst.Builder setValue(TransportPort value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<TransportPort> getMatchField() {
            return MatchField.TCP_DST;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<TransportPort> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public TransportPort getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmTcpDst build() {
            TransportPort value;
            TransportPort transportPort = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmTcpDstVer12(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmTcpDst.Builder {
        final OFOxmTcpDstVer12 parentMessage;
        private boolean valueSet;
        private TransportPort value;

        BuilderWithParent(OFOxmTcpDstVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147490818L;
        }

        @Override
        public TransportPort getValue() {
            return this.value;
        }

        @Override
        public OFOxmTcpDst.Builder setValue(TransportPort value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<TransportPort> getMatchField() {
            return MatchField.TCP_DST;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<TransportPort> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public TransportPort getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmTcpDst build() {
            TransportPort value;
            TransportPort transportPort = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmTcpDstVer12(value);
        }
    }
}

