/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.queueprop.OFQueuePropMinRate;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFQueuePropMinRateVer12
implements OFQueuePropMinRate {
    private static final Logger logger = LoggerFactory.getLogger(OFQueuePropMinRateVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 16;
    private static final int DEFAULT_RATE = 0;
    private final int rate;
    static final OFQueuePropMinRateVer12 DEFAULT = new OFQueuePropMinRateVer12(0);
    static final Reader READER = new Reader();
    static final OFQueuePropMinRateVer12Funnel FUNNEL = new OFQueuePropMinRateVer12Funnel();
    static final Writer WRITER = new Writer();

    OFQueuePropMinRateVer12(int rate) {
        this.rate = rate;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public int getRate() {
        return this.rate;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFQueuePropMinRate.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFQueuePropMinRateVer12(");
        b.append("rate=").append(this.rate);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFQueuePropMinRateVer12 other = (OFQueuePropMinRateVer12)obj;
        return this.rate == other.rate;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.rate;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFQueuePropMinRateVer12> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFQueuePropMinRateVer12 message) {
            bb.writeShort(1);
            bb.writeShort(16);
            bb.writeZero(4);
            bb.writeShort((int)U16.t(message.rate));
            bb.writeZero(6);
        }
    }

    static class OFQueuePropMinRateVer12Funnel
    implements Funnel<OFQueuePropMinRateVer12> {
        private static final long serialVersionUID = 1L;

        OFQueuePropMinRateVer12Funnel() {
        }

        public void funnel(OFQueuePropMinRateVer12 message, PrimitiveSink sink) {
            sink.putShort((short)1);
            sink.putShort((short)16);
            sink.putInt(message.rate);
        }
    }

    static class Reader
    implements OFMessageReader<OFQueuePropMinRate> {
        Reader() {
        }

        @Override
        public OFQueuePropMinRate readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 1) {
                throw new OFParseError("Wrong type: Expected=0x1(0x1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 16) {
                throw new OFParseError("Wrong length: Expected=16(16), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(4);
            int rate = U16.f(bb.readShort());
            bb.skipBytes(6);
            OFQueuePropMinRateVer12 queuePropMinRateVer12 = new OFQueuePropMinRateVer12(rate);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)queuePropMinRateVer12);
            }
            return queuePropMinRateVer12;
        }
    }

    static class Builder
    implements OFQueuePropMinRate.Builder {
        private boolean rateSet;
        private int rate;

        Builder() {
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public int getRate() {
            return this.rate;
        }

        @Override
        public OFQueuePropMinRate.Builder setRate(int rate) {
            this.rate = rate;
            this.rateSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFQueuePropMinRate build() {
            int rate = this.rateSet ? this.rate : 0;
            return new OFQueuePropMinRateVer12(rate);
        }
    }

    static class BuilderWithParent
    implements OFQueuePropMinRate.Builder {
        final OFQueuePropMinRateVer12 parentMessage;
        private boolean rateSet;
        private int rate;

        BuilderWithParent(OFQueuePropMinRateVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public int getRate() {
            return this.rate;
        }

        @Override
        public OFQueuePropMinRate.Builder setRate(int rate) {
            this.rate = rate;
            this.rateSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFQueuePropMinRate build() {
            int rate = this.rateSet ? this.rate : this.parentMessage.rate;
            return new OFQueuePropMinRateVer12(rate);
        }
    }
}

