/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionNiciraSetNshc2;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionNiciraSetNshc2Ver13
implements OFActionNiciraSetNshc2 {
    private static final Logger logger = LoggerFactory.getLogger(OFActionNiciraSetNshc2Ver13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 16;
    private static final long DEFAULT_NSHC2 = 0L;
    private final long nshc2;
    static final OFActionNiciraSetNshc2Ver13 DEFAULT = new OFActionNiciraSetNshc2Ver13(0L);
    static final Reader READER = new Reader();
    static final OFActionNiciraSetNshc2Ver13Funnel FUNNEL = new OFActionNiciraSetNshc2Ver13Funnel();
    static final Writer WRITER = new Writer();

    OFActionNiciraSetNshc2Ver13(long nshc2) {
        this.nshc2 = nshc2;
    }

    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 8992L;
    }

    @Override
    public int getSubtype() {
        return 35;
    }

    @Override
    public long getNshc2() {
        return this.nshc2;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFActionNiciraSetNshc2.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionNiciraSetNshc2Ver13(");
        b.append("nshc2=").append(this.nshc2);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionNiciraSetNshc2Ver13 other = (OFActionNiciraSetNshc2Ver13)obj;
        return this.nshc2 == other.nshc2;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.nshc2 ^ this.nshc2 >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionNiciraSetNshc2Ver13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFActionNiciraSetNshc2Ver13 message) {
            bb.writeShort(-1);
            bb.writeShort(16);
            bb.writeInt(8992);
            bb.writeShort(35);
            bb.writeZero(2);
            bb.writeInt(U32.t(message.nshc2));
        }
    }

    static class OFActionNiciraSetNshc2Ver13Funnel
    implements Funnel<OFActionNiciraSetNshc2Ver13> {
        private static final long serialVersionUID = 1L;

        OFActionNiciraSetNshc2Ver13Funnel() {
        }

        public void funnel(OFActionNiciraSetNshc2Ver13 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)16);
            sink.putInt(8992);
            sink.putShort((short)35);
            sink.putLong(message.nshc2);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionNiciraSetNshc2> {
        Reader() {
        }

        @Override
        public OFActionNiciraSetNshc2 readFrom(ChannelBuffer bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 16) {
                throw new OFParseError("Wrong length: Expected=16(16), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 8992) {
                throw new OFParseError("Wrong experimenter: Expected=0x2320L(0x2320L), got=" + experimenter);
            }
            short subtype = bb.readShort();
            if (subtype != 35) {
                throw new OFParseError("Wrong subtype: Expected=0x23(0x23), got=" + subtype);
            }
            bb.skipBytes(2);
            long nshc2 = U32.f(bb.readInt());
            OFActionNiciraSetNshc2Ver13 actionNiciraSetNshc2Ver13 = new OFActionNiciraSetNshc2Ver13(nshc2);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionNiciraSetNshc2Ver13);
            }
            return actionNiciraSetNshc2Ver13;
        }
    }

    static class Builder
    implements OFActionNiciraSetNshc2.Builder {
        private boolean nshc2Set;
        private long nshc2;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.EXPERIMENTER;
        }

        @Override
        public long getExperimenter() {
            return 8992L;
        }

        @Override
        public int getSubtype() {
            return 35;
        }

        @Override
        public long getNshc2() {
            return this.nshc2;
        }

        @Override
        public OFActionNiciraSetNshc2.Builder setNshc2(long nshc2) {
            this.nshc2 = nshc2;
            this.nshc2Set = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFActionNiciraSetNshc2 build() {
            long nshc2 = this.nshc2Set ? this.nshc2 : 0L;
            return new OFActionNiciraSetNshc2Ver13(nshc2);
        }
    }

    static class BuilderWithParent
    implements OFActionNiciraSetNshc2.Builder {
        final OFActionNiciraSetNshc2Ver13 parentMessage;
        private boolean nshc2Set;
        private long nshc2;

        BuilderWithParent(OFActionNiciraSetNshc2Ver13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.EXPERIMENTER;
        }

        @Override
        public long getExperimenter() {
            return 8992L;
        }

        @Override
        public int getSubtype() {
            return 35;
        }

        @Override
        public long getNshc2() {
            return this.nshc2;
        }

        @Override
        public OFActionNiciraSetNshc2.Builder setNshc2(long nshc2) {
            this.nshc2 = nshc2;
            this.nshc2Set = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFActionNiciraSetNshc2 build() {
            long nshc2 = this.nshc2Set ? this.nshc2 : this.parentMessage.nshc2;
            return new OFActionNiciraSetNshc2Ver13(nshc2);
        }
    }
}

