/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionNiciraSetNshc3;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionNiciraSetNshc3Ver13
implements OFActionNiciraSetNshc3 {
    private static final Logger logger = LoggerFactory.getLogger(OFActionNiciraSetNshc3Ver13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 16;
    private static final long DEFAULT_NSHC3 = 0L;
    private final long nshc3;
    static final OFActionNiciraSetNshc3Ver13 DEFAULT = new OFActionNiciraSetNshc3Ver13(0L);
    static final Reader READER = new Reader();
    static final OFActionNiciraSetNshc3Ver13Funnel FUNNEL = new OFActionNiciraSetNshc3Ver13Funnel();
    static final Writer WRITER = new Writer();

    OFActionNiciraSetNshc3Ver13(long nshc3) {
        this.nshc3 = nshc3;
    }

    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 8992L;
    }

    @Override
    public int getSubtype() {
        return 36;
    }

    @Override
    public long getNshc3() {
        return this.nshc3;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFActionNiciraSetNshc3.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionNiciraSetNshc3Ver13(");
        b.append("nshc3=").append(this.nshc3);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionNiciraSetNshc3Ver13 other = (OFActionNiciraSetNshc3Ver13)obj;
        return this.nshc3 == other.nshc3;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.nshc3 ^ this.nshc3 >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionNiciraSetNshc3Ver13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFActionNiciraSetNshc3Ver13 message) {
            bb.writeShort(-1);
            bb.writeShort(16);
            bb.writeInt(8992);
            bb.writeShort(36);
            bb.writeZero(2);
            bb.writeInt(U32.t(message.nshc3));
        }
    }

    static class OFActionNiciraSetNshc3Ver13Funnel
    implements Funnel<OFActionNiciraSetNshc3Ver13> {
        private static final long serialVersionUID = 1L;

        OFActionNiciraSetNshc3Ver13Funnel() {
        }

        public void funnel(OFActionNiciraSetNshc3Ver13 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)16);
            sink.putInt(8992);
            sink.putShort((short)36);
            sink.putLong(message.nshc3);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionNiciraSetNshc3> {
        Reader() {
        }

        @Override
        public OFActionNiciraSetNshc3 readFrom(ChannelBuffer bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 16) {
                throw new OFParseError("Wrong length: Expected=16(16), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 8992) {
                throw new OFParseError("Wrong experimenter: Expected=0x2320L(0x2320L), got=" + experimenter);
            }
            short subtype = bb.readShort();
            if (subtype != 36) {
                throw new OFParseError("Wrong subtype: Expected=0x24(0x24), got=" + subtype);
            }
            bb.skipBytes(2);
            long nshc3 = U32.f(bb.readInt());
            OFActionNiciraSetNshc3Ver13 actionNiciraSetNshc3Ver13 = new OFActionNiciraSetNshc3Ver13(nshc3);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionNiciraSetNshc3Ver13);
            }
            return actionNiciraSetNshc3Ver13;
        }
    }

    static class Builder
    implements OFActionNiciraSetNshc3.Builder {
        private boolean nshc3Set;
        private long nshc3;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.EXPERIMENTER;
        }

        @Override
        public long getExperimenter() {
            return 8992L;
        }

        @Override
        public int getSubtype() {
            return 36;
        }

        @Override
        public long getNshc3() {
            return this.nshc3;
        }

        @Override
        public OFActionNiciraSetNshc3.Builder setNshc3(long nshc3) {
            this.nshc3 = nshc3;
            this.nshc3Set = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFActionNiciraSetNshc3 build() {
            long nshc3 = this.nshc3Set ? this.nshc3 : 0L;
            return new OFActionNiciraSetNshc3Ver13(nshc3);
        }
    }

    static class BuilderWithParent
    implements OFActionNiciraSetNshc3.Builder {
        final OFActionNiciraSetNshc3Ver13 parentMessage;
        private boolean nshc3Set;
        private long nshc3;

        BuilderWithParent(OFActionNiciraSetNshc3Ver13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.EXPERIMENTER;
        }

        @Override
        public long getExperimenter() {
            return 8992L;
        }

        @Override
        public int getSubtype() {
            return 36;
        }

        @Override
        public long getNshc3() {
            return this.nshc3;
        }

        @Override
        public OFActionNiciraSetNshc3.Builder setNshc3(long nshc3) {
            this.nshc3 = nshc3;
            this.nshc3Set = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFActionNiciraSetNshc3 build() {
            long nshc3 = this.nshc3Set ? this.nshc3 : this.parentMessage.nshc3;
            return new OFActionNiciraSetNshc3Ver13(nshc3);
        }
    }
}

