/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionNiciraSetNsp;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionNiciraSetNspVer13
implements OFActionNiciraSetNsp {
    private static final Logger logger = LoggerFactory.getLogger(OFActionNiciraSetNspVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 16;
    private static final long DEFAULT_NSP = 0L;
    private final long nsp;
    static final OFActionNiciraSetNspVer13 DEFAULT = new OFActionNiciraSetNspVer13(0L);
    static final Reader READER = new Reader();
    static final OFActionNiciraSetNspVer13Funnel FUNNEL = new OFActionNiciraSetNspVer13Funnel();
    static final Writer WRITER = new Writer();

    OFActionNiciraSetNspVer13(long nsp) {
        this.nsp = nsp;
    }

    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 8992L;
    }

    @Override
    public int getSubtype() {
        return 32;
    }

    @Override
    public long getNsp() {
        return this.nsp;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFActionNiciraSetNsp.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionNiciraSetNspVer13(");
        b.append("nsp=").append(this.nsp);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionNiciraSetNspVer13 other = (OFActionNiciraSetNspVer13)obj;
        return this.nsp == other.nsp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.nsp ^ this.nsp >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionNiciraSetNspVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFActionNiciraSetNspVer13 message) {
            bb.writeShort(-1);
            bb.writeShort(16);
            bb.writeInt(8992);
            bb.writeShort(32);
            bb.writeZero(2);
            bb.writeInt(U32.t(message.nsp));
        }
    }

    static class OFActionNiciraSetNspVer13Funnel
    implements Funnel<OFActionNiciraSetNspVer13> {
        private static final long serialVersionUID = 1L;

        OFActionNiciraSetNspVer13Funnel() {
        }

        public void funnel(OFActionNiciraSetNspVer13 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)16);
            sink.putInt(8992);
            sink.putShort((short)32);
            sink.putLong(message.nsp);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionNiciraSetNsp> {
        Reader() {
        }

        @Override
        public OFActionNiciraSetNsp readFrom(ChannelBuffer bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 16) {
                throw new OFParseError("Wrong length: Expected=16(16), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 8992) {
                throw new OFParseError("Wrong experimenter: Expected=0x2320L(0x2320L), got=" + experimenter);
            }
            short subtype = bb.readShort();
            if (subtype != 32) {
                throw new OFParseError("Wrong subtype: Expected=0x20(0x20), got=" + subtype);
            }
            bb.skipBytes(2);
            long nsp = U32.f(bb.readInt());
            OFActionNiciraSetNspVer13 actionNiciraSetNspVer13 = new OFActionNiciraSetNspVer13(nsp);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionNiciraSetNspVer13);
            }
            return actionNiciraSetNspVer13;
        }
    }

    static class Builder
    implements OFActionNiciraSetNsp.Builder {
        private boolean nspSet;
        private long nsp;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.EXPERIMENTER;
        }

        @Override
        public long getExperimenter() {
            return 8992L;
        }

        @Override
        public int getSubtype() {
            return 32;
        }

        @Override
        public long getNsp() {
            return this.nsp;
        }

        @Override
        public OFActionNiciraSetNsp.Builder setNsp(long nsp) {
            this.nsp = nsp;
            this.nspSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFActionNiciraSetNsp build() {
            long nsp = this.nspSet ? this.nsp : 0L;
            return new OFActionNiciraSetNspVer13(nsp);
        }
    }

    static class BuilderWithParent
    implements OFActionNiciraSetNsp.Builder {
        final OFActionNiciraSetNspVer13 parentMessage;
        private boolean nspSet;
        private long nsp;

        BuilderWithParent(OFActionNiciraSetNspVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.EXPERIMENTER;
        }

        @Override
        public long getExperimenter() {
            return 8992L;
        }

        @Override
        public int getSubtype() {
            return 32;
        }

        @Override
        public long getNsp() {
            return this.nsp;
        }

        @Override
        public OFActionNiciraSetNsp.Builder setNsp(long nsp) {
            this.nsp = nsp;
            this.nspSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFActionNiciraSetNsp build() {
            long nsp = this.nspSet ? this.nsp : this.parentMessage.nsp;
            return new OFActionNiciraSetNspVer13(nsp);
        }
    }
}

