/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnBwEnableGetReply;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnBwEnableGetReplyVer13
implements OFBsnBwEnableGetReply {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnBwEnableGetReplyVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 20;
    private static final long DEFAULT_XID = 0L;
    private static final long DEFAULT_ENABLED = 0L;
    private final long xid;
    private final long enabled;
    static final OFBsnBwEnableGetReplyVer13 DEFAULT = new OFBsnBwEnableGetReplyVer13(0L, 0L);
    static final Reader READER = new Reader();
    static final OFBsnBwEnableGetReplyVer13Funnel FUNNEL = new OFBsnBwEnableGetReplyVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnBwEnableGetReplyVer13(long xid, long enabled) {
        this.xid = xid;
        this.enabled = enabled;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 20L;
    }

    @Override
    public long getEnabled() {
        return this.enabled;
    }

    @Override
    public OFBsnBwEnableGetReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnBwEnableGetReplyVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("enabled=").append(this.enabled);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnBwEnableGetReplyVer13 other = (OFBsnBwEnableGetReplyVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        return this.enabled == other.enabled;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * (int)(this.enabled ^ this.enabled >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnBwEnableGetReplyVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnBwEnableGetReplyVer13 message) {
            bb.writeByte(4);
            bb.writeByte(4);
            bb.writeShort(20);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(20);
            bb.writeInt(U32.t(message.enabled));
        }
    }

    static class OFBsnBwEnableGetReplyVer13Funnel
    implements Funnel<OFBsnBwEnableGetReplyVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnBwEnableGetReplyVer13Funnel() {
        }

        public void funnel(OFBsnBwEnableGetReplyVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)4);
            sink.putShort((short)20);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(20);
            sink.putLong(message.enabled);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnBwEnableGetReply> {
        Reader() {
        }

        @Override
        public OFBsnBwEnableGetReply readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 20) {
                throw new OFParseError("Wrong length: Expected=20(20), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 20) {
                throw new OFParseError("Wrong subtype: Expected=0x14L(0x14L), got=" + subtype);
            }
            long enabled = U32.f(bb.readInt());
            OFBsnBwEnableGetReplyVer13 bsnBwEnableGetReplyVer13 = new OFBsnBwEnableGetReplyVer13(xid, enabled);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnBwEnableGetReplyVer13);
            }
            return bsnBwEnableGetReplyVer13;
        }
    }

    static class Builder
    implements OFBsnBwEnableGetReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean enabledSet;
        private long enabled;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnBwEnableGetReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 20L;
        }

        @Override
        public long getEnabled() {
            return this.enabled;
        }

        @Override
        public OFBsnBwEnableGetReply.Builder setEnabled(long enabled) {
            this.enabled = enabled;
            this.enabledSet = true;
            return this;
        }

        @Override
        public OFBsnBwEnableGetReply build() {
            long xid = this.xidSet ? this.xid : 0L;
            long enabled = this.enabledSet ? this.enabled : 0L;
            return new OFBsnBwEnableGetReplyVer13(xid, enabled);
        }
    }

    static class BuilderWithParent
    implements OFBsnBwEnableGetReply.Builder {
        final OFBsnBwEnableGetReplyVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean enabledSet;
        private long enabled;

        BuilderWithParent(OFBsnBwEnableGetReplyVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnBwEnableGetReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 20L;
        }

        @Override
        public long getEnabled() {
            return this.enabled;
        }

        @Override
        public OFBsnBwEnableGetReply.Builder setEnabled(long enabled) {
            this.enabled = enabled;
            this.enabledSet = true;
            return this;
        }

        @Override
        public OFBsnBwEnableGetReply build() {
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            long enabled = this.enabledSet ? this.enabled : this.parentMessage.enabled;
            return new OFBsnBwEnableGetReplyVer13(xid, enabled);
        }
    }
}

