/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnFlowChecksumBucketStatsEntry;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnFlowChecksumBucketStatsEntryVer13
implements OFBsnFlowChecksumBucketStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnFlowChecksumBucketStatsEntryVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final U64 DEFAULT_CHECKSUM = U64.ZERO;
    private final U64 checksum;
    static final OFBsnFlowChecksumBucketStatsEntryVer13 DEFAULT = new OFBsnFlowChecksumBucketStatsEntryVer13(DEFAULT_CHECKSUM);
    static final Reader READER = new Reader();
    static final OFBsnFlowChecksumBucketStatsEntryVer13Funnel FUNNEL = new OFBsnFlowChecksumBucketStatsEntryVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnFlowChecksumBucketStatsEntryVer13(U64 checksum) {
        if (checksum == null) {
            throw new NullPointerException("OFBsnFlowChecksumBucketStatsEntryVer13: property checksum cannot be null");
        }
        this.checksum = checksum;
    }

    @Override
    public U64 getChecksum() {
        return this.checksum;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnFlowChecksumBucketStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnFlowChecksumBucketStatsEntryVer13(");
        b.append("checksum=").append(this.checksum);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnFlowChecksumBucketStatsEntryVer13 other = (OFBsnFlowChecksumBucketStatsEntryVer13)obj;
        return !(this.checksum == null ? other.checksum != null : !this.checksum.equals(other.checksum));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.checksum == null ? 0 : this.checksum.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnFlowChecksumBucketStatsEntryVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnFlowChecksumBucketStatsEntryVer13 message) {
            bb.writeLong(message.checksum.getValue());
        }
    }

    static class OFBsnFlowChecksumBucketStatsEntryVer13Funnel
    implements Funnel<OFBsnFlowChecksumBucketStatsEntryVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnFlowChecksumBucketStatsEntryVer13Funnel() {
        }

        public void funnel(OFBsnFlowChecksumBucketStatsEntryVer13 message, PrimitiveSink sink) {
            message.checksum.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnFlowChecksumBucketStatsEntry> {
        Reader() {
        }

        @Override
        public OFBsnFlowChecksumBucketStatsEntry readFrom(ChannelBuffer bb) throws OFParseError {
            U64 checksum = U64.ofRaw(bb.readLong());
            OFBsnFlowChecksumBucketStatsEntryVer13 bsnFlowChecksumBucketStatsEntryVer13 = new OFBsnFlowChecksumBucketStatsEntryVer13(checksum);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnFlowChecksumBucketStatsEntryVer13);
            }
            return bsnFlowChecksumBucketStatsEntryVer13;
        }
    }

    static class Builder
    implements OFBsnFlowChecksumBucketStatsEntry.Builder {
        private boolean checksumSet;
        private U64 checksum;

        Builder() {
        }

        @Override
        public U64 getChecksum() {
            return this.checksum;
        }

        @Override
        public OFBsnFlowChecksumBucketStatsEntry.Builder setChecksum(U64 checksum) {
            this.checksum = checksum;
            this.checksumSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnFlowChecksumBucketStatsEntry build() {
            U64 checksum;
            U64 u64 = checksum = this.checksumSet ? this.checksum : DEFAULT_CHECKSUM;
            if (checksum == null) {
                throw new NullPointerException("Property checksum must not be null");
            }
            return new OFBsnFlowChecksumBucketStatsEntryVer13(checksum);
        }
    }

    static class BuilderWithParent
    implements OFBsnFlowChecksumBucketStatsEntry.Builder {
        final OFBsnFlowChecksumBucketStatsEntryVer13 parentMessage;
        private boolean checksumSet;
        private U64 checksum;

        BuilderWithParent(OFBsnFlowChecksumBucketStatsEntryVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public U64 getChecksum() {
            return this.checksum;
        }

        @Override
        public OFBsnFlowChecksumBucketStatsEntry.Builder setChecksum(U64 checksum) {
            this.checksum = checksum;
            this.checksumSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnFlowChecksumBucketStatsEntry build() {
            U64 checksum;
            U64 u64 = checksum = this.checksumSet ? this.checksum : this.parentMessage.checksum;
            if (checksum == null) {
                throw new NullPointerException("Property checksum must not be null");
            }
            return new OFBsnFlowChecksumBucketStatsEntryVer13(checksum);
        }
    }
}

