/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnLacpConvergenceNotif;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnLacpConvergenceNotifVer13
implements OFBsnLacpConvergenceNotif {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnLacpConvergenceNotifVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 52;
    private static final long DEFAULT_XID = 0L;
    private static final short DEFAULT_CONVERGENCE_STATUS = 0;
    private static final OFPort DEFAULT_PORT_NO = OFPort.ANY;
    private static final int DEFAULT_ACTOR_SYS_PRIORITY = 0;
    private static final MacAddress DEFAULT_ACTOR_SYS_MAC = MacAddress.NONE;
    private static final int DEFAULT_ACTOR_PORT_PRIORITY = 0;
    private static final int DEFAULT_ACTOR_PORT_NUM = 0;
    private static final int DEFAULT_ACTOR_KEY = 0;
    private static final int DEFAULT_PARTNER_SYS_PRIORITY = 0;
    private static final MacAddress DEFAULT_PARTNER_SYS_MAC = MacAddress.NONE;
    private static final int DEFAULT_PARTNER_PORT_PRIORITY = 0;
    private static final int DEFAULT_PARTNER_PORT_NUM = 0;
    private static final int DEFAULT_PARTNER_KEY = 0;
    private final long xid;
    private final short convergenceStatus;
    private final OFPort portNo;
    private final int actorSysPriority;
    private final MacAddress actorSysMac;
    private final int actorPortPriority;
    private final int actorPortNum;
    private final int actorKey;
    private final int partnerSysPriority;
    private final MacAddress partnerSysMac;
    private final int partnerPortPriority;
    private final int partnerPortNum;
    private final int partnerKey;
    static final OFBsnLacpConvergenceNotifVer13 DEFAULT = new OFBsnLacpConvergenceNotifVer13(0L, 0, DEFAULT_PORT_NO, 0, DEFAULT_ACTOR_SYS_MAC, 0, 0, 0, 0, DEFAULT_PARTNER_SYS_MAC, 0, 0, 0);
    static final Reader READER = new Reader();
    static final OFBsnLacpConvergenceNotifVer13Funnel FUNNEL = new OFBsnLacpConvergenceNotifVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnLacpConvergenceNotifVer13(long xid, short convergenceStatus, OFPort portNo, int actorSysPriority, MacAddress actorSysMac, int actorPortPriority, int actorPortNum, int actorKey, int partnerSysPriority, MacAddress partnerSysMac, int partnerPortPriority, int partnerPortNum, int partnerKey) {
        if (portNo == null) {
            throw new NullPointerException("OFBsnLacpConvergenceNotifVer13: property portNo cannot be null");
        }
        if (actorSysMac == null) {
            throw new NullPointerException("OFBsnLacpConvergenceNotifVer13: property actorSysMac cannot be null");
        }
        if (partnerSysMac == null) {
            throw new NullPointerException("OFBsnLacpConvergenceNotifVer13: property partnerSysMac cannot be null");
        }
        this.xid = xid;
        this.convergenceStatus = convergenceStatus;
        this.portNo = portNo;
        this.actorSysPriority = actorSysPriority;
        this.actorSysMac = actorSysMac;
        this.actorPortPriority = actorPortPriority;
        this.actorPortNum = actorPortNum;
        this.actorKey = actorKey;
        this.partnerSysPriority = partnerSysPriority;
        this.partnerSysMac = partnerSysMac;
        this.partnerPortPriority = partnerPortPriority;
        this.partnerPortNum = partnerPortNum;
        this.partnerKey = partnerKey;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 43L;
    }

    @Override
    public short getConvergenceStatus() {
        return this.convergenceStatus;
    }

    @Override
    public OFPort getPortNo() {
        return this.portNo;
    }

    @Override
    public int getActorSysPriority() {
        return this.actorSysPriority;
    }

    @Override
    public MacAddress getActorSysMac() {
        return this.actorSysMac;
    }

    @Override
    public int getActorPortPriority() {
        return this.actorPortPriority;
    }

    @Override
    public int getActorPortNum() {
        return this.actorPortNum;
    }

    @Override
    public int getActorKey() {
        return this.actorKey;
    }

    @Override
    public int getPartnerSysPriority() {
        return this.partnerSysPriority;
    }

    @Override
    public MacAddress getPartnerSysMac() {
        return this.partnerSysMac;
    }

    @Override
    public int getPartnerPortPriority() {
        return this.partnerPortPriority;
    }

    @Override
    public int getPartnerPortNum() {
        return this.partnerPortNum;
    }

    @Override
    public int getPartnerKey() {
        return this.partnerKey;
    }

    @Override
    public OFBsnLacpConvergenceNotif.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnLacpConvergenceNotifVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("convergenceStatus=").append(this.convergenceStatus);
        b.append(", ");
        b.append("portNo=").append(this.portNo);
        b.append(", ");
        b.append("actorSysPriority=").append(this.actorSysPriority);
        b.append(", ");
        b.append("actorSysMac=").append(this.actorSysMac);
        b.append(", ");
        b.append("actorPortPriority=").append(this.actorPortPriority);
        b.append(", ");
        b.append("actorPortNum=").append(this.actorPortNum);
        b.append(", ");
        b.append("actorKey=").append(this.actorKey);
        b.append(", ");
        b.append("partnerSysPriority=").append(this.partnerSysPriority);
        b.append(", ");
        b.append("partnerSysMac=").append(this.partnerSysMac);
        b.append(", ");
        b.append("partnerPortPriority=").append(this.partnerPortPriority);
        b.append(", ");
        b.append("partnerPortNum=").append(this.partnerPortNum);
        b.append(", ");
        b.append("partnerKey=").append(this.partnerKey);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnLacpConvergenceNotifVer13 other = (OFBsnLacpConvergenceNotifVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.convergenceStatus != other.convergenceStatus) {
            return false;
        }
        if (this.portNo == null ? other.portNo != null : !this.portNo.equals(other.portNo)) {
            return false;
        }
        if (this.actorSysPriority != other.actorSysPriority) {
            return false;
        }
        if (this.actorSysMac == null ? other.actorSysMac != null : !this.actorSysMac.equals(other.actorSysMac)) {
            return false;
        }
        if (this.actorPortPriority != other.actorPortPriority) {
            return false;
        }
        if (this.actorPortNum != other.actorPortNum) {
            return false;
        }
        if (this.actorKey != other.actorKey) {
            return false;
        }
        if (this.partnerSysPriority != other.partnerSysPriority) {
            return false;
        }
        if (this.partnerSysMac == null ? other.partnerSysMac != null : !this.partnerSysMac.equals(other.partnerSysMac)) {
            return false;
        }
        if (this.partnerPortPriority != other.partnerPortPriority) {
            return false;
        }
        if (this.partnerPortNum != other.partnerPortNum) {
            return false;
        }
        return this.partnerKey == other.partnerKey;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + this.convergenceStatus;
        result = 31 * result + (this.portNo == null ? 0 : this.portNo.hashCode());
        result = 31 * result + this.actorSysPriority;
        result = 31 * result + (this.actorSysMac == null ? 0 : this.actorSysMac.hashCode());
        result = 31 * result + this.actorPortPriority;
        result = 31 * result + this.actorPortNum;
        result = 31 * result + this.actorKey;
        result = 31 * result + this.partnerSysPriority;
        result = 31 * result + (this.partnerSysMac == null ? 0 : this.partnerSysMac.hashCode());
        result = 31 * result + this.partnerPortPriority;
        result = 31 * result + this.partnerPortNum;
        result = 31 * result + this.partnerKey;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnLacpConvergenceNotifVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnLacpConvergenceNotifVer13 message) {
            bb.writeByte(4);
            bb.writeByte(4);
            bb.writeShort(52);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(43);
            bb.writeByte((int)U8.t(message.convergenceStatus));
            bb.writeZero(3);
            message.portNo.write4Bytes(bb);
            bb.writeShort((int)U16.t(message.actorSysPriority));
            message.actorSysMac.write6Bytes(bb);
            bb.writeShort((int)U16.t(message.actorPortPriority));
            bb.writeShort((int)U16.t(message.actorPortNum));
            bb.writeShort((int)U16.t(message.actorKey));
            bb.writeShort((int)U16.t(message.partnerSysPriority));
            message.partnerSysMac.write6Bytes(bb);
            bb.writeShort((int)U16.t(message.partnerPortPriority));
            bb.writeShort((int)U16.t(message.partnerPortNum));
            bb.writeShort((int)U16.t(message.partnerKey));
        }
    }

    static class OFBsnLacpConvergenceNotifVer13Funnel
    implements Funnel<OFBsnLacpConvergenceNotifVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnLacpConvergenceNotifVer13Funnel() {
        }

        public void funnel(OFBsnLacpConvergenceNotifVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)4);
            sink.putShort((short)52);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(43);
            sink.putShort(message.convergenceStatus);
            message.portNo.putTo(sink);
            sink.putInt(message.actorSysPriority);
            message.actorSysMac.putTo(sink);
            sink.putInt(message.actorPortPriority);
            sink.putInt(message.actorPortNum);
            sink.putInt(message.actorKey);
            sink.putInt(message.partnerSysPriority);
            message.partnerSysMac.putTo(sink);
            sink.putInt(message.partnerPortPriority);
            sink.putInt(message.partnerPortNum);
            sink.putInt(message.partnerKey);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnLacpConvergenceNotif> {
        Reader() {
        }

        @Override
        public OFBsnLacpConvergenceNotif readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 52) {
                throw new OFParseError("Wrong length: Expected=52(52), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 43) {
                throw new OFParseError("Wrong subtype: Expected=0x2bL(0x2bL), got=" + subtype);
            }
            short convergenceStatus = U8.f(bb.readByte());
            bb.skipBytes(3);
            OFPort portNo = OFPort.read4Bytes(bb);
            int actorSysPriority = U16.f(bb.readShort());
            MacAddress actorSysMac = MacAddress.read6Bytes(bb);
            int actorPortPriority = U16.f(bb.readShort());
            int actorPortNum = U16.f(bb.readShort());
            int actorKey = U16.f(bb.readShort());
            int partnerSysPriority = U16.f(bb.readShort());
            MacAddress partnerSysMac = MacAddress.read6Bytes(bb);
            int partnerPortPriority = U16.f(bb.readShort());
            int partnerPortNum = U16.f(bb.readShort());
            int partnerKey = U16.f(bb.readShort());
            OFBsnLacpConvergenceNotifVer13 bsnLacpConvergenceNotifVer13 = new OFBsnLacpConvergenceNotifVer13(xid, convergenceStatus, portNo, actorSysPriority, actorSysMac, actorPortPriority, actorPortNum, actorKey, partnerSysPriority, partnerSysMac, partnerPortPriority, partnerPortNum, partnerKey);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnLacpConvergenceNotifVer13);
            }
            return bsnLacpConvergenceNotifVer13;
        }
    }

    static class Builder
    implements OFBsnLacpConvergenceNotif.Builder {
        private boolean xidSet;
        private long xid;
        private boolean convergenceStatusSet;
        private short convergenceStatus;
        private boolean portNoSet;
        private OFPort portNo;
        private boolean actorSysPrioritySet;
        private int actorSysPriority;
        private boolean actorSysMacSet;
        private MacAddress actorSysMac;
        private boolean actorPortPrioritySet;
        private int actorPortPriority;
        private boolean actorPortNumSet;
        private int actorPortNum;
        private boolean actorKeySet;
        private int actorKey;
        private boolean partnerSysPrioritySet;
        private int partnerSysPriority;
        private boolean partnerSysMacSet;
        private MacAddress partnerSysMac;
        private boolean partnerPortPrioritySet;
        private int partnerPortPriority;
        private boolean partnerPortNumSet;
        private int partnerPortNum;
        private boolean partnerKeySet;
        private int partnerKey;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnLacpConvergenceNotif.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 43L;
        }

        @Override
        public short getConvergenceStatus() {
            return this.convergenceStatus;
        }

        @Override
        public OFBsnLacpConvergenceNotif.Builder setConvergenceStatus(short convergenceStatus) {
            this.convergenceStatus = convergenceStatus;
            this.convergenceStatusSet = true;
            return this;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFBsnLacpConvergenceNotif.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public int getActorSysPriority() {
            return this.actorSysPriority;
        }

        @Override
        public OFBsnLacpConvergenceNotif.Builder setActorSysPriority(int actorSysPriority) {
            this.actorSysPriority = actorSysPriority;
            this.actorSysPrioritySet = true;
            return this;
        }

        @Override
        public MacAddress getActorSysMac() {
            return this.actorSysMac;
        }

        @Override
        public OFBsnLacpConvergenceNotif.Builder setActorSysMac(MacAddress actorSysMac) {
            this.actorSysMac = actorSysMac;
            this.actorSysMacSet = true;
            return this;
        }

        @Override
        public int getActorPortPriority() {
            return this.actorPortPriority;
        }

        @Override
        public OFBsnLacpConvergenceNotif.Builder setActorPortPriority(int actorPortPriority) {
            this.actorPortPriority = actorPortPriority;
            this.actorPortPrioritySet = true;
            return this;
        }

        @Override
        public int getActorPortNum() {
            return this.actorPortNum;
        }

        @Override
        public OFBsnLacpConvergenceNotif.Builder setActorPortNum(int actorPortNum) {
            this.actorPortNum = actorPortNum;
            this.actorPortNumSet = true;
            return this;
        }

        @Override
        public int getActorKey() {
            return this.actorKey;
        }

        @Override
        public OFBsnLacpConvergenceNotif.Builder setActorKey(int actorKey) {
            this.actorKey = actorKey;
            this.actorKeySet = true;
            return this;
        }

        @Override
        public int getPartnerSysPriority() {
            return this.partnerSysPriority;
        }

        @Override
        public OFBsnLacpConvergenceNotif.Builder setPartnerSysPriority(int partnerSysPriority) {
            this.partnerSysPriority = partnerSysPriority;
            this.partnerSysPrioritySet = true;
            return this;
        }

        @Override
        public MacAddress getPartnerSysMac() {
            return this.partnerSysMac;
        }

        @Override
        public OFBsnLacpConvergenceNotif.Builder setPartnerSysMac(MacAddress partnerSysMac) {
            this.partnerSysMac = partnerSysMac;
            this.partnerSysMacSet = true;
            return this;
        }

        @Override
        public int getPartnerPortPriority() {
            return this.partnerPortPriority;
        }

        @Override
        public OFBsnLacpConvergenceNotif.Builder setPartnerPortPriority(int partnerPortPriority) {
            this.partnerPortPriority = partnerPortPriority;
            this.partnerPortPrioritySet = true;
            return this;
        }

        @Override
        public int getPartnerPortNum() {
            return this.partnerPortNum;
        }

        @Override
        public OFBsnLacpConvergenceNotif.Builder setPartnerPortNum(int partnerPortNum) {
            this.partnerPortNum = partnerPortNum;
            this.partnerPortNumSet = true;
            return this;
        }

        @Override
        public int getPartnerKey() {
            return this.partnerKey;
        }

        @Override
        public OFBsnLacpConvergenceNotif.Builder setPartnerKey(int partnerKey) {
            this.partnerKey = partnerKey;
            this.partnerKeySet = true;
            return this;
        }

        @Override
        public OFBsnLacpConvergenceNotif build() {
            MacAddress partnerSysMac;
            MacAddress actorSysMac;
            OFPort portNo;
            long xid = this.xidSet ? this.xid : 0L;
            short convergenceStatus = this.convergenceStatusSet ? this.convergenceStatus : (short)0;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : DEFAULT_PORT_NO;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            int actorSysPriority = this.actorSysPrioritySet ? this.actorSysPriority : 0;
            MacAddress macAddress = actorSysMac = this.actorSysMacSet ? this.actorSysMac : DEFAULT_ACTOR_SYS_MAC;
            if (actorSysMac == null) {
                throw new NullPointerException("Property actorSysMac must not be null");
            }
            int actorPortPriority = this.actorPortPrioritySet ? this.actorPortPriority : 0;
            int actorPortNum = this.actorPortNumSet ? this.actorPortNum : 0;
            int actorKey = this.actorKeySet ? this.actorKey : 0;
            int partnerSysPriority = this.partnerSysPrioritySet ? this.partnerSysPriority : 0;
            MacAddress macAddress2 = partnerSysMac = this.partnerSysMacSet ? this.partnerSysMac : DEFAULT_PARTNER_SYS_MAC;
            if (partnerSysMac == null) {
                throw new NullPointerException("Property partnerSysMac must not be null");
            }
            int partnerPortPriority = this.partnerPortPrioritySet ? this.partnerPortPriority : 0;
            int partnerPortNum = this.partnerPortNumSet ? this.partnerPortNum : 0;
            int partnerKey = this.partnerKeySet ? this.partnerKey : 0;
            return new OFBsnLacpConvergenceNotifVer13(xid, convergenceStatus, portNo, actorSysPriority, actorSysMac, actorPortPriority, actorPortNum, actorKey, partnerSysPriority, partnerSysMac, partnerPortPriority, partnerPortNum, partnerKey);
        }
    }

    static class BuilderWithParent
    implements OFBsnLacpConvergenceNotif.Builder {
        final OFBsnLacpConvergenceNotifVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean convergenceStatusSet;
        private short convergenceStatus;
        private boolean portNoSet;
        private OFPort portNo;
        private boolean actorSysPrioritySet;
        private int actorSysPriority;
        private boolean actorSysMacSet;
        private MacAddress actorSysMac;
        private boolean actorPortPrioritySet;
        private int actorPortPriority;
        private boolean actorPortNumSet;
        private int actorPortNum;
        private boolean actorKeySet;
        private int actorKey;
        private boolean partnerSysPrioritySet;
        private int partnerSysPriority;
        private boolean partnerSysMacSet;
        private MacAddress partnerSysMac;
        private boolean partnerPortPrioritySet;
        private int partnerPortPriority;
        private boolean partnerPortNumSet;
        private int partnerPortNum;
        private boolean partnerKeySet;
        private int partnerKey;

        BuilderWithParent(OFBsnLacpConvergenceNotifVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnLacpConvergenceNotif.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 43L;
        }

        @Override
        public short getConvergenceStatus() {
            return this.convergenceStatus;
        }

        @Override
        public OFBsnLacpConvergenceNotif.Builder setConvergenceStatus(short convergenceStatus) {
            this.convergenceStatus = convergenceStatus;
            this.convergenceStatusSet = true;
            return this;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFBsnLacpConvergenceNotif.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public int getActorSysPriority() {
            return this.actorSysPriority;
        }

        @Override
        public OFBsnLacpConvergenceNotif.Builder setActorSysPriority(int actorSysPriority) {
            this.actorSysPriority = actorSysPriority;
            this.actorSysPrioritySet = true;
            return this;
        }

        @Override
        public MacAddress getActorSysMac() {
            return this.actorSysMac;
        }

        @Override
        public OFBsnLacpConvergenceNotif.Builder setActorSysMac(MacAddress actorSysMac) {
            this.actorSysMac = actorSysMac;
            this.actorSysMacSet = true;
            return this;
        }

        @Override
        public int getActorPortPriority() {
            return this.actorPortPriority;
        }

        @Override
        public OFBsnLacpConvergenceNotif.Builder setActorPortPriority(int actorPortPriority) {
            this.actorPortPriority = actorPortPriority;
            this.actorPortPrioritySet = true;
            return this;
        }

        @Override
        public int getActorPortNum() {
            return this.actorPortNum;
        }

        @Override
        public OFBsnLacpConvergenceNotif.Builder setActorPortNum(int actorPortNum) {
            this.actorPortNum = actorPortNum;
            this.actorPortNumSet = true;
            return this;
        }

        @Override
        public int getActorKey() {
            return this.actorKey;
        }

        @Override
        public OFBsnLacpConvergenceNotif.Builder setActorKey(int actorKey) {
            this.actorKey = actorKey;
            this.actorKeySet = true;
            return this;
        }

        @Override
        public int getPartnerSysPriority() {
            return this.partnerSysPriority;
        }

        @Override
        public OFBsnLacpConvergenceNotif.Builder setPartnerSysPriority(int partnerSysPriority) {
            this.partnerSysPriority = partnerSysPriority;
            this.partnerSysPrioritySet = true;
            return this;
        }

        @Override
        public MacAddress getPartnerSysMac() {
            return this.partnerSysMac;
        }

        @Override
        public OFBsnLacpConvergenceNotif.Builder setPartnerSysMac(MacAddress partnerSysMac) {
            this.partnerSysMac = partnerSysMac;
            this.partnerSysMacSet = true;
            return this;
        }

        @Override
        public int getPartnerPortPriority() {
            return this.partnerPortPriority;
        }

        @Override
        public OFBsnLacpConvergenceNotif.Builder setPartnerPortPriority(int partnerPortPriority) {
            this.partnerPortPriority = partnerPortPriority;
            this.partnerPortPrioritySet = true;
            return this;
        }

        @Override
        public int getPartnerPortNum() {
            return this.partnerPortNum;
        }

        @Override
        public OFBsnLacpConvergenceNotif.Builder setPartnerPortNum(int partnerPortNum) {
            this.partnerPortNum = partnerPortNum;
            this.partnerPortNumSet = true;
            return this;
        }

        @Override
        public int getPartnerKey() {
            return this.partnerKey;
        }

        @Override
        public OFBsnLacpConvergenceNotif.Builder setPartnerKey(int partnerKey) {
            this.partnerKey = partnerKey;
            this.partnerKeySet = true;
            return this;
        }

        @Override
        public OFBsnLacpConvergenceNotif build() {
            MacAddress partnerSysMac;
            MacAddress actorSysMac;
            OFPort portNo;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            short convergenceStatus = this.convergenceStatusSet ? this.convergenceStatus : this.parentMessage.convergenceStatus;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : this.parentMessage.portNo;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            int actorSysPriority = this.actorSysPrioritySet ? this.actorSysPriority : this.parentMessage.actorSysPriority;
            MacAddress macAddress = actorSysMac = this.actorSysMacSet ? this.actorSysMac : this.parentMessage.actorSysMac;
            if (actorSysMac == null) {
                throw new NullPointerException("Property actorSysMac must not be null");
            }
            int actorPortPriority = this.actorPortPrioritySet ? this.actorPortPriority : this.parentMessage.actorPortPriority;
            int actorPortNum = this.actorPortNumSet ? this.actorPortNum : this.parentMessage.actorPortNum;
            int actorKey = this.actorKeySet ? this.actorKey : this.parentMessage.actorKey;
            int partnerSysPriority = this.partnerSysPrioritySet ? this.partnerSysPriority : this.parentMessage.partnerSysPriority;
            MacAddress macAddress2 = partnerSysMac = this.partnerSysMacSet ? this.partnerSysMac : this.parentMessage.partnerSysMac;
            if (partnerSysMac == null) {
                throw new NullPointerException("Property partnerSysMac must not be null");
            }
            int partnerPortPriority = this.partnerPortPrioritySet ? this.partnerPortPriority : this.parentMessage.partnerPortPriority;
            int partnerPortNum = this.partnerPortNumSet ? this.partnerPortNum : this.parentMessage.partnerPortNum;
            int partnerKey = this.partnerKeySet ? this.partnerKey : this.parentMessage.partnerKey;
            return new OFBsnLacpConvergenceNotifVer13(xid, convergenceStatus, portNo, actorSysPriority, actorSysMac, actorPortPriority, actorPortNum, actorKey, partnerSysPriority, partnerSysMac, partnerPortPriority, partnerPortNum, partnerKey);
        }
    }
}

