/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvIpv6;
import org.projectfloodlight.openflow.types.IPv6Address;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvIpv6Ver13
implements OFBsnTlvIpv6 {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvIpv6Ver13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 20;
    private static final IPv6Address DEFAULT_VALUE = IPv6Address.NONE;
    private final IPv6Address value;
    static final OFBsnTlvIpv6Ver13 DEFAULT = new OFBsnTlvIpv6Ver13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvIpv6Ver13Funnel FUNNEL = new OFBsnTlvIpv6Ver13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvIpv6Ver13(IPv6Address value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvIpv6Ver13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 84;
    }

    @Override
    public IPv6Address getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvIpv6.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvIpv6Ver13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvIpv6Ver13 other = (OFBsnTlvIpv6Ver13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvIpv6Ver13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnTlvIpv6Ver13 message) {
            bb.writeShort(84);
            bb.writeShort(20);
            message.value.write16Bytes(bb);
        }
    }

    static class OFBsnTlvIpv6Ver13Funnel
    implements Funnel<OFBsnTlvIpv6Ver13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvIpv6Ver13Funnel() {
        }

        public void funnel(OFBsnTlvIpv6Ver13 message, PrimitiveSink sink) {
            sink.putShort((short)84);
            sink.putShort((short)20);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvIpv6> {
        Reader() {
        }

        @Override
        public OFBsnTlvIpv6 readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 84) {
                throw new OFParseError("Wrong type: Expected=0x54(0x54), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 20) {
                throw new OFParseError("Wrong length: Expected=20(20), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            IPv6Address value = IPv6Address.read16Bytes(bb);
            OFBsnTlvIpv6Ver13 bsnTlvIpv6Ver13 = new OFBsnTlvIpv6Ver13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvIpv6Ver13);
            }
            return bsnTlvIpv6Ver13;
        }
    }

    static class Builder
    implements OFBsnTlvIpv6.Builder {
        private boolean valueSet;
        private IPv6Address value;

        Builder() {
        }

        @Override
        public int getType() {
            return 84;
        }

        @Override
        public IPv6Address getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvIpv6.Builder setValue(IPv6Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvIpv6 build() {
            IPv6Address value;
            IPv6Address iPv6Address = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvIpv6Ver13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvIpv6.Builder {
        final OFBsnTlvIpv6Ver13 parentMessage;
        private boolean valueSet;
        private IPv6Address value;

        BuilderWithParent(OFBsnTlvIpv6Ver13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 84;
        }

        @Override
        public IPv6Address getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvIpv6.Builder setValue(IPv6Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvIpv6 build() {
            IPv6Address value;
            IPv6Address iPv6Address = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvIpv6Ver13(value);
        }
    }
}

