/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvPartnerKey;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvPartnerKeyVer13
implements OFBsnTlvPartnerKey {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvPartnerKeyVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 6;
    private static final int DEFAULT_VALUE = 0;
    private final int value;
    static final OFBsnTlvPartnerKeyVer13 DEFAULT = new OFBsnTlvPartnerKeyVer13(0);
    static final Reader READER = new Reader();
    static final OFBsnTlvPartnerKeyVer13Funnel FUNNEL = new OFBsnTlvPartnerKeyVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvPartnerKeyVer13(int value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 51;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvPartnerKey.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvPartnerKeyVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvPartnerKeyVer13 other = (OFBsnTlvPartnerKeyVer13)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvPartnerKeyVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnTlvPartnerKeyVer13 message) {
            bb.writeShort(51);
            bb.writeShort(6);
            bb.writeShort((int)U16.t(message.value));
        }
    }

    static class OFBsnTlvPartnerKeyVer13Funnel
    implements Funnel<OFBsnTlvPartnerKeyVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvPartnerKeyVer13Funnel() {
        }

        public void funnel(OFBsnTlvPartnerKeyVer13 message, PrimitiveSink sink) {
            sink.putShort((short)51);
            sink.putShort((short)6);
            sink.putInt(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvPartnerKey> {
        Reader() {
        }

        @Override
        public OFBsnTlvPartnerKey readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 51) {
                throw new OFParseError("Wrong type: Expected=0x33(0x33), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            int value = U16.f(bb.readShort());
            OFBsnTlvPartnerKeyVer13 bsnTlvPartnerKeyVer13 = new OFBsnTlvPartnerKeyVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvPartnerKeyVer13);
            }
            return bsnTlvPartnerKeyVer13;
        }
    }

    static class Builder
    implements OFBsnTlvPartnerKey.Builder {
        private boolean valueSet;
        private int value;

        Builder() {
        }

        @Override
        public int getType() {
            return 51;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvPartnerKey.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvPartnerKey build() {
            int value = this.valueSet ? this.value : 0;
            return new OFBsnTlvPartnerKeyVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvPartnerKey.Builder {
        final OFBsnTlvPartnerKeyVer13 parentMessage;
        private boolean valueSet;
        private int value;

        BuilderWithParent(OFBsnTlvPartnerKeyVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 51;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvPartnerKey.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvPartnerKey build() {
            int value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvPartnerKeyVer13(value);
        }
    }
}

