/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.List;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFCalientCflowAdminState;
import org.projectfloodlight.openflow.protocol.OFCalientCflowCapability;
import org.projectfloodlight.openflow.protocol.OFCalientCflowOperationalState;
import org.projectfloodlight.openflow.protocol.OFCalientFlowStatsEntry;
import org.projectfloodlight.openflow.protocol.OFCalientOcsAlarm;
import org.projectfloodlight.openflow.protocol.OFFlowModFlags;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.instruction.OFInstruction;
import org.projectfloodlight.openflow.protocol.match.Match;
import org.projectfloodlight.openflow.protocol.ver13.ChannelUtilsVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFCalientCflowAdminStateSerializerVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFCalientCflowCapabilitySerializerVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFCalientCflowOperationalStateSerializerVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFCalientOcsAlarmSerializerVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFFactoryVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFFlowModFlagsSerializerVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFInstructionVer13;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFCalientFlowStatsEntryVer13
implements OFCalientFlowStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFCalientFlowStatsEntryVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 128;
    private static final TableId DEFAULT_TABLE_ID = TableId.ALL;
    private static final long DEFAULT_DURATION_SEC = 0L;
    private static final long DEFAULT_DURATION_NSEC = 0L;
    private static final int DEFAULT_PRIORITY = 0;
    private static final int DEFAULT_IDLE_TIMEOUT = 0;
    private static final int DEFAULT_HARD_TIMEOUT = 0;
    private static final Set<OFFlowModFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final U64 DEFAULT_COOKIE = U64.ZERO;
    private static final Set<OFCalientCflowAdminState> DEFAULT_ADMIN_STATUS = ImmutableSet.of();
    private static final Set<OFCalientCflowOperationalState> DEFAULT_OPER_STATUS = ImmutableSet.of();
    private static final Set<OFCalientCflowCapability> DEFAULT_OPER_CAPABILITY = ImmutableSet.of();
    private static final Set<OFCalientOcsAlarm> DEFAULT_ALARM = ImmutableSet.of();
    private static final OFPort DEFAULT_OUT_PORT = OFPort.ANY;
    private static final String DEFAULT_PORT_POWER = "";
    private static final String DEFAULT_CONNECTED_PORT_POWER = "";
    private static final String DEFAULT_CFLOW_NAME = "";
    private static final Match DEFAULT_MATCH = OFFactoryVer13.MATCH_WILDCARD_ALL;
    private static final List<OFInstruction> DEFAULT_INSTRUCTIONS = ImmutableList.of();
    private final TableId tableId;
    private final long durationSec;
    private final long durationNsec;
    private final int priority;
    private final int idleTimeout;
    private final int hardTimeout;
    private final Set<OFFlowModFlags> flags;
    private final U64 cookie;
    private final Set<OFCalientCflowAdminState> adminStatus;
    private final Set<OFCalientCflowOperationalState> operStatus;
    private final Set<OFCalientCflowCapability> operCapability;
    private final Set<OFCalientOcsAlarm> alarm;
    private final OFPort outPort;
    private final String portPower;
    private final String connectedPortPower;
    private final String cflowName;
    private final Match match;
    private final List<OFInstruction> instructions;
    static final OFCalientFlowStatsEntryVer13 DEFAULT = new OFCalientFlowStatsEntryVer13(DEFAULT_TABLE_ID, 0L, 0L, 0, 0, 0, DEFAULT_FLAGS, DEFAULT_COOKIE, DEFAULT_ADMIN_STATUS, DEFAULT_OPER_STATUS, DEFAULT_OPER_CAPABILITY, DEFAULT_ALARM, DEFAULT_OUT_PORT, "", "", "", DEFAULT_MATCH, DEFAULT_INSTRUCTIONS);
    static final Reader READER = new Reader();
    static final OFCalientFlowStatsEntryVer13Funnel FUNNEL = new OFCalientFlowStatsEntryVer13Funnel();
    static final Writer WRITER = new Writer();

    OFCalientFlowStatsEntryVer13(TableId tableId, long durationSec, long durationNsec, int priority, int idleTimeout, int hardTimeout, Set<OFFlowModFlags> flags, U64 cookie, Set<OFCalientCflowAdminState> adminStatus, Set<OFCalientCflowOperationalState> operStatus, Set<OFCalientCflowCapability> operCapability, Set<OFCalientOcsAlarm> alarm, OFPort outPort, String portPower, String connectedPortPower, String cflowName, Match match, List<OFInstruction> instructions) {
        if (tableId == null) {
            throw new NullPointerException("OFCalientFlowStatsEntryVer13: property tableId cannot be null");
        }
        if (flags == null) {
            throw new NullPointerException("OFCalientFlowStatsEntryVer13: property flags cannot be null");
        }
        if (cookie == null) {
            throw new NullPointerException("OFCalientFlowStatsEntryVer13: property cookie cannot be null");
        }
        if (adminStatus == null) {
            throw new NullPointerException("OFCalientFlowStatsEntryVer13: property adminStatus cannot be null");
        }
        if (operStatus == null) {
            throw new NullPointerException("OFCalientFlowStatsEntryVer13: property operStatus cannot be null");
        }
        if (operCapability == null) {
            throw new NullPointerException("OFCalientFlowStatsEntryVer13: property operCapability cannot be null");
        }
        if (alarm == null) {
            throw new NullPointerException("OFCalientFlowStatsEntryVer13: property alarm cannot be null");
        }
        if (outPort == null) {
            throw new NullPointerException("OFCalientFlowStatsEntryVer13: property outPort cannot be null");
        }
        if (portPower == null) {
            throw new NullPointerException("OFCalientFlowStatsEntryVer13: property portPower cannot be null");
        }
        if (connectedPortPower == null) {
            throw new NullPointerException("OFCalientFlowStatsEntryVer13: property connectedPortPower cannot be null");
        }
        if (cflowName == null) {
            throw new NullPointerException("OFCalientFlowStatsEntryVer13: property cflowName cannot be null");
        }
        if (match == null) {
            throw new NullPointerException("OFCalientFlowStatsEntryVer13: property match cannot be null");
        }
        if (instructions == null) {
            throw new NullPointerException("OFCalientFlowStatsEntryVer13: property instructions cannot be null");
        }
        this.tableId = tableId;
        this.durationSec = durationSec;
        this.durationNsec = durationNsec;
        this.priority = priority;
        this.idleTimeout = idleTimeout;
        this.hardTimeout = hardTimeout;
        this.flags = flags;
        this.cookie = cookie;
        this.adminStatus = adminStatus;
        this.operStatus = operStatus;
        this.operCapability = operCapability;
        this.alarm = alarm;
        this.outPort = outPort;
        this.portPower = portPower;
        this.connectedPortPower = connectedPortPower;
        this.cflowName = cflowName;
        this.match = match;
        this.instructions = instructions;
    }

    @Override
    public TableId getTableId() {
        return this.tableId;
    }

    @Override
    public long getDurationSec() {
        return this.durationSec;
    }

    @Override
    public long getDurationNsec() {
        return this.durationNsec;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public int getHardTimeout() {
        return this.hardTimeout;
    }

    @Override
    public Set<OFFlowModFlags> getFlags() {
        return this.flags;
    }

    @Override
    public U64 getCookie() {
        return this.cookie;
    }

    @Override
    public Set<OFCalientCflowAdminState> getAdminStatus() {
        return this.adminStatus;
    }

    @Override
    public Set<OFCalientCflowOperationalState> getOperStatus() {
        return this.operStatus;
    }

    @Override
    public Set<OFCalientCflowCapability> getOperCapability() {
        return this.operCapability;
    }

    @Override
    public Set<OFCalientOcsAlarm> getAlarm() {
        return this.alarm;
    }

    @Override
    public OFPort getOutPort() {
        return this.outPort;
    }

    @Override
    public String getPortPower() {
        return this.portPower;
    }

    @Override
    public String getConnectedPortPower() {
        return this.connectedPortPower;
    }

    @Override
    public String getCflowName() {
        return this.cflowName;
    }

    @Override
    public Match getMatch() {
        return this.match;
    }

    @Override
    public List<OFInstruction> getInstructions() {
        return this.instructions;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFCalientFlowStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFCalientFlowStatsEntryVer13(");
        b.append("tableId=").append(this.tableId);
        b.append(", ");
        b.append("durationSec=").append(this.durationSec);
        b.append(", ");
        b.append("durationNsec=").append(this.durationNsec);
        b.append(", ");
        b.append("priority=").append(this.priority);
        b.append(", ");
        b.append("idleTimeout=").append(this.idleTimeout);
        b.append(", ");
        b.append("hardTimeout=").append(this.hardTimeout);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("cookie=").append(this.cookie);
        b.append(", ");
        b.append("adminStatus=").append(this.adminStatus);
        b.append(", ");
        b.append("operStatus=").append(this.operStatus);
        b.append(", ");
        b.append("operCapability=").append(this.operCapability);
        b.append(", ");
        b.append("alarm=").append(this.alarm);
        b.append(", ");
        b.append("outPort=").append(this.outPort);
        b.append(", ");
        b.append("portPower=").append(this.portPower);
        b.append(", ");
        b.append("connectedPortPower=").append(this.connectedPortPower);
        b.append(", ");
        b.append("cflowName=").append(this.cflowName);
        b.append(", ");
        b.append("match=").append(this.match);
        b.append(", ");
        b.append("instructions=").append(this.instructions);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFCalientFlowStatsEntryVer13 other = (OFCalientFlowStatsEntryVer13)obj;
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        if (this.durationSec != other.durationSec) {
            return false;
        }
        if (this.durationNsec != other.durationNsec) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        if (this.idleTimeout != other.idleTimeout) {
            return false;
        }
        if (this.hardTimeout != other.hardTimeout) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        if (this.cookie == null ? other.cookie != null : !this.cookie.equals(other.cookie)) {
            return false;
        }
        if (this.adminStatus == null ? other.adminStatus != null : !this.adminStatus.equals(other.adminStatus)) {
            return false;
        }
        if (this.operStatus == null ? other.operStatus != null : !this.operStatus.equals(other.operStatus)) {
            return false;
        }
        if (this.operCapability == null ? other.operCapability != null : !this.operCapability.equals(other.operCapability)) {
            return false;
        }
        if (this.alarm == null ? other.alarm != null : !this.alarm.equals(other.alarm)) {
            return false;
        }
        if (this.outPort == null ? other.outPort != null : !this.outPort.equals(other.outPort)) {
            return false;
        }
        if (this.portPower == null ? other.portPower != null : !this.portPower.equals(other.portPower)) {
            return false;
        }
        if (this.connectedPortPower == null ? other.connectedPortPower != null : !this.connectedPortPower.equals(other.connectedPortPower)) {
            return false;
        }
        if (this.cflowName == null ? other.cflowName != null : !this.cflowName.equals(other.cflowName)) {
            return false;
        }
        if (this.match == null ? other.match != null : !this.match.equals(other.match)) {
            return false;
        }
        return !(this.instructions == null ? other.instructions != null : !this.instructions.equals(other.instructions));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * (int)(this.durationSec ^ this.durationSec >>> 32);
        result = 31 * (int)(this.durationNsec ^ this.durationNsec >>> 32);
        result = 31 * result + this.priority;
        result = 31 * result + this.idleTimeout;
        result = 31 * result + this.hardTimeout;
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.cookie == null ? 0 : this.cookie.hashCode());
        result = 31 * result + (this.adminStatus == null ? 0 : this.adminStatus.hashCode());
        result = 31 * result + (this.operStatus == null ? 0 : this.operStatus.hashCode());
        result = 31 * result + (this.operCapability == null ? 0 : this.operCapability.hashCode());
        result = 31 * result + (this.alarm == null ? 0 : this.alarm.hashCode());
        result = 31 * result + (this.outPort == null ? 0 : this.outPort.hashCode());
        result = 31 * result + (this.portPower == null ? 0 : this.portPower.hashCode());
        result = 31 * result + (this.connectedPortPower == null ? 0 : this.connectedPortPower.hashCode());
        result = 31 * result + (this.cflowName == null ? 0 : this.cflowName.hashCode());
        result = 31 * result + (this.match == null ? 0 : this.match.hashCode());
        result = 31 * result + (this.instructions == null ? 0 : this.instructions.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFCalientFlowStatsEntryVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFCalientFlowStatsEntryVer13 message) {
            int startIndex = bb.writerIndex();
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            message.tableId.writeByte(bb);
            bb.writeZero(1);
            bb.writeInt(U32.t(message.durationSec));
            bb.writeInt(U32.t(message.durationNsec));
            bb.writeShort((int)U16.t(message.priority));
            bb.writeShort((int)U16.t(message.idleTimeout));
            bb.writeShort((int)U16.t(message.hardTimeout));
            OFFlowModFlagsSerializerVer13.writeTo(bb, message.flags);
            bb.writeZero(4);
            bb.writeLong(message.cookie.getValue());
            OFCalientCflowAdminStateSerializerVer13.writeTo(bb, message.adminStatus);
            OFCalientCflowOperationalStateSerializerVer13.writeTo(bb, message.operStatus);
            OFCalientCflowCapabilitySerializerVer13.writeTo(bb, message.operCapability);
            OFCalientOcsAlarmSerializerVer13.writeTo(bb, message.alarm);
            message.outPort.write4Bytes(bb);
            ChannelUtils.writeFixedLengthString(bb, message.portPower, 6);
            bb.writeZero(2);
            ChannelUtils.writeFixedLengthString(bb, message.connectedPortPower, 6);
            bb.writeZero(2);
            ChannelUtils.writeFixedLengthString(bb, message.cflowName, 64);
            message.match.writeTo(bb);
            ChannelUtils.writeList(bb, message.instructions);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFCalientFlowStatsEntryVer13Funnel
    implements Funnel<OFCalientFlowStatsEntryVer13> {
        private static final long serialVersionUID = 1L;

        OFCalientFlowStatsEntryVer13Funnel() {
        }

        public void funnel(OFCalientFlowStatsEntryVer13 message, PrimitiveSink sink) {
            message.tableId.putTo(sink);
            sink.putLong(message.durationSec);
            sink.putLong(message.durationNsec);
            sink.putInt(message.priority);
            sink.putInt(message.idleTimeout);
            sink.putInt(message.hardTimeout);
            OFFlowModFlagsSerializerVer13.putTo(message.flags, sink);
            message.cookie.putTo(sink);
            OFCalientCflowAdminStateSerializerVer13.putTo(message.adminStatus, sink);
            OFCalientCflowOperationalStateSerializerVer13.putTo(message.operStatus, sink);
            OFCalientCflowCapabilitySerializerVer13.putTo(message.operCapability, sink);
            OFCalientOcsAlarmSerializerVer13.putTo(message.alarm, sink);
            message.outPort.putTo(sink);
            sink.putUnencodedChars((CharSequence)message.portPower);
            sink.putUnencodedChars((CharSequence)message.connectedPortPower);
            sink.putUnencodedChars((CharSequence)message.cflowName);
            message.match.putTo(sink);
            FunnelUtils.putList(message.instructions, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFCalientFlowStatsEntry> {
        Reader() {
        }

        @Override
        public OFCalientFlowStatsEntry readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            int length = U16.f(bb.readShort());
            if (length < 128) {
                throw new OFParseError("Wrong length: Expected to be >= 128, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            TableId tableId = TableId.readByte(bb);
            bb.skipBytes(1);
            long durationSec = U32.f(bb.readInt());
            long durationNsec = U32.f(bb.readInt());
            int priority = U16.f(bb.readShort());
            int idleTimeout = U16.f(bb.readShort());
            int hardTimeout = U16.f(bb.readShort());
            Set<OFFlowModFlags> flags = OFFlowModFlagsSerializerVer13.readFrom(bb);
            bb.skipBytes(4);
            U64 cookie = U64.ofRaw(bb.readLong());
            Set<OFCalientCflowAdminState> adminStatus = OFCalientCflowAdminStateSerializerVer13.readFrom(bb);
            Set<OFCalientCflowOperationalState> operStatus = OFCalientCflowOperationalStateSerializerVer13.readFrom(bb);
            Set<OFCalientCflowCapability> operCapability = OFCalientCflowCapabilitySerializerVer13.readFrom(bb);
            Set<OFCalientOcsAlarm> alarm = OFCalientOcsAlarmSerializerVer13.readFrom(bb);
            OFPort outPort = OFPort.read4Bytes(bb);
            String portPower = ChannelUtils.readFixedLengthString(bb, 6);
            bb.skipBytes(2);
            String connectedPortPower = ChannelUtils.readFixedLengthString(bb, 6);
            bb.skipBytes(2);
            String cflowName = ChannelUtils.readFixedLengthString(bb, 64);
            Match match = ChannelUtilsVer13.readOFMatch(bb);
            List<OFInstruction> instructions = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFInstructionVer13.READER);
            OFCalientFlowStatsEntryVer13 calientFlowStatsEntryVer13 = new OFCalientFlowStatsEntryVer13(tableId, durationSec, durationNsec, priority, idleTimeout, hardTimeout, flags, cookie, adminStatus, operStatus, operCapability, alarm, outPort, portPower, connectedPortPower, cflowName, match, instructions);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)calientFlowStatsEntryVer13);
            }
            return calientFlowStatsEntryVer13;
        }
    }

    static class Builder
    implements OFCalientFlowStatsEntry.Builder {
        private boolean tableIdSet;
        private TableId tableId;
        private boolean durationSecSet;
        private long durationSec;
        private boolean durationNsecSet;
        private long durationNsec;
        private boolean prioritySet;
        private int priority;
        private boolean idleTimeoutSet;
        private int idleTimeout;
        private boolean hardTimeoutSet;
        private int hardTimeout;
        private boolean flagsSet;
        private Set<OFFlowModFlags> flags;
        private boolean cookieSet;
        private U64 cookie;
        private boolean adminStatusSet;
        private Set<OFCalientCflowAdminState> adminStatus;
        private boolean operStatusSet;
        private Set<OFCalientCflowOperationalState> operStatus;
        private boolean operCapabilitySet;
        private Set<OFCalientCflowCapability> operCapability;
        private boolean alarmSet;
        private Set<OFCalientOcsAlarm> alarm;
        private boolean outPortSet;
        private OFPort outPort;
        private boolean portPowerSet;
        private String portPower;
        private boolean connectedPortPowerSet;
        private String connectedPortPower;
        private boolean cflowNameSet;
        private String cflowName;
        private boolean matchSet;
        private Match match;
        private boolean instructionsSet;
        private List<OFInstruction> instructions;

        Builder() {
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFCalientFlowStatsEntry.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public long getDurationSec() {
            return this.durationSec;
        }

        @Override
        public OFCalientFlowStatsEntry.Builder setDurationSec(long durationSec) {
            this.durationSec = durationSec;
            this.durationSecSet = true;
            return this;
        }

        @Override
        public long getDurationNsec() {
            return this.durationNsec;
        }

        @Override
        public OFCalientFlowStatsEntry.Builder setDurationNsec(long durationNsec) {
            this.durationNsec = durationNsec;
            this.durationNsecSet = true;
            return this;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public OFCalientFlowStatsEntry.Builder setPriority(int priority) {
            this.priority = priority;
            this.prioritySet = true;
            return this;
        }

        @Override
        public int getIdleTimeout() {
            return this.idleTimeout;
        }

        @Override
        public OFCalientFlowStatsEntry.Builder setIdleTimeout(int idleTimeout) {
            this.idleTimeout = idleTimeout;
            this.idleTimeoutSet = true;
            return this;
        }

        @Override
        public int getHardTimeout() {
            return this.hardTimeout;
        }

        @Override
        public OFCalientFlowStatsEntry.Builder setHardTimeout(int hardTimeout) {
            this.hardTimeout = hardTimeout;
            this.hardTimeoutSet = true;
            return this;
        }

        @Override
        public Set<OFFlowModFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFCalientFlowStatsEntry.Builder setFlags(Set<OFFlowModFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public U64 getCookie() {
            return this.cookie;
        }

        @Override
        public OFCalientFlowStatsEntry.Builder setCookie(U64 cookie) {
            this.cookie = cookie;
            this.cookieSet = true;
            return this;
        }

        @Override
        public Set<OFCalientCflowAdminState> getAdminStatus() {
            return this.adminStatus;
        }

        @Override
        public OFCalientFlowStatsEntry.Builder setAdminStatus(Set<OFCalientCflowAdminState> adminStatus) {
            this.adminStatus = adminStatus;
            this.adminStatusSet = true;
            return this;
        }

        @Override
        public Set<OFCalientCflowOperationalState> getOperStatus() {
            return this.operStatus;
        }

        @Override
        public OFCalientFlowStatsEntry.Builder setOperStatus(Set<OFCalientCflowOperationalState> operStatus) {
            this.operStatus = operStatus;
            this.operStatusSet = true;
            return this;
        }

        @Override
        public Set<OFCalientCflowCapability> getOperCapability() {
            return this.operCapability;
        }

        @Override
        public OFCalientFlowStatsEntry.Builder setOperCapability(Set<OFCalientCflowCapability> operCapability) {
            this.operCapability = operCapability;
            this.operCapabilitySet = true;
            return this;
        }

        @Override
        public Set<OFCalientOcsAlarm> getAlarm() {
            return this.alarm;
        }

        @Override
        public OFCalientFlowStatsEntry.Builder setAlarm(Set<OFCalientOcsAlarm> alarm) {
            this.alarm = alarm;
            this.alarmSet = true;
            return this;
        }

        @Override
        public OFPort getOutPort() {
            return this.outPort;
        }

        @Override
        public OFCalientFlowStatsEntry.Builder setOutPort(OFPort outPort) {
            this.outPort = outPort;
            this.outPortSet = true;
            return this;
        }

        @Override
        public String getPortPower() {
            return this.portPower;
        }

        @Override
        public OFCalientFlowStatsEntry.Builder setPortPower(String portPower) {
            this.portPower = portPower;
            this.portPowerSet = true;
            return this;
        }

        @Override
        public String getConnectedPortPower() {
            return this.connectedPortPower;
        }

        @Override
        public OFCalientFlowStatsEntry.Builder setConnectedPortPower(String connectedPortPower) {
            this.connectedPortPower = connectedPortPower;
            this.connectedPortPowerSet = true;
            return this;
        }

        @Override
        public String getCflowName() {
            return this.cflowName;
        }

        @Override
        public OFCalientFlowStatsEntry.Builder setCflowName(String cflowName) {
            this.cflowName = cflowName;
            this.cflowNameSet = true;
            return this;
        }

        @Override
        public Match getMatch() {
            return this.match;
        }

        @Override
        public OFCalientFlowStatsEntry.Builder setMatch(Match match) {
            this.match = match;
            this.matchSet = true;
            return this;
        }

        @Override
        public List<OFInstruction> getInstructions() {
            return this.instructions;
        }

        @Override
        public OFCalientFlowStatsEntry.Builder setInstructions(List<OFInstruction> instructions) {
            this.instructions = instructions;
            this.instructionsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFCalientFlowStatsEntry build() {
            List<OFInstruction> instructions;
            Match match;
            String cflowName;
            String connectedPortPower;
            String portPower;
            OFPort outPort;
            Set<OFCalientOcsAlarm> alarm;
            Set<OFCalientCflowCapability> operCapability;
            Set<OFCalientCflowOperationalState> operStatus;
            Set<OFCalientCflowAdminState> adminStatus;
            U64 cookie;
            Set<OFFlowModFlags> flags;
            TableId tableId;
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : DEFAULT_TABLE_ID;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            long durationSec = this.durationSecSet ? this.durationSec : 0L;
            long durationNsec = this.durationNsecSet ? this.durationNsec : 0L;
            int priority = this.prioritySet ? this.priority : 0;
            int idleTimeout = this.idleTimeoutSet ? this.idleTimeout : 0;
            int hardTimeout = this.hardTimeoutSet ? this.hardTimeout : 0;
            Set<OFFlowModFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            U64 u64 = cookie = this.cookieSet ? this.cookie : DEFAULT_COOKIE;
            if (cookie == null) {
                throw new NullPointerException("Property cookie must not be null");
            }
            Set<OFCalientCflowAdminState> set2 = adminStatus = this.adminStatusSet ? this.adminStatus : DEFAULT_ADMIN_STATUS;
            if (adminStatus == null) {
                throw new NullPointerException("Property adminStatus must not be null");
            }
            Set<OFCalientCflowOperationalState> set3 = operStatus = this.operStatusSet ? this.operStatus : DEFAULT_OPER_STATUS;
            if (operStatus == null) {
                throw new NullPointerException("Property operStatus must not be null");
            }
            Set<OFCalientCflowCapability> set4 = operCapability = this.operCapabilitySet ? this.operCapability : DEFAULT_OPER_CAPABILITY;
            if (operCapability == null) {
                throw new NullPointerException("Property operCapability must not be null");
            }
            Set<OFCalientOcsAlarm> set5 = alarm = this.alarmSet ? this.alarm : DEFAULT_ALARM;
            if (alarm == null) {
                throw new NullPointerException("Property alarm must not be null");
            }
            OFPort oFPort = outPort = this.outPortSet ? this.outPort : DEFAULT_OUT_PORT;
            if (outPort == null) {
                throw new NullPointerException("Property outPort must not be null");
            }
            String string = portPower = this.portPowerSet ? this.portPower : "";
            if (portPower == null) {
                throw new NullPointerException("Property portPower must not be null");
            }
            String string2 = connectedPortPower = this.connectedPortPowerSet ? this.connectedPortPower : "";
            if (connectedPortPower == null) {
                throw new NullPointerException("Property connectedPortPower must not be null");
            }
            String string3 = cflowName = this.cflowNameSet ? this.cflowName : "";
            if (cflowName == null) {
                throw new NullPointerException("Property cflowName must not be null");
            }
            Match match2 = match = this.matchSet ? this.match : DEFAULT_MATCH;
            if (match == null) {
                throw new NullPointerException("Property match must not be null");
            }
            List<OFInstruction> list = instructions = this.instructionsSet ? this.instructions : DEFAULT_INSTRUCTIONS;
            if (instructions == null) {
                throw new NullPointerException("Property instructions must not be null");
            }
            return new OFCalientFlowStatsEntryVer13(tableId, durationSec, durationNsec, priority, idleTimeout, hardTimeout, flags, cookie, adminStatus, operStatus, operCapability, alarm, outPort, portPower, connectedPortPower, cflowName, match, instructions);
        }
    }

    static class BuilderWithParent
    implements OFCalientFlowStatsEntry.Builder {
        final OFCalientFlowStatsEntryVer13 parentMessage;
        private boolean tableIdSet;
        private TableId tableId;
        private boolean durationSecSet;
        private long durationSec;
        private boolean durationNsecSet;
        private long durationNsec;
        private boolean prioritySet;
        private int priority;
        private boolean idleTimeoutSet;
        private int idleTimeout;
        private boolean hardTimeoutSet;
        private int hardTimeout;
        private boolean flagsSet;
        private Set<OFFlowModFlags> flags;
        private boolean cookieSet;
        private U64 cookie;
        private boolean adminStatusSet;
        private Set<OFCalientCflowAdminState> adminStatus;
        private boolean operStatusSet;
        private Set<OFCalientCflowOperationalState> operStatus;
        private boolean operCapabilitySet;
        private Set<OFCalientCflowCapability> operCapability;
        private boolean alarmSet;
        private Set<OFCalientOcsAlarm> alarm;
        private boolean outPortSet;
        private OFPort outPort;
        private boolean portPowerSet;
        private String portPower;
        private boolean connectedPortPowerSet;
        private String connectedPortPower;
        private boolean cflowNameSet;
        private String cflowName;
        private boolean matchSet;
        private Match match;
        private boolean instructionsSet;
        private List<OFInstruction> instructions;

        BuilderWithParent(OFCalientFlowStatsEntryVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFCalientFlowStatsEntry.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public long getDurationSec() {
            return this.durationSec;
        }

        @Override
        public OFCalientFlowStatsEntry.Builder setDurationSec(long durationSec) {
            this.durationSec = durationSec;
            this.durationSecSet = true;
            return this;
        }

        @Override
        public long getDurationNsec() {
            return this.durationNsec;
        }

        @Override
        public OFCalientFlowStatsEntry.Builder setDurationNsec(long durationNsec) {
            this.durationNsec = durationNsec;
            this.durationNsecSet = true;
            return this;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public OFCalientFlowStatsEntry.Builder setPriority(int priority) {
            this.priority = priority;
            this.prioritySet = true;
            return this;
        }

        @Override
        public int getIdleTimeout() {
            return this.idleTimeout;
        }

        @Override
        public OFCalientFlowStatsEntry.Builder setIdleTimeout(int idleTimeout) {
            this.idleTimeout = idleTimeout;
            this.idleTimeoutSet = true;
            return this;
        }

        @Override
        public int getHardTimeout() {
            return this.hardTimeout;
        }

        @Override
        public OFCalientFlowStatsEntry.Builder setHardTimeout(int hardTimeout) {
            this.hardTimeout = hardTimeout;
            this.hardTimeoutSet = true;
            return this;
        }

        @Override
        public Set<OFFlowModFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFCalientFlowStatsEntry.Builder setFlags(Set<OFFlowModFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public U64 getCookie() {
            return this.cookie;
        }

        @Override
        public OFCalientFlowStatsEntry.Builder setCookie(U64 cookie) {
            this.cookie = cookie;
            this.cookieSet = true;
            return this;
        }

        @Override
        public Set<OFCalientCflowAdminState> getAdminStatus() {
            return this.adminStatus;
        }

        @Override
        public OFCalientFlowStatsEntry.Builder setAdminStatus(Set<OFCalientCflowAdminState> adminStatus) {
            this.adminStatus = adminStatus;
            this.adminStatusSet = true;
            return this;
        }

        @Override
        public Set<OFCalientCflowOperationalState> getOperStatus() {
            return this.operStatus;
        }

        @Override
        public OFCalientFlowStatsEntry.Builder setOperStatus(Set<OFCalientCflowOperationalState> operStatus) {
            this.operStatus = operStatus;
            this.operStatusSet = true;
            return this;
        }

        @Override
        public Set<OFCalientCflowCapability> getOperCapability() {
            return this.operCapability;
        }

        @Override
        public OFCalientFlowStatsEntry.Builder setOperCapability(Set<OFCalientCflowCapability> operCapability) {
            this.operCapability = operCapability;
            this.operCapabilitySet = true;
            return this;
        }

        @Override
        public Set<OFCalientOcsAlarm> getAlarm() {
            return this.alarm;
        }

        @Override
        public OFCalientFlowStatsEntry.Builder setAlarm(Set<OFCalientOcsAlarm> alarm) {
            this.alarm = alarm;
            this.alarmSet = true;
            return this;
        }

        @Override
        public OFPort getOutPort() {
            return this.outPort;
        }

        @Override
        public OFCalientFlowStatsEntry.Builder setOutPort(OFPort outPort) {
            this.outPort = outPort;
            this.outPortSet = true;
            return this;
        }

        @Override
        public String getPortPower() {
            return this.portPower;
        }

        @Override
        public OFCalientFlowStatsEntry.Builder setPortPower(String portPower) {
            this.portPower = portPower;
            this.portPowerSet = true;
            return this;
        }

        @Override
        public String getConnectedPortPower() {
            return this.connectedPortPower;
        }

        @Override
        public OFCalientFlowStatsEntry.Builder setConnectedPortPower(String connectedPortPower) {
            this.connectedPortPower = connectedPortPower;
            this.connectedPortPowerSet = true;
            return this;
        }

        @Override
        public String getCflowName() {
            return this.cflowName;
        }

        @Override
        public OFCalientFlowStatsEntry.Builder setCflowName(String cflowName) {
            this.cflowName = cflowName;
            this.cflowNameSet = true;
            return this;
        }

        @Override
        public Match getMatch() {
            return this.match;
        }

        @Override
        public OFCalientFlowStatsEntry.Builder setMatch(Match match) {
            this.match = match;
            this.matchSet = true;
            return this;
        }

        @Override
        public List<OFInstruction> getInstructions() {
            return this.instructions;
        }

        @Override
        public OFCalientFlowStatsEntry.Builder setInstructions(List<OFInstruction> instructions) {
            this.instructions = instructions;
            this.instructionsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFCalientFlowStatsEntry build() {
            List instructions;
            Match match;
            String cflowName;
            String connectedPortPower;
            String portPower;
            OFPort outPort;
            Set alarm;
            Set operCapability;
            Set operStatus;
            Set adminStatus;
            U64 cookie;
            Set flags;
            TableId tableId;
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : this.parentMessage.tableId;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            long durationSec = this.durationSecSet ? this.durationSec : this.parentMessage.durationSec;
            long durationNsec = this.durationNsecSet ? this.durationNsec : this.parentMessage.durationNsec;
            int priority = this.prioritySet ? this.priority : this.parentMessage.priority;
            int idleTimeout = this.idleTimeoutSet ? this.idleTimeout : this.parentMessage.idleTimeout;
            int hardTimeout = this.hardTimeoutSet ? this.hardTimeout : this.parentMessage.hardTimeout;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            U64 u64 = cookie = this.cookieSet ? this.cookie : this.parentMessage.cookie;
            if (cookie == null) {
                throw new NullPointerException("Property cookie must not be null");
            }
            Set set2 = adminStatus = this.adminStatusSet ? this.adminStatus : this.parentMessage.adminStatus;
            if (adminStatus == null) {
                throw new NullPointerException("Property adminStatus must not be null");
            }
            Set set3 = operStatus = this.operStatusSet ? this.operStatus : this.parentMessage.operStatus;
            if (operStatus == null) {
                throw new NullPointerException("Property operStatus must not be null");
            }
            Set set4 = operCapability = this.operCapabilitySet ? this.operCapability : this.parentMessage.operCapability;
            if (operCapability == null) {
                throw new NullPointerException("Property operCapability must not be null");
            }
            Set set5 = alarm = this.alarmSet ? this.alarm : this.parentMessage.alarm;
            if (alarm == null) {
                throw new NullPointerException("Property alarm must not be null");
            }
            OFPort oFPort = outPort = this.outPortSet ? this.outPort : this.parentMessage.outPort;
            if (outPort == null) {
                throw new NullPointerException("Property outPort must not be null");
            }
            String string = portPower = this.portPowerSet ? this.portPower : this.parentMessage.portPower;
            if (portPower == null) {
                throw new NullPointerException("Property portPower must not be null");
            }
            String string2 = connectedPortPower = this.connectedPortPowerSet ? this.connectedPortPower : this.parentMessage.connectedPortPower;
            if (connectedPortPower == null) {
                throw new NullPointerException("Property connectedPortPower must not be null");
            }
            String string3 = cflowName = this.cflowNameSet ? this.cflowName : this.parentMessage.cflowName;
            if (cflowName == null) {
                throw new NullPointerException("Property cflowName must not be null");
            }
            Match match2 = match = this.matchSet ? this.match : this.parentMessage.match;
            if (match == null) {
                throw new NullPointerException("Property match must not be null");
            }
            List list = instructions = this.instructionsSet ? this.instructions : this.parentMessage.instructions;
            if (instructions == null) {
                throw new NullPointerException("Property instructions must not be null");
            }
            return new OFCalientFlowStatsEntryVer13(tableId, durationSec, durationNsec, priority, idleTimeout, hardTimeout, flags, cookie, adminStatus, operStatus, operCapability, alarm, outPort, portPower, connectedPortPower, cflowName, match, instructions);
        }
    }
}

