/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFCalientStatsReply;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.ver13.OFCalientFlowStatsReplyVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFCalientPortDescStatsReplyVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFCalientPortStatsReplyVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFStatsReplyFlagsSerializerVer13;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;

abstract class OFCalientStatsReplyVer13 {
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 24;
    public static final Reader READER = new Reader();

    OFCalientStatsReplyVer13() {
    }

    static class Reader
    implements OFMessageReader<OFCalientStatsReply> {
        Reader() {
        }

        @Override
        public OFCalientStatsReply readFrom(ChannelBuffer bb) throws OFParseError {
            if (bb.readableBytes() < 24) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 19) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REPLY(19), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 24) {
                throw new OFParseError("Wrong length: Expected to be >= 24, was: " + length);
            }
            U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != -1) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.EXPERIMENTER(65535), got=" + statsType);
            }
            OFStatsReplyFlagsSerializerVer13.readFrom(bb);
            bb.skipBytes(4);
            int experimenter = bb.readInt();
            if (experimenter != 8452440) {
                throw new OFParseError("Wrong experimenter: Expected=0x80f958L(0x80f958L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            bb.readerIndex(start);
            switch (subtype) {
                case 2: {
                    return OFCalientFlowStatsReplyVer13.READER.readFrom(bb);
                }
                case 1: {
                    return OFCalientPortDescStatsReplyVer13.READER.readFrom(bb);
                }
                case 3: {
                    return OFCalientPortStatsReplyVer13.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator subtype of class OFCalientStatsReplyVer13: " + subtype);
        }
    }
}

