/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFAdaptationsType;
import org.projectfloodlight.openflow.protocol.OFExpPortOpticalTransportLayerEntry;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortOpticalTransportLayerClass;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver13.OFAdaptationsTypeSerializerVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFPortOpticalTransportLayerClassSerializerVer13;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFExpPortOpticalTransportLayerEntryVer13
implements OFExpPortOpticalTransportLayerEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFExpPortOpticalTransportLayerEntryVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final short DEFAULT_SIGNAL_TYPE = 0;
    private final OFPortOpticalTransportLayerClass layerClass;
    private final short signalType;
    private final OFAdaptationsType adaptation;
    static final Reader READER = new Reader();
    static final OFExpPortOpticalTransportLayerEntryVer13Funnel FUNNEL = new OFExpPortOpticalTransportLayerEntryVer13Funnel();
    static final Writer WRITER = new Writer();

    OFExpPortOpticalTransportLayerEntryVer13(OFPortOpticalTransportLayerClass layerClass, short signalType, OFAdaptationsType adaptation) {
        if (layerClass == null) {
            throw new NullPointerException("OFExpPortOpticalTransportLayerEntryVer13: property layerClass cannot be null");
        }
        if (adaptation == null) {
            throw new NullPointerException("OFExpPortOpticalTransportLayerEntryVer13: property adaptation cannot be null");
        }
        this.layerClass = layerClass;
        this.signalType = signalType;
        this.adaptation = adaptation;
    }

    @Override
    public OFPortOpticalTransportLayerClass getLayerClass() {
        return this.layerClass;
    }

    @Override
    public short getSignalType() {
        return this.signalType;
    }

    @Override
    public OFAdaptationsType getAdaptation() {
        return this.adaptation;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFExpPortOpticalTransportLayerEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFExpPortOpticalTransportLayerEntryVer13(");
        b.append("layerClass=").append((Object)this.layerClass);
        b.append(", ");
        b.append("signalType=").append(this.signalType);
        b.append(", ");
        b.append("adaptation=").append((Object)this.adaptation);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFExpPortOpticalTransportLayerEntryVer13 other = (OFExpPortOpticalTransportLayerEntryVer13)obj;
        if (this.layerClass == null ? other.layerClass != null : !this.layerClass.equals((Object)other.layerClass)) {
            return false;
        }
        if (this.signalType != other.signalType) {
            return false;
        }
        return !(this.adaptation == null ? other.adaptation != null : !this.adaptation.equals((Object)other.adaptation));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.layerClass == null ? 0 : this.layerClass.hashCode());
        result = 31 * result + this.signalType;
        result = 31 * result + (this.adaptation == null ? 0 : this.adaptation.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFExpPortOpticalTransportLayerEntryVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFExpPortOpticalTransportLayerEntryVer13 message) {
            OFPortOpticalTransportLayerClassSerializerVer13.writeTo(bb, message.layerClass);
            bb.writeByte((int)U8.t(message.signalType));
            OFAdaptationsTypeSerializerVer13.writeTo(bb, message.adaptation);
            bb.writeZero(5);
        }
    }

    static class OFExpPortOpticalTransportLayerEntryVer13Funnel
    implements Funnel<OFExpPortOpticalTransportLayerEntryVer13> {
        private static final long serialVersionUID = 1L;

        OFExpPortOpticalTransportLayerEntryVer13Funnel() {
        }

        public void funnel(OFExpPortOpticalTransportLayerEntryVer13 message, PrimitiveSink sink) {
            OFPortOpticalTransportLayerClassSerializerVer13.putTo(message.layerClass, sink);
            sink.putShort(message.signalType);
            OFAdaptationsTypeSerializerVer13.putTo(message.adaptation, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFExpPortOpticalTransportLayerEntry> {
        Reader() {
        }

        @Override
        public OFExpPortOpticalTransportLayerEntry readFrom(ChannelBuffer bb) throws OFParseError {
            OFPortOpticalTransportLayerClass layerClass = OFPortOpticalTransportLayerClassSerializerVer13.readFrom(bb);
            short signalType = U8.f(bb.readByte());
            OFAdaptationsType adaptation = OFAdaptationsTypeSerializerVer13.readFrom(bb);
            bb.skipBytes(5);
            OFExpPortOpticalTransportLayerEntryVer13 expPortOpticalTransportLayerEntryVer13 = new OFExpPortOpticalTransportLayerEntryVer13(layerClass, signalType, adaptation);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)expPortOpticalTransportLayerEntryVer13);
            }
            return expPortOpticalTransportLayerEntryVer13;
        }
    }

    static class Builder
    implements OFExpPortOpticalTransportLayerEntry.Builder {
        private boolean layerClassSet;
        private OFPortOpticalTransportLayerClass layerClass;
        private boolean signalTypeSet;
        private short signalType;
        private boolean adaptationSet;
        private OFAdaptationsType adaptation;

        Builder() {
        }

        @Override
        public OFPortOpticalTransportLayerClass getLayerClass() {
            return this.layerClass;
        }

        @Override
        public OFExpPortOpticalTransportLayerEntry.Builder setLayerClass(OFPortOpticalTransportLayerClass layerClass) {
            this.layerClass = layerClass;
            this.layerClassSet = true;
            return this;
        }

        @Override
        public short getSignalType() {
            return this.signalType;
        }

        @Override
        public OFExpPortOpticalTransportLayerEntry.Builder setSignalType(short signalType) {
            this.signalType = signalType;
            this.signalTypeSet = true;
            return this;
        }

        @Override
        public OFAdaptationsType getAdaptation() {
            return this.adaptation;
        }

        @Override
        public OFExpPortOpticalTransportLayerEntry.Builder setAdaptation(OFAdaptationsType adaptation) {
            this.adaptation = adaptation;
            this.adaptationSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFExpPortOpticalTransportLayerEntry build() {
            short signalType;
            if (!this.layerClassSet) {
                throw new IllegalStateException("Property layerClass doesn't have default value -- must be set");
            }
            if (this.layerClass == null) {
                throw new NullPointerException("Property layerClass must not be null");
            }
            short s = signalType = this.signalTypeSet ? this.signalType : (short)0;
            if (!this.adaptationSet) {
                throw new IllegalStateException("Property adaptation doesn't have default value -- must be set");
            }
            if (this.adaptation == null) {
                throw new NullPointerException("Property adaptation must not be null");
            }
            return new OFExpPortOpticalTransportLayerEntryVer13(this.layerClass, signalType, this.adaptation);
        }
    }

    static class BuilderWithParent
    implements OFExpPortOpticalTransportLayerEntry.Builder {
        final OFExpPortOpticalTransportLayerEntryVer13 parentMessage;
        private boolean layerClassSet;
        private OFPortOpticalTransportLayerClass layerClass;
        private boolean signalTypeSet;
        private short signalType;
        private boolean adaptationSet;
        private OFAdaptationsType adaptation;

        BuilderWithParent(OFExpPortOpticalTransportLayerEntryVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFPortOpticalTransportLayerClass getLayerClass() {
            return this.layerClass;
        }

        @Override
        public OFExpPortOpticalTransportLayerEntry.Builder setLayerClass(OFPortOpticalTransportLayerClass layerClass) {
            this.layerClass = layerClass;
            this.layerClassSet = true;
            return this;
        }

        @Override
        public short getSignalType() {
            return this.signalType;
        }

        @Override
        public OFExpPortOpticalTransportLayerEntry.Builder setSignalType(short signalType) {
            this.signalType = signalType;
            this.signalTypeSet = true;
            return this;
        }

        @Override
        public OFAdaptationsType getAdaptation() {
            return this.adaptation;
        }

        @Override
        public OFExpPortOpticalTransportLayerEntry.Builder setAdaptation(OFAdaptationsType adaptation) {
            this.adaptation = adaptation;
            this.adaptationSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFExpPortOpticalTransportLayerEntry build() {
            OFAdaptationsType adaptation;
            OFPortOpticalTransportLayerClass layerClass;
            OFPortOpticalTransportLayerClass oFPortOpticalTransportLayerClass = layerClass = this.layerClassSet ? this.layerClass : this.parentMessage.layerClass;
            if (layerClass == null) {
                throw new NullPointerException("Property layerClass must not be null");
            }
            short signalType = this.signalTypeSet ? this.signalType : this.parentMessage.signalType;
            OFAdaptationsType oFAdaptationsType = adaptation = this.adaptationSet ? this.adaptation : this.parentMessage.adaptation;
            if (adaptation == null) {
                throw new NullPointerException("Property adaptation must not be null");
            }
            return new OFExpPortOpticalTransportLayerEntryVer13(layerClass, signalType, adaptation);
        }
    }
}

