/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFInstructionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructionBsnDisableL3;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFInstructionBsnDisableL3Ver13
implements OFInstructionBsnDisableL3 {
    private static final Logger logger = LoggerFactory.getLogger(OFInstructionBsnDisableL3Ver13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 16;
    static final OFInstructionBsnDisableL3Ver13 DEFAULT = new OFInstructionBsnDisableL3Ver13();
    static final OFInstructionBsnDisableL3Ver13 INSTANCE = new OFInstructionBsnDisableL3Ver13();
    static final Reader READER = new Reader();
    static final OFInstructionBsnDisableL3Ver13Funnel FUNNEL = new OFInstructionBsnDisableL3Ver13Funnel();
    static final Writer WRITER = new Writer();

    private OFInstructionBsnDisableL3Ver13() {
    }

    @Override
    public OFInstructionType getType() {
        return OFInstructionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 13L;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFInstructionBsnDisableL3.Builder createBuilder() {
        throw new UnsupportedOperationException("OFInstructionBsnDisableL3Ver13 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFInstructionBsnDisableL3Ver13(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFInstructionBsnDisableL3Ver13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFInstructionBsnDisableL3Ver13 message) {
            bb.writeShort(-1);
            bb.writeShort(16);
            bb.writeInt(6035143);
            bb.writeInt(13);
            bb.writeZero(4);
        }
    }

    static class OFInstructionBsnDisableL3Ver13Funnel
    implements Funnel<OFInstructionBsnDisableL3Ver13> {
        private static final long serialVersionUID = 1L;

        OFInstructionBsnDisableL3Ver13Funnel() {
        }

        public void funnel(OFInstructionBsnDisableL3Ver13 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)16);
            sink.putInt(6035143);
            sink.putInt(13);
        }
    }

    static class Reader
    implements OFMessageReader<OFInstructionBsnDisableL3> {
        Reader() {
        }

        @Override
        public OFInstructionBsnDisableL3 readFrom(ChannelBuffer bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFInstructionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 16) {
                throw new OFParseError("Wrong length: Expected=16(16), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 13) {
                throw new OFParseError("Wrong subtype: Expected=0xdL(0xdL), got=" + subtype);
            }
            bb.skipBytes(4);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

