/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFOplinkPortPower;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOplinkPortPowerVer13
implements OFOplinkPortPower {
    private static final Logger logger = LoggerFactory.getLogger(OFOplinkPortPowerVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 4;
    private static final int DEFAULT_PORT = 0;
    private static final int DEFAULT_POWER_VALUE = 0;
    private final int port;
    private final int powerValue;
    static final OFOplinkPortPowerVer13 DEFAULT = new OFOplinkPortPowerVer13(0, 0);
    static final Reader READER = new Reader();
    static final OFOplinkPortPowerVer13Funnel FUNNEL = new OFOplinkPortPowerVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOplinkPortPowerVer13(int port, int powerValue) {
        this.port = port;
        this.powerValue = powerValue;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public int getPowerValue() {
        return this.powerValue;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOplinkPortPower.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOplinkPortPowerVer13(");
        b.append("port=").append(this.port);
        b.append(", ");
        b.append("powerValue=").append(this.powerValue);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOplinkPortPowerVer13 other = (OFOplinkPortPowerVer13)obj;
        if (this.port != other.port) {
            return false;
        }
        return this.powerValue == other.powerValue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.port;
        result = 31 * result + this.powerValue;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOplinkPortPowerVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOplinkPortPowerVer13 message) {
            bb.writeShort((int)U16.t(message.port));
            bb.writeShort((int)U16.t(message.powerValue));
        }
    }

    static class OFOplinkPortPowerVer13Funnel
    implements Funnel<OFOplinkPortPowerVer13> {
        private static final long serialVersionUID = 1L;

        OFOplinkPortPowerVer13Funnel() {
        }

        public void funnel(OFOplinkPortPowerVer13 message, PrimitiveSink sink) {
            sink.putInt(message.port);
            sink.putInt(message.powerValue);
        }
    }

    static class Reader
    implements OFMessageReader<OFOplinkPortPower> {
        Reader() {
        }

        @Override
        public OFOplinkPortPower readFrom(ChannelBuffer bb) throws OFParseError {
            int port = U16.f(bb.readShort());
            int powerValue = U16.f(bb.readShort());
            OFOplinkPortPowerVer13 oplinkPortPowerVer13 = new OFOplinkPortPowerVer13(port, powerValue);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oplinkPortPowerVer13);
            }
            return oplinkPortPowerVer13;
        }
    }

    static class Builder
    implements OFOplinkPortPower.Builder {
        private boolean portSet;
        private int port;
        private boolean powerValueSet;
        private int powerValue;

        Builder() {
        }

        @Override
        public int getPort() {
            return this.port;
        }

        @Override
        public OFOplinkPortPower.Builder setPort(int port) {
            this.port = port;
            this.portSet = true;
            return this;
        }

        @Override
        public int getPowerValue() {
            return this.powerValue;
        }

        @Override
        public OFOplinkPortPower.Builder setPowerValue(int powerValue) {
            this.powerValue = powerValue;
            this.powerValueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOplinkPortPower build() {
            int port = this.portSet ? this.port : 0;
            int powerValue = this.powerValueSet ? this.powerValue : 0;
            return new OFOplinkPortPowerVer13(port, powerValue);
        }
    }

    static class BuilderWithParent
    implements OFOplinkPortPower.Builder {
        final OFOplinkPortPowerVer13 parentMessage;
        private boolean portSet;
        private int port;
        private boolean powerValueSet;
        private int powerValue;

        BuilderWithParent(OFOplinkPortPowerVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getPort() {
            return this.port;
        }

        @Override
        public OFOplinkPortPower.Builder setPort(int port) {
            this.port = port;
            this.portSet = true;
            return this;
        }

        @Override
        public int getPowerValue() {
            return this.powerValue;
        }

        @Override
        public OFOplinkPortPower.Builder setPowerValue(int powerValue) {
            this.powerValue = powerValue;
            this.powerValueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOplinkPortPower build() {
            int port = this.portSet ? this.port : this.parentMessage.port;
            int powerValue = this.powerValueSet ? this.powerValue : this.parentMessage.powerValue;
            return new OFOplinkPortPowerVer13(port, powerValue);
        }
    }
}

