/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFOplinkStatsReply;
import org.projectfloodlight.openflow.protocol.ver13.OFOplinkChannelPowerReplyVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFOplinkPortPowerReplyVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFStatsReplyFlagsSerializerVer13;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;

abstract class OFOplinkStatsReplyVer13 {
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 24;
    public static final Reader READER = new Reader();

    OFOplinkStatsReplyVer13() {
    }

    static class Reader
    implements OFMessageReader<OFOplinkStatsReply> {
        Reader() {
        }

        @Override
        public OFOplinkStatsReply readFrom(ChannelBuffer bb) throws OFParseError {
            if (bb.readableBytes() < 24) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 19) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REPLY(19), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 24) {
                throw new OFParseError("Wrong length: Expected to be >= 24, was: " + length);
            }
            U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != -1) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.EXPERIMENTER(65535), got=" + statsType);
            }
            OFStatsReplyFlagsSerializerVer13.readFrom(bb);
            bb.skipBytes(4);
            int experimenter = bb.readInt();
            if (experimenter != -16777080) {
                throw new OFParseError("Wrong experimenter: Expected=0xff000088L(0xff000088L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            bb.readerIndex(start);
            switch (subtype) {
                case 21: {
                    return OFOplinkChannelPowerReplyVer13.READER.readFrom(bb);
                }
                case 20: {
                    return OFOplinkPortPowerReplyVer13.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator subtype of class OFOplinkStatsReplyVer13: " + subtype);
        }
    }
}

