/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmArpOpMasked;
import org.projectfloodlight.openflow.protocol.ver13.OFOxmArpOpVer13;
import org.projectfloodlight.openflow.types.ArpOpcode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmArpOpMaskedVer13
implements OFOxmArpOpMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmArpOpMaskedVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final ArpOpcode DEFAULT_VALUE = ArpOpcode.NONE;
    private static final ArpOpcode DEFAULT_VALUE_MASK = ArpOpcode.NONE;
    private final ArpOpcode value;
    private final ArpOpcode mask;
    static final OFOxmArpOpMaskedVer13 DEFAULT = new OFOxmArpOpMaskedVer13(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmArpOpMaskedVer13Funnel FUNNEL = new OFOxmArpOpMaskedVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmArpOpMaskedVer13(ArpOpcode value, ArpOpcode mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmArpOpMaskedVer13: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmArpOpMaskedVer13: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 2147494660L;
    }

    @Override
    public ArpOpcode getValue() {
        return this.value;
    }

    @Override
    public ArpOpcode getMask() {
        return this.mask;
    }

    @Override
    public MatchField<ArpOpcode> getMatchField() {
        return MatchField.ARP_OP;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<ArpOpcode> getCanonical() {
        if (ArpOpcode.NO_MASK.equals(this.mask)) {
            return new OFOxmArpOpVer13(this.value);
        }
        if (ArpOpcode.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmArpOpMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmArpOpMaskedVer13(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmArpOpMaskedVer13 other = (OFOxmArpOpMaskedVer13)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmArpOpMaskedVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmArpOpMaskedVer13 message) {
            bb.writeInt(-2147472636);
            message.value.write2Bytes(bb);
            message.mask.write2Bytes(bb);
        }
    }

    static class OFOxmArpOpMaskedVer13Funnel
    implements Funnel<OFOxmArpOpMaskedVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmArpOpMaskedVer13Funnel() {
        }

        public void funnel(OFOxmArpOpMaskedVer13 message, PrimitiveSink sink) {
            sink.putInt(-2147472636);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmArpOpMasked> {
        Reader() {
        }

        @Override
        public OFOxmArpOpMasked readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147472636) {
                throw new OFParseError("Wrong typeLen: Expected=0x80002b04L(0x80002b04L), got=" + typeLen);
            }
            ArpOpcode value = ArpOpcode.read2Bytes(bb);
            ArpOpcode mask = ArpOpcode.read2Bytes(bb);
            OFOxmArpOpMaskedVer13 oxmArpOpMaskedVer13 = new OFOxmArpOpMaskedVer13(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmArpOpMaskedVer13);
            }
            return oxmArpOpMaskedVer13;
        }
    }

    static class Builder
    implements OFOxmArpOpMasked.Builder {
        private boolean valueSet;
        private ArpOpcode value;
        private boolean maskSet;
        private ArpOpcode mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147494660L;
        }

        @Override
        public ArpOpcode getValue() {
            return this.value;
        }

        @Override
        public OFOxmArpOpMasked.Builder setValue(ArpOpcode value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public ArpOpcode getMask() {
            return this.mask;
        }

        @Override
        public OFOxmArpOpMasked.Builder setMask(ArpOpcode mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<ArpOpcode> getMatchField() {
            return MatchField.ARP_OP;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<ArpOpcode> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmArpOpMasked build() {
            ArpOpcode mask;
            ArpOpcode value;
            ArpOpcode arpOpcode = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            ArpOpcode arpOpcode2 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmArpOpMaskedVer13(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmArpOpMasked.Builder {
        final OFOxmArpOpMaskedVer13 parentMessage;
        private boolean valueSet;
        private ArpOpcode value;
        private boolean maskSet;
        private ArpOpcode mask;

        BuilderWithParent(OFOxmArpOpMaskedVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147494660L;
        }

        @Override
        public ArpOpcode getValue() {
            return this.value;
        }

        @Override
        public OFOxmArpOpMasked.Builder setValue(ArpOpcode value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public ArpOpcode getMask() {
            return this.mask;
        }

        @Override
        public OFOxmArpOpMasked.Builder setMask(ArpOpcode mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<ArpOpcode> getMatchField() {
            return MatchField.ARP_OP;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<ArpOpcode> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmArpOpMasked build() {
            ArpOpcode mask;
            ArpOpcode value;
            ArpOpcode arpOpcode = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            ArpOpcode arpOpcode2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmArpOpMaskedVer13(value, mask);
        }
    }
}

