/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmBsnVlanXlatePortGroupIdMasked;
import org.projectfloodlight.openflow.protocol.ver13.OFOxmBsnVlanXlatePortGroupIdVer13;
import org.projectfloodlight.openflow.types.ClassId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmBsnVlanXlatePortGroupIdMaskedVer13
implements OFOxmBsnVlanXlatePortGroupIdMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmBsnVlanXlatePortGroupIdMaskedVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 12;
    private static final ClassId DEFAULT_VALUE = ClassId.NONE;
    private static final ClassId DEFAULT_VALUE_MASK = ClassId.NONE;
    private final ClassId value;
    private final ClassId mask;
    static final OFOxmBsnVlanXlatePortGroupIdMaskedVer13 DEFAULT = new OFOxmBsnVlanXlatePortGroupIdMaskedVer13(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmBsnVlanXlatePortGroupIdMaskedVer13Funnel FUNNEL = new OFOxmBsnVlanXlatePortGroupIdMaskedVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmBsnVlanXlatePortGroupIdMaskedVer13(ClassId value, ClassId mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmBsnVlanXlatePortGroupIdMaskedVer13: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmBsnVlanXlatePortGroupIdMaskedVer13: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 205576L;
    }

    @Override
    public ClassId getValue() {
        return this.value;
    }

    @Override
    public ClassId getMask() {
        return this.mask;
    }

    @Override
    public MatchField<ClassId> getMatchField() {
        return MatchField.BSN_VLAN_XLATE_PORT_GROUP_ID;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<ClassId> getCanonical() {
        if (ClassId.NO_MASK.equals(this.mask)) {
            return new OFOxmBsnVlanXlatePortGroupIdVer13(this.value);
        }
        if (ClassId.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmBsnVlanXlatePortGroupIdMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmBsnVlanXlatePortGroupIdMaskedVer13(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmBsnVlanXlatePortGroupIdMaskedVer13 other = (OFOxmBsnVlanXlatePortGroupIdMaskedVer13)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmBsnVlanXlatePortGroupIdMaskedVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmBsnVlanXlatePortGroupIdMaskedVer13 message) {
            bb.writeInt(205576);
            message.value.write4Bytes(bb);
            message.mask.write4Bytes(bb);
        }
    }

    static class OFOxmBsnVlanXlatePortGroupIdMaskedVer13Funnel
    implements Funnel<OFOxmBsnVlanXlatePortGroupIdMaskedVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmBsnVlanXlatePortGroupIdMaskedVer13Funnel() {
        }

        public void funnel(OFOxmBsnVlanXlatePortGroupIdMaskedVer13 message, PrimitiveSink sink) {
            sink.putInt(205576);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmBsnVlanXlatePortGroupIdMasked> {
        Reader() {
        }

        @Override
        public OFOxmBsnVlanXlatePortGroupIdMasked readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 205576) {
                throw new OFParseError("Wrong typeLen: Expected=0x32308L(0x32308L), got=" + typeLen);
            }
            ClassId value = ClassId.read4Bytes(bb);
            ClassId mask = ClassId.read4Bytes(bb);
            OFOxmBsnVlanXlatePortGroupIdMaskedVer13 oxmBsnVlanXlatePortGroupIdMaskedVer13 = new OFOxmBsnVlanXlatePortGroupIdMaskedVer13(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmBsnVlanXlatePortGroupIdMaskedVer13);
            }
            return oxmBsnVlanXlatePortGroupIdMaskedVer13;
        }
    }

    static class Builder
    implements OFOxmBsnVlanXlatePortGroupIdMasked.Builder {
        private boolean valueSet;
        private ClassId value;
        private boolean maskSet;
        private ClassId mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 205576L;
        }

        @Override
        public ClassId getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnVlanXlatePortGroupIdMasked.Builder setValue(ClassId value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public ClassId getMask() {
            return this.mask;
        }

        @Override
        public OFOxmBsnVlanXlatePortGroupIdMasked.Builder setMask(ClassId mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<ClassId> getMatchField() {
            return MatchField.BSN_VLAN_XLATE_PORT_GROUP_ID;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<ClassId> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmBsnVlanXlatePortGroupIdMasked build() {
            ClassId mask;
            ClassId value;
            ClassId classId = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            ClassId classId2 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmBsnVlanXlatePortGroupIdMaskedVer13(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmBsnVlanXlatePortGroupIdMasked.Builder {
        final OFOxmBsnVlanXlatePortGroupIdMaskedVer13 parentMessage;
        private boolean valueSet;
        private ClassId value;
        private boolean maskSet;
        private ClassId mask;

        BuilderWithParent(OFOxmBsnVlanXlatePortGroupIdMaskedVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 205576L;
        }

        @Override
        public ClassId getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnVlanXlatePortGroupIdMasked.Builder setValue(ClassId value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public ClassId getMask() {
            return this.mask;
        }

        @Override
        public OFOxmBsnVlanXlatePortGroupIdMasked.Builder setMask(ClassId mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<ClassId> getMatchField() {
            return MatchField.BSN_VLAN_XLATE_PORT_GROUP_ID;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<ClassId> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmBsnVlanXlatePortGroupIdMasked build() {
            ClassId mask;
            ClassId value;
            ClassId classId = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            ClassId classId2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmBsnVlanXlatePortGroupIdMaskedVer13(value, mask);
        }
    }
}

