/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmIpv6ExthdrMasked;
import org.projectfloodlight.openflow.protocol.ver13.OFOxmIpv6ExthdrVer13;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmIpv6ExthdrMaskedVer13
implements OFOxmIpv6ExthdrMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmIpv6ExthdrMaskedVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final U16 DEFAULT_VALUE = U16.ZERO;
    private static final U16 DEFAULT_VALUE_MASK = U16.ZERO;
    private final U16 value;
    private final U16 mask;
    static final OFOxmIpv6ExthdrMaskedVer13 DEFAULT = new OFOxmIpv6ExthdrMaskedVer13(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmIpv6ExthdrMaskedVer13Funnel FUNNEL = new OFOxmIpv6ExthdrMaskedVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmIpv6ExthdrMaskedVer13(U16 value, U16 mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmIpv6ExthdrMaskedVer13: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmIpv6ExthdrMaskedVer13: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 2147503876L;
    }

    @Override
    public U16 getValue() {
        return this.value;
    }

    @Override
    public U16 getMask() {
        return this.mask;
    }

    @Override
    public MatchField<U16> getMatchField() {
        return MatchField.IPV6_EXTHDR;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<U16> getCanonical() {
        if (U16.NO_MASK.equals(this.mask)) {
            return new OFOxmIpv6ExthdrVer13(this.value);
        }
        if (U16.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmIpv6ExthdrMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmIpv6ExthdrMaskedVer13(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmIpv6ExthdrMaskedVer13 other = (OFOxmIpv6ExthdrMaskedVer13)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmIpv6ExthdrMaskedVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmIpv6ExthdrMaskedVer13 message) {
            bb.writeInt(-2147463420);
            bb.writeShort((int)message.value.getRaw());
            bb.writeShort((int)message.mask.getRaw());
        }
    }

    static class OFOxmIpv6ExthdrMaskedVer13Funnel
    implements Funnel<OFOxmIpv6ExthdrMaskedVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmIpv6ExthdrMaskedVer13Funnel() {
        }

        public void funnel(OFOxmIpv6ExthdrMaskedVer13 message, PrimitiveSink sink) {
            sink.putInt(-2147463420);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmIpv6ExthdrMasked> {
        Reader() {
        }

        @Override
        public OFOxmIpv6ExthdrMasked readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147463420) {
                throw new OFParseError("Wrong typeLen: Expected=0x80004f04L(0x80004f04L), got=" + typeLen);
            }
            U16 value = U16.of(bb.readShort());
            U16 mask = U16.of(bb.readShort());
            OFOxmIpv6ExthdrMaskedVer13 oxmIpv6ExthdrMaskedVer13 = new OFOxmIpv6ExthdrMaskedVer13(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmIpv6ExthdrMaskedVer13);
            }
            return oxmIpv6ExthdrMaskedVer13;
        }
    }

    static class Builder
    implements OFOxmIpv6ExthdrMasked.Builder {
        private boolean valueSet;
        private U16 value;
        private boolean maskSet;
        private U16 mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147503876L;
        }

        @Override
        public U16 getValue() {
            return this.value;
        }

        @Override
        public OFOxmIpv6ExthdrMasked.Builder setValue(U16 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public U16 getMask() {
            return this.mask;
        }

        @Override
        public OFOxmIpv6ExthdrMasked.Builder setMask(U16 mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<U16> getMatchField() {
            return MatchField.IPV6_EXTHDR;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<U16> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmIpv6ExthdrMasked build() {
            U16 mask;
            U16 value;
            U16 u16 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            U16 u162 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmIpv6ExthdrMaskedVer13(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmIpv6ExthdrMasked.Builder {
        final OFOxmIpv6ExthdrMaskedVer13 parentMessage;
        private boolean valueSet;
        private U16 value;
        private boolean maskSet;
        private U16 mask;

        BuilderWithParent(OFOxmIpv6ExthdrMaskedVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147503876L;
        }

        @Override
        public U16 getValue() {
            return this.value;
        }

        @Override
        public OFOxmIpv6ExthdrMasked.Builder setValue(U16 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public U16 getMask() {
            return this.mask;
        }

        @Override
        public OFOxmIpv6ExthdrMasked.Builder setMask(U16 mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<U16> getMatchField() {
            return MatchField.IPV6_EXTHDR;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<U16> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmIpv6ExthdrMasked build() {
            U16 mask;
            U16 value;
            U16 u16 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            U16 u162 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmIpv6ExthdrMaskedVer13(value, mask);
        }
    }
}

