/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortDescPropOpticalTransport;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortDescPropOpticalTransportVer13
implements OFPortDescPropOpticalTransport {
    private static final Logger logger = LoggerFactory.getLogger(OFPortDescPropOpticalTransportVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final int DEFAULT_TYPE = 0;
    private static final short DEFAULT_PORT_SIGNAL_TYPE = 0;
    private static final short DEFAULT_RESERVED = 0;
    private static final short DEFAULT_PORT_TYPE = 0;
    private final int type;
    private final short portSignalType;
    private final short reserved;
    private final short portType;
    static final OFPortDescPropOpticalTransportVer13 DEFAULT = new OFPortDescPropOpticalTransportVer13(0, 0, 0, 0);
    static final Reader READER = new Reader();
    static final OFPortDescPropOpticalTransportVer13Funnel FUNNEL = new OFPortDescPropOpticalTransportVer13Funnel();
    static final Writer WRITER = new Writer();

    OFPortDescPropOpticalTransportVer13(int type, short portSignalType, short reserved, short portType) {
        this.type = type;
        this.portSignalType = portSignalType;
        this.reserved = reserved;
        this.portType = portType;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public short getPortSignalType() {
        return this.portSignalType;
    }

    @Override
    public short getReserved() {
        return this.reserved;
    }

    @Override
    public short getPortType() {
        return this.portType;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFPortDescPropOpticalTransport.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortDescPropOpticalTransportVer13(");
        b.append("type=").append(this.type);
        b.append(", ");
        b.append("portSignalType=").append(this.portSignalType);
        b.append(", ");
        b.append("reserved=").append(this.reserved);
        b.append(", ");
        b.append("portType=").append(this.portType);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortDescPropOpticalTransportVer13 other = (OFPortDescPropOpticalTransportVer13)obj;
        if (this.type != other.type) {
            return false;
        }
        if (this.portSignalType != other.portSignalType) {
            return false;
        }
        if (this.reserved != other.reserved) {
            return false;
        }
        return this.portType == other.portType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.type;
        result = 31 * result + this.portSignalType;
        result = 31 * result + this.reserved;
        result = 31 * result + this.portType;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortDescPropOpticalTransportVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFPortDescPropOpticalTransportVer13 message) {
            bb.writeShort((int)U16.t(message.type));
            bb.writeShort(8);
            bb.writeByte((int)U8.t(message.portSignalType));
            bb.writeByte((int)U8.t(message.reserved));
            bb.writeZero(1);
            bb.writeByte((int)U8.t(message.portType));
        }
    }

    static class OFPortDescPropOpticalTransportVer13Funnel
    implements Funnel<OFPortDescPropOpticalTransportVer13> {
        private static final long serialVersionUID = 1L;

        OFPortDescPropOpticalTransportVer13Funnel() {
        }

        public void funnel(OFPortDescPropOpticalTransportVer13 message, PrimitiveSink sink) {
            sink.putInt(message.type);
            sink.putShort((short)8);
            sink.putShort(message.portSignalType);
            sink.putShort(message.reserved);
            sink.putShort(message.portType);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortDescPropOpticalTransport> {
        Reader() {
        }

        @Override
        public OFPortDescPropOpticalTransport readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            int type = U16.f(bb.readShort());
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            short portSignalType = U8.f(bb.readByte());
            short reserved = U8.f(bb.readByte());
            bb.skipBytes(1);
            short portType = U8.f(bb.readByte());
            OFPortDescPropOpticalTransportVer13 portDescPropOpticalTransportVer13 = new OFPortDescPropOpticalTransportVer13(type, portSignalType, reserved, portType);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portDescPropOpticalTransportVer13);
            }
            return portDescPropOpticalTransportVer13;
        }
    }

    static class Builder
    implements OFPortDescPropOpticalTransport.Builder {
        private boolean typeSet;
        private int type;
        private boolean portSignalTypeSet;
        private short portSignalType;
        private boolean reservedSet;
        private short reserved;
        private boolean portTypeSet;
        private short portType;

        Builder() {
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public OFPortDescPropOpticalTransport.Builder setType(int type) {
            this.type = type;
            this.typeSet = true;
            return this;
        }

        @Override
        public short getPortSignalType() {
            return this.portSignalType;
        }

        @Override
        public OFPortDescPropOpticalTransport.Builder setPortSignalType(short portSignalType) {
            this.portSignalType = portSignalType;
            this.portSignalTypeSet = true;
            return this;
        }

        @Override
        public short getReserved() {
            return this.reserved;
        }

        @Override
        public OFPortDescPropOpticalTransport.Builder setReserved(short reserved) {
            this.reserved = reserved;
            this.reservedSet = true;
            return this;
        }

        @Override
        public short getPortType() {
            return this.portType;
        }

        @Override
        public OFPortDescPropOpticalTransport.Builder setPortType(short portType) {
            this.portType = portType;
            this.portTypeSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFPortDescPropOpticalTransport build() {
            int type = this.typeSet ? this.type : 0;
            short portSignalType = this.portSignalTypeSet ? this.portSignalType : (short)0;
            short reserved = this.reservedSet ? this.reserved : (short)0;
            short portType = this.portTypeSet ? this.portType : (short)0;
            return new OFPortDescPropOpticalTransportVer13(type, portSignalType, reserved, portType);
        }
    }

    static class BuilderWithParent
    implements OFPortDescPropOpticalTransport.Builder {
        final OFPortDescPropOpticalTransportVer13 parentMessage;
        private boolean typeSet;
        private int type;
        private boolean portSignalTypeSet;
        private short portSignalType;
        private boolean reservedSet;
        private short reserved;
        private boolean portTypeSet;
        private short portType;

        BuilderWithParent(OFPortDescPropOpticalTransportVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public OFPortDescPropOpticalTransport.Builder setType(int type) {
            this.type = type;
            this.typeSet = true;
            return this;
        }

        @Override
        public short getPortSignalType() {
            return this.portSignalType;
        }

        @Override
        public OFPortDescPropOpticalTransport.Builder setPortSignalType(short portSignalType) {
            this.portSignalType = portSignalType;
            this.portSignalTypeSet = true;
            return this;
        }

        @Override
        public short getReserved() {
            return this.reserved;
        }

        @Override
        public OFPortDescPropOpticalTransport.Builder setReserved(short reserved) {
            this.reserved = reserved;
            this.reservedSet = true;
            return this;
        }

        @Override
        public short getPortType() {
            return this.portType;
        }

        @Override
        public OFPortDescPropOpticalTransport.Builder setPortType(short portType) {
            this.portType = portType;
            this.portTypeSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFPortDescPropOpticalTransport build() {
            int type = this.typeSet ? this.type : this.parentMessage.type;
            short portSignalType = this.portSignalTypeSet ? this.portSignalType : this.parentMessage.portSignalType;
            short reserved = this.reservedSet ? this.reserved : this.parentMessage.reserved;
            short portType = this.portTypeSet ? this.portType : this.parentMessage.portType;
            return new OFPortDescPropOpticalTransportVer13(type, portSignalType, reserved, portType);
        }
    }
}

