/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortOpticalTransportApplicationCode;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U8;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortOpticalTransportApplicationCodeVer13
implements OFPortOpticalTransportApplicationCode {
    private static final Logger logger = LoggerFactory.getLogger(OFPortOpticalTransportApplicationCodeVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 18;
    private static final int DEFAULT_FEATURE_TYPE = 0;
    private static final short DEFAULT_OIC_TYPE = 0;
    private static final String DEFAULT_APP_CODE = "";
    private final int featureType;
    private final short oicType;
    private final String appCode;
    static final OFPortOpticalTransportApplicationCodeVer13 DEFAULT = new OFPortOpticalTransportApplicationCodeVer13(0, 0, "");
    static final Reader READER = new Reader();
    static final OFPortOpticalTransportApplicationCodeVer13Funnel FUNNEL = new OFPortOpticalTransportApplicationCodeVer13Funnel();
    static final Writer WRITER = new Writer();

    OFPortOpticalTransportApplicationCodeVer13(int featureType, short oicType, String appCode) {
        if (appCode == null) {
            throw new NullPointerException("OFPortOpticalTransportApplicationCodeVer13: property appCode cannot be null");
        }
        this.featureType = featureType;
        this.oicType = oicType;
        this.appCode = appCode;
    }

    @Override
    public int getFeatureType() {
        return this.featureType;
    }

    @Override
    public short getOicType() {
        return this.oicType;
    }

    @Override
    public String getAppCode() {
        return this.appCode;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFPortOpticalTransportApplicationCode.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortOpticalTransportApplicationCodeVer13(");
        b.append("featureType=").append(this.featureType);
        b.append(", ");
        b.append("oicType=").append(this.oicType);
        b.append(", ");
        b.append("appCode=").append(this.appCode);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortOpticalTransportApplicationCodeVer13 other = (OFPortOpticalTransportApplicationCodeVer13)obj;
        if (this.featureType != other.featureType) {
            return false;
        }
        if (this.oicType != other.oicType) {
            return false;
        }
        return !(this.appCode == null ? other.appCode != null : !this.appCode.equals(other.appCode));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.featureType;
        result = 31 * result + this.oicType;
        result = 31 * result + (this.appCode == null ? 0 : this.appCode.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortOpticalTransportApplicationCodeVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFPortOpticalTransportApplicationCodeVer13 message) {
            bb.writeShort((int)U16.t(message.featureType));
            bb.writeByte((int)U8.t(message.oicType));
            ChannelUtils.writeFixedLengthString(bb, message.appCode, 15);
        }
    }

    static class OFPortOpticalTransportApplicationCodeVer13Funnel
    implements Funnel<OFPortOpticalTransportApplicationCodeVer13> {
        private static final long serialVersionUID = 1L;

        OFPortOpticalTransportApplicationCodeVer13Funnel() {
        }

        public void funnel(OFPortOpticalTransportApplicationCodeVer13 message, PrimitiveSink sink) {
            sink.putInt(message.featureType);
            sink.putShort(message.oicType);
            sink.putUnencodedChars((CharSequence)message.appCode);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortOpticalTransportApplicationCode> {
        Reader() {
        }

        @Override
        public OFPortOpticalTransportApplicationCode readFrom(ChannelBuffer bb) throws OFParseError {
            int featureType = U16.f(bb.readShort());
            short oicType = U8.f(bb.readByte());
            String appCode = ChannelUtils.readFixedLengthString(bb, 15);
            OFPortOpticalTransportApplicationCodeVer13 portOpticalTransportApplicationCodeVer13 = new OFPortOpticalTransportApplicationCodeVer13(featureType, oicType, appCode);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portOpticalTransportApplicationCodeVer13);
            }
            return portOpticalTransportApplicationCodeVer13;
        }
    }

    static class Builder
    implements OFPortOpticalTransportApplicationCode.Builder {
        private boolean featureTypeSet;
        private int featureType;
        private boolean oicTypeSet;
        private short oicType;
        private boolean appCodeSet;
        private String appCode;

        Builder() {
        }

        @Override
        public int getFeatureType() {
            return this.featureType;
        }

        @Override
        public OFPortOpticalTransportApplicationCode.Builder setFeatureType(int featureType) {
            this.featureType = featureType;
            this.featureTypeSet = true;
            return this;
        }

        @Override
        public short getOicType() {
            return this.oicType;
        }

        @Override
        public OFPortOpticalTransportApplicationCode.Builder setOicType(short oicType) {
            this.oicType = oicType;
            this.oicTypeSet = true;
            return this;
        }

        @Override
        public String getAppCode() {
            return this.appCode;
        }

        @Override
        public OFPortOpticalTransportApplicationCode.Builder setAppCode(String appCode) {
            this.appCode = appCode;
            this.appCodeSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFPortOpticalTransportApplicationCode build() {
            String appCode;
            int featureType = this.featureTypeSet ? this.featureType : 0;
            short oicType = this.oicTypeSet ? this.oicType : (short)0;
            String string = appCode = this.appCodeSet ? this.appCode : OFPortOpticalTransportApplicationCodeVer13.DEFAULT_APP_CODE;
            if (appCode == null) {
                throw new NullPointerException("Property appCode must not be null");
            }
            return new OFPortOpticalTransportApplicationCodeVer13(featureType, oicType, appCode);
        }
    }

    static class BuilderWithParent
    implements OFPortOpticalTransportApplicationCode.Builder {
        final OFPortOpticalTransportApplicationCodeVer13 parentMessage;
        private boolean featureTypeSet;
        private int featureType;
        private boolean oicTypeSet;
        private short oicType;
        private boolean appCodeSet;
        private String appCode;

        BuilderWithParent(OFPortOpticalTransportApplicationCodeVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getFeatureType() {
            return this.featureType;
        }

        @Override
        public OFPortOpticalTransportApplicationCode.Builder setFeatureType(int featureType) {
            this.featureType = featureType;
            this.featureTypeSet = true;
            return this;
        }

        @Override
        public short getOicType() {
            return this.oicType;
        }

        @Override
        public OFPortOpticalTransportApplicationCode.Builder setOicType(short oicType) {
            this.oicType = oicType;
            this.oicTypeSet = true;
            return this;
        }

        @Override
        public String getAppCode() {
            return this.appCode;
        }

        @Override
        public OFPortOpticalTransportApplicationCode.Builder setAppCode(String appCode) {
            this.appCode = appCode;
            this.appCodeSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFPortOpticalTransportApplicationCode build() {
            String appCode;
            int featureType = this.featureTypeSet ? this.featureType : this.parentMessage.featureType;
            short oicType = this.oicTypeSet ? this.oicType : this.parentMessage.oicType;
            String string = appCode = this.appCodeSet ? this.appCode : this.parentMessage.appCode;
            if (appCode == null) {
                throw new NullPointerException("Property appCode must not be null");
            }
            return new OFPortOpticalTransportApplicationCodeVer13(featureType, oicType, appCode);
        }
    }
}

