/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.List;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortConfig;
import org.projectfloodlight.openflow.protocol.OFPortDescPropOpticalTransport;
import org.projectfloodlight.openflow.protocol.OFPortOptical;
import org.projectfloodlight.openflow.protocol.OFPortState;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver13.OFPortConfigSerializerVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFPortDescPropOpticalTransportVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFPortStateSerializerVer13;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortOpticalVer13
implements OFPortOptical {
    private static final Logger logger = LoggerFactory.getLogger(OFPortOpticalVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 40;
    private static final OFPort DEFAULT_PORT_NO = OFPort.ANY;
    private static final MacAddress DEFAULT_HW_ADDR = MacAddress.NONE;
    private static final String DEFAULT_NAME = "";
    private static final Set<OFPortConfig> DEFAULT_CONFIG = ImmutableSet.of();
    private static final Set<OFPortState> DEFAULT_STATE = ImmutableSet.of();
    private static final List<OFPortDescPropOpticalTransport> DEFAULT_DESC = ImmutableList.of();
    private final OFPort portNo;
    private final MacAddress hwAddr;
    private final String name;
    private final Set<OFPortConfig> config;
    private final Set<OFPortState> state;
    private final List<OFPortDescPropOpticalTransport> desc;
    static final OFPortOpticalVer13 DEFAULT = new OFPortOpticalVer13(DEFAULT_PORT_NO, DEFAULT_HW_ADDR, "", DEFAULT_CONFIG, DEFAULT_STATE, DEFAULT_DESC);
    static final Reader READER = new Reader();
    static final OFPortOpticalVer13Funnel FUNNEL = new OFPortOpticalVer13Funnel();
    static final Writer WRITER = new Writer();

    OFPortOpticalVer13(OFPort portNo, MacAddress hwAddr, String name, Set<OFPortConfig> config, Set<OFPortState> state, List<OFPortDescPropOpticalTransport> desc) {
        if (portNo == null) {
            throw new NullPointerException("OFPortOpticalVer13: property portNo cannot be null");
        }
        if (hwAddr == null) {
            throw new NullPointerException("OFPortOpticalVer13: property hwAddr cannot be null");
        }
        if (name == null) {
            throw new NullPointerException("OFPortOpticalVer13: property name cannot be null");
        }
        if (config == null) {
            throw new NullPointerException("OFPortOpticalVer13: property config cannot be null");
        }
        if (state == null) {
            throw new NullPointerException("OFPortOpticalVer13: property state cannot be null");
        }
        if (desc == null) {
            throw new NullPointerException("OFPortOpticalVer13: property desc cannot be null");
        }
        this.portNo = portNo;
        this.hwAddr = hwAddr;
        this.name = name;
        this.config = config;
        this.state = state;
        this.desc = desc;
    }

    @Override
    public OFPort getPortNo() {
        return this.portNo;
    }

    @Override
    public MacAddress getHwAddr() {
        return this.hwAddr;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<OFPortConfig> getConfig() {
        return this.config;
    }

    @Override
    public Set<OFPortState> getState() {
        return this.state;
    }

    @Override
    public List<OFPortDescPropOpticalTransport> getDesc() {
        return this.desc;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFPortOptical.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortOpticalVer13(");
        b.append("portNo=").append(this.portNo);
        b.append(", ");
        b.append("hwAddr=").append(this.hwAddr);
        b.append(", ");
        b.append("name=").append(this.name);
        b.append(", ");
        b.append("config=").append(this.config);
        b.append(", ");
        b.append("state=").append(this.state);
        b.append(", ");
        b.append("desc=").append(this.desc);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortOpticalVer13 other = (OFPortOpticalVer13)obj;
        if (this.portNo == null ? other.portNo != null : !this.portNo.equals(other.portNo)) {
            return false;
        }
        if (this.hwAddr == null ? other.hwAddr != null : !this.hwAddr.equals(other.hwAddr)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.config == null ? other.config != null : !this.config.equals(other.config)) {
            return false;
        }
        if (this.state == null ? other.state != null : !this.state.equals(other.state)) {
            return false;
        }
        return !(this.desc == null ? other.desc != null : !this.desc.equals(other.desc));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.portNo == null ? 0 : this.portNo.hashCode());
        result = 31 * result + (this.hwAddr == null ? 0 : this.hwAddr.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.config == null ? 0 : this.config.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        result = 31 * result + (this.desc == null ? 0 : this.desc.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortOpticalVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFPortOpticalVer13 message) {
            int startIndex = bb.writerIndex();
            message.portNo.write4Bytes(bb);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeZero(2);
            message.hwAddr.write6Bytes(bb);
            bb.writeZero(2);
            ChannelUtils.writeFixedLengthString(bb, message.name, 16);
            OFPortConfigSerializerVer13.writeTo(bb, message.config);
            OFPortStateSerializerVer13.writeTo(bb, message.state);
            ChannelUtils.writeList(bb, message.desc);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFPortOpticalVer13Funnel
    implements Funnel<OFPortOpticalVer13> {
        private static final long serialVersionUID = 1L;

        OFPortOpticalVer13Funnel() {
        }

        public void funnel(OFPortOpticalVer13 message, PrimitiveSink sink) {
            message.portNo.putTo(sink);
            message.hwAddr.putTo(sink);
            sink.putUnencodedChars((CharSequence)message.name);
            OFPortConfigSerializerVer13.putTo(message.config, sink);
            OFPortStateSerializerVer13.putTo(message.state, sink);
            FunnelUtils.putList(message.desc, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortOptical> {
        Reader() {
        }

        @Override
        public OFPortOptical readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            OFPort portNo = OFPort.read4Bytes(bb);
            int length = U16.f(bb.readShort());
            if (length < 40) {
                throw new OFParseError("Wrong length: Expected to be >= 40, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(2);
            MacAddress hwAddr = MacAddress.read6Bytes(bb);
            bb.skipBytes(2);
            String name = ChannelUtils.readFixedLengthString(bb, 16);
            Set<OFPortConfig> config = OFPortConfigSerializerVer13.readFrom(bb);
            Set<OFPortState> state = OFPortStateSerializerVer13.readFrom(bb);
            List<OFPortDescPropOpticalTransport> desc = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFPortDescPropOpticalTransportVer13.READER);
            OFPortOpticalVer13 portOpticalVer13 = new OFPortOpticalVer13(portNo, hwAddr, name, config, state, desc);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portOpticalVer13);
            }
            return portOpticalVer13;
        }
    }

    static class Builder
    implements OFPortOptical.Builder {
        private boolean portNoSet;
        private OFPort portNo;
        private boolean hwAddrSet;
        private MacAddress hwAddr;
        private boolean nameSet;
        private String name;
        private boolean configSet;
        private Set<OFPortConfig> config;
        private boolean stateSet;
        private Set<OFPortState> state;
        private boolean descSet;
        private List<OFPortDescPropOpticalTransport> desc;

        Builder() {
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFPortOptical.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public MacAddress getHwAddr() {
            return this.hwAddr;
        }

        @Override
        public OFPortOptical.Builder setHwAddr(MacAddress hwAddr) {
            this.hwAddr = hwAddr;
            this.hwAddrSet = true;
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public OFPortOptical.Builder setName(String name) {
            this.name = name;
            this.nameSet = true;
            return this;
        }

        @Override
        public Set<OFPortConfig> getConfig() {
            return this.config;
        }

        @Override
        public OFPortOptical.Builder setConfig(Set<OFPortConfig> config) {
            this.config = config;
            this.configSet = true;
            return this;
        }

        @Override
        public Set<OFPortState> getState() {
            return this.state;
        }

        @Override
        public OFPortOptical.Builder setState(Set<OFPortState> state) {
            this.state = state;
            this.stateSet = true;
            return this;
        }

        @Override
        public List<OFPortDescPropOpticalTransport> getDesc() {
            return this.desc;
        }

        @Override
        public OFPortOptical.Builder setDesc(List<OFPortDescPropOpticalTransport> desc) {
            this.desc = desc;
            this.descSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFPortOptical build() {
            List<OFPortDescPropOpticalTransport> desc;
            Set<OFPortState> state;
            Set<OFPortConfig> config;
            String name;
            MacAddress hwAddr;
            OFPort portNo;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : DEFAULT_PORT_NO;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            MacAddress macAddress = hwAddr = this.hwAddrSet ? this.hwAddr : DEFAULT_HW_ADDR;
            if (hwAddr == null) {
                throw new NullPointerException("Property hwAddr must not be null");
            }
            String string = name = this.nameSet ? this.name : OFPortOpticalVer13.DEFAULT_NAME;
            if (name == null) {
                throw new NullPointerException("Property name must not be null");
            }
            Set<OFPortConfig> set = config = this.configSet ? this.config : DEFAULT_CONFIG;
            if (config == null) {
                throw new NullPointerException("Property config must not be null");
            }
            Set<OFPortState> set2 = state = this.stateSet ? this.state : DEFAULT_STATE;
            if (state == null) {
                throw new NullPointerException("Property state must not be null");
            }
            List<OFPortDescPropOpticalTransport> list = desc = this.descSet ? this.desc : DEFAULT_DESC;
            if (desc == null) {
                throw new NullPointerException("Property desc must not be null");
            }
            return new OFPortOpticalVer13(portNo, hwAddr, name, config, state, desc);
        }
    }

    static class BuilderWithParent
    implements OFPortOptical.Builder {
        final OFPortOpticalVer13 parentMessage;
        private boolean portNoSet;
        private OFPort portNo;
        private boolean hwAddrSet;
        private MacAddress hwAddr;
        private boolean nameSet;
        private String name;
        private boolean configSet;
        private Set<OFPortConfig> config;
        private boolean stateSet;
        private Set<OFPortState> state;
        private boolean descSet;
        private List<OFPortDescPropOpticalTransport> desc;

        BuilderWithParent(OFPortOpticalVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFPortOptical.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public MacAddress getHwAddr() {
            return this.hwAddr;
        }

        @Override
        public OFPortOptical.Builder setHwAddr(MacAddress hwAddr) {
            this.hwAddr = hwAddr;
            this.hwAddrSet = true;
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public OFPortOptical.Builder setName(String name) {
            this.name = name;
            this.nameSet = true;
            return this;
        }

        @Override
        public Set<OFPortConfig> getConfig() {
            return this.config;
        }

        @Override
        public OFPortOptical.Builder setConfig(Set<OFPortConfig> config) {
            this.config = config;
            this.configSet = true;
            return this;
        }

        @Override
        public Set<OFPortState> getState() {
            return this.state;
        }

        @Override
        public OFPortOptical.Builder setState(Set<OFPortState> state) {
            this.state = state;
            this.stateSet = true;
            return this;
        }

        @Override
        public List<OFPortDescPropOpticalTransport> getDesc() {
            return this.desc;
        }

        @Override
        public OFPortOptical.Builder setDesc(List<OFPortDescPropOpticalTransport> desc) {
            this.desc = desc;
            this.descSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFPortOptical build() {
            List desc;
            Set state;
            Set config;
            String name;
            MacAddress hwAddr;
            OFPort portNo;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : this.parentMessage.portNo;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            MacAddress macAddress = hwAddr = this.hwAddrSet ? this.hwAddr : this.parentMessage.hwAddr;
            if (hwAddr == null) {
                throw new NullPointerException("Property hwAddr must not be null");
            }
            String string = name = this.nameSet ? this.name : this.parentMessage.name;
            if (name == null) {
                throw new NullPointerException("Property name must not be null");
            }
            Set set = config = this.configSet ? this.config : this.parentMessage.config;
            if (config == null) {
                throw new NullPointerException("Property config must not be null");
            }
            Set set2 = state = this.stateSet ? this.state : this.parentMessage.state;
            if (state == null) {
                throw new NullPointerException("Property state must not be null");
            }
            List list = desc = this.descSet ? this.desc : this.parentMessage.desc;
            if (desc == null) {
                throw new NullPointerException("Property desc must not be null");
            }
            return new OFPortOpticalVer13(portNo, hwAddr, name, config, state, desc);
        }
    }
}

