/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionCopyTtlIn;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionCopyTtlInVer14
implements OFActionCopyTtlIn {
    private static final Logger logger = LoggerFactory.getLogger(OFActionCopyTtlInVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    static final OFActionCopyTtlInVer14 DEFAULT = new OFActionCopyTtlInVer14();
    static final OFActionCopyTtlInVer14 INSTANCE = new OFActionCopyTtlInVer14();
    static final Reader READER = new Reader();
    static final OFActionCopyTtlInVer14Funnel FUNNEL = new OFActionCopyTtlInVer14Funnel();
    static final Writer WRITER = new Writer();

    private OFActionCopyTtlInVer14() {
    }

    @Override
    public OFActionType getType() {
        return OFActionType.COPY_TTL_IN;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFActionCopyTtlIn.Builder createBuilder() {
        throw new UnsupportedOperationException("OFActionCopyTtlInVer14 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionCopyTtlInVer14(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionCopyTtlInVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFActionCopyTtlInVer14 message) {
            bb.writeShort(12);
            bb.writeShort(8);
            bb.writeZero(4);
        }
    }

    static class OFActionCopyTtlInVer14Funnel
    implements Funnel<OFActionCopyTtlInVer14> {
        private static final long serialVersionUID = 1L;

        OFActionCopyTtlInVer14Funnel() {
        }

        public void funnel(OFActionCopyTtlInVer14 message, PrimitiveSink sink) {
            sink.putShort((short)12);
            sink.putShort((short)8);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionCopyTtlIn> {
        Reader() {
        }

        @Override
        public OFActionCopyTtlIn readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 12) {
                throw new OFParseError("Wrong type: Expected=OFActionType.COPY_TTL_IN(12), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(4);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

