/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.actionid.OFActionIdNiciraPopQueue;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionIdNiciraPopQueueVer14
implements OFActionIdNiciraPopQueue {
    private static final Logger logger = LoggerFactory.getLogger(OFActionIdNiciraPopQueueVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 10;
    static final OFActionIdNiciraPopQueueVer14 DEFAULT = new OFActionIdNiciraPopQueueVer14();
    static final OFActionIdNiciraPopQueueVer14 INSTANCE = new OFActionIdNiciraPopQueueVer14();
    static final Reader READER = new Reader();
    static final OFActionIdNiciraPopQueueVer14Funnel FUNNEL = new OFActionIdNiciraPopQueueVer14Funnel();
    static final Writer WRITER = new Writer();

    private OFActionIdNiciraPopQueueVer14() {
    }

    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 8992L;
    }

    @Override
    public int getSubtype() {
        return 5;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFActionIdNiciraPopQueue.Builder createBuilder() {
        throw new UnsupportedOperationException("OFActionIdNiciraPopQueueVer14 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionIdNiciraPopQueueVer14(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionIdNiciraPopQueueVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFActionIdNiciraPopQueueVer14 message) {
            bb.writeShort(-1);
            bb.writeShort(10);
            bb.writeInt(8992);
            bb.writeShort(5);
        }
    }

    static class OFActionIdNiciraPopQueueVer14Funnel
    implements Funnel<OFActionIdNiciraPopQueueVer14> {
        private static final long serialVersionUID = 1L;

        OFActionIdNiciraPopQueueVer14Funnel() {
        }

        public void funnel(OFActionIdNiciraPopQueueVer14 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)10);
            sink.putInt(8992);
            sink.putShort((short)5);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionIdNiciraPopQueue> {
        Reader() {
        }

        @Override
        public OFActionIdNiciraPopQueue readFrom(ChannelBuffer bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 10) {
                throw new OFParseError("Wrong length: Expected=10(10), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 8992) {
                throw new OFParseError("Wrong experimenter: Expected=0x2320L(0x2320L), got=" + experimenter);
            }
            short subtype = bb.readShort();
            if (subtype != 5) {
                throw new OFParseError("Wrong subtype: Expected=0x5(0x5), got=" + subtype);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

