/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionNiciraMove;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionNiciraMoveVer14
implements OFActionNiciraMove {
    private static final Logger logger = LoggerFactory.getLogger(OFActionNiciraMoveVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 24;
    private static final int DEFAULT_N_BITS = 0;
    private static final int DEFAULT_SRC_OFS = 0;
    private static final int DEFAULT_DST_OFS = 0;
    private static final long DEFAULT_SRC = 0L;
    private static final long DEFAULT_DST = 0L;
    private final int nBits;
    private final int srcOfs;
    private final int dstOfs;
    private final long src;
    private final long dst;
    static final OFActionNiciraMoveVer14 DEFAULT = new OFActionNiciraMoveVer14(0, 0, 0, 0L, 0L);
    static final Reader READER = new Reader();
    static final OFActionNiciraMoveVer14Funnel FUNNEL = new OFActionNiciraMoveVer14Funnel();
    static final Writer WRITER = new Writer();

    OFActionNiciraMoveVer14(int nBits, int srcOfs, int dstOfs, long src, long dst) {
        this.nBits = nBits;
        this.srcOfs = srcOfs;
        this.dstOfs = dstOfs;
        this.src = src;
        this.dst = dst;
    }

    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 8992L;
    }

    @Override
    public int getSubtype() {
        return 6;
    }

    @Override
    public int getNBits() {
        return this.nBits;
    }

    @Override
    public int getSrcOfs() {
        return this.srcOfs;
    }

    @Override
    public int getDstOfs() {
        return this.dstOfs;
    }

    @Override
    public long getSrc() {
        return this.src;
    }

    @Override
    public long getDst() {
        return this.dst;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFActionNiciraMove.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionNiciraMoveVer14(");
        b.append("nBits=").append(this.nBits);
        b.append(", ");
        b.append("srcOfs=").append(this.srcOfs);
        b.append(", ");
        b.append("dstOfs=").append(this.dstOfs);
        b.append(", ");
        b.append("src=").append(this.src);
        b.append(", ");
        b.append("dst=").append(this.dst);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionNiciraMoveVer14 other = (OFActionNiciraMoveVer14)obj;
        if (this.nBits != other.nBits) {
            return false;
        }
        if (this.srcOfs != other.srcOfs) {
            return false;
        }
        if (this.dstOfs != other.dstOfs) {
            return false;
        }
        if (this.src != other.src) {
            return false;
        }
        return this.dst == other.dst;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.nBits;
        result = 31 * result + this.srcOfs;
        result = 31 * result + this.dstOfs;
        result = 31 * (int)(this.src ^ this.src >>> 32);
        result = 31 * (int)(this.dst ^ this.dst >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionNiciraMoveVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFActionNiciraMoveVer14 message) {
            bb.writeShort(-1);
            bb.writeShort(24);
            bb.writeInt(8992);
            bb.writeShort(6);
            bb.writeShort((int)U16.t(message.nBits));
            bb.writeShort((int)U16.t(message.srcOfs));
            bb.writeShort((int)U16.t(message.dstOfs));
            bb.writeInt(U32.t(message.src));
            bb.writeInt(U32.t(message.dst));
        }
    }

    static class OFActionNiciraMoveVer14Funnel
    implements Funnel<OFActionNiciraMoveVer14> {
        private static final long serialVersionUID = 1L;

        OFActionNiciraMoveVer14Funnel() {
        }

        public void funnel(OFActionNiciraMoveVer14 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)24);
            sink.putInt(8992);
            sink.putShort((short)6);
            sink.putInt(message.nBits);
            sink.putInt(message.srcOfs);
            sink.putInt(message.dstOfs);
            sink.putLong(message.src);
            sink.putLong(message.dst);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionNiciraMove> {
        Reader() {
        }

        @Override
        public OFActionNiciraMove readFrom(ChannelBuffer bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 24) {
                throw new OFParseError("Wrong length: Expected=24(24), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 8992) {
                throw new OFParseError("Wrong experimenter: Expected=0x2320L(0x2320L), got=" + experimenter);
            }
            short subtype = bb.readShort();
            if (subtype != 6) {
                throw new OFParseError("Wrong subtype: Expected=0x6(0x6), got=" + subtype);
            }
            int nBits = U16.f(bb.readShort());
            int srcOfs = U16.f(bb.readShort());
            int dstOfs = U16.f(bb.readShort());
            long src = U32.f(bb.readInt());
            long dst = U32.f(bb.readInt());
            OFActionNiciraMoveVer14 actionNiciraMoveVer14 = new OFActionNiciraMoveVer14(nBits, srcOfs, dstOfs, src, dst);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionNiciraMoveVer14);
            }
            return actionNiciraMoveVer14;
        }
    }

    static class Builder
    implements OFActionNiciraMove.Builder {
        private boolean nBitsSet;
        private int nBits;
        private boolean srcOfsSet;
        private int srcOfs;
        private boolean dstOfsSet;
        private int dstOfs;
        private boolean srcSet;
        private long src;
        private boolean dstSet;
        private long dst;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.EXPERIMENTER;
        }

        @Override
        public long getExperimenter() {
            return 8992L;
        }

        @Override
        public int getSubtype() {
            return 6;
        }

        @Override
        public int getNBits() {
            return this.nBits;
        }

        @Override
        public OFActionNiciraMove.Builder setNBits(int nBits) {
            this.nBits = nBits;
            this.nBitsSet = true;
            return this;
        }

        @Override
        public int getSrcOfs() {
            return this.srcOfs;
        }

        @Override
        public OFActionNiciraMove.Builder setSrcOfs(int srcOfs) {
            this.srcOfs = srcOfs;
            this.srcOfsSet = true;
            return this;
        }

        @Override
        public int getDstOfs() {
            return this.dstOfs;
        }

        @Override
        public OFActionNiciraMove.Builder setDstOfs(int dstOfs) {
            this.dstOfs = dstOfs;
            this.dstOfsSet = true;
            return this;
        }

        @Override
        public long getSrc() {
            return this.src;
        }

        @Override
        public OFActionNiciraMove.Builder setSrc(long src) {
            this.src = src;
            this.srcSet = true;
            return this;
        }

        @Override
        public long getDst() {
            return this.dst;
        }

        @Override
        public OFActionNiciraMove.Builder setDst(long dst) {
            this.dst = dst;
            this.dstSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFActionNiciraMove build() {
            int nBits = this.nBitsSet ? this.nBits : 0;
            int srcOfs = this.srcOfsSet ? this.srcOfs : 0;
            int dstOfs = this.dstOfsSet ? this.dstOfs : 0;
            long src = this.srcSet ? this.src : 0L;
            long dst = this.dstSet ? this.dst : 0L;
            return new OFActionNiciraMoveVer14(nBits, srcOfs, dstOfs, src, dst);
        }
    }

    static class BuilderWithParent
    implements OFActionNiciraMove.Builder {
        final OFActionNiciraMoveVer14 parentMessage;
        private boolean nBitsSet;
        private int nBits;
        private boolean srcOfsSet;
        private int srcOfs;
        private boolean dstOfsSet;
        private int dstOfs;
        private boolean srcSet;
        private long src;
        private boolean dstSet;
        private long dst;

        BuilderWithParent(OFActionNiciraMoveVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.EXPERIMENTER;
        }

        @Override
        public long getExperimenter() {
            return 8992L;
        }

        @Override
        public int getSubtype() {
            return 6;
        }

        @Override
        public int getNBits() {
            return this.nBits;
        }

        @Override
        public OFActionNiciraMove.Builder setNBits(int nBits) {
            this.nBits = nBits;
            this.nBitsSet = true;
            return this;
        }

        @Override
        public int getSrcOfs() {
            return this.srcOfs;
        }

        @Override
        public OFActionNiciraMove.Builder setSrcOfs(int srcOfs) {
            this.srcOfs = srcOfs;
            this.srcOfsSet = true;
            return this;
        }

        @Override
        public int getDstOfs() {
            return this.dstOfs;
        }

        @Override
        public OFActionNiciraMove.Builder setDstOfs(int dstOfs) {
            this.dstOfs = dstOfs;
            this.dstOfsSet = true;
            return this;
        }

        @Override
        public long getSrc() {
            return this.src;
        }

        @Override
        public OFActionNiciraMove.Builder setSrc(long src) {
            this.src = src;
            this.srcSet = true;
            return this;
        }

        @Override
        public long getDst() {
            return this.dst;
        }

        @Override
        public OFActionNiciraMove.Builder setDst(long dst) {
            this.dst = dst;
            this.dstSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFActionNiciraMove build() {
            int nBits = this.nBitsSet ? this.nBits : this.parentMessage.nBits;
            int srcOfs = this.srcOfsSet ? this.srcOfs : this.parentMessage.srcOfs;
            int dstOfs = this.dstOfsSet ? this.dstOfs : this.parentMessage.dstOfs;
            long src = this.srcSet ? this.src : this.parentMessage.src;
            long dst = this.dstSet ? this.dst : this.parentMessage.dst;
            return new OFActionNiciraMoveVer14(nBits, srcOfs, dstOfs, src, dst);
        }
    }
}

