/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnGentableBucketStatsEntry;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U128;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnGentableBucketStatsEntryVer14
implements OFBsnGentableBucketStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnGentableBucketStatsEntryVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 16;
    private static final U128 DEFAULT_CHECKSUM = U128.ZERO;
    private final U128 checksum;
    static final OFBsnGentableBucketStatsEntryVer14 DEFAULT = new OFBsnGentableBucketStatsEntryVer14(DEFAULT_CHECKSUM);
    static final Reader READER = new Reader();
    static final OFBsnGentableBucketStatsEntryVer14Funnel FUNNEL = new OFBsnGentableBucketStatsEntryVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnGentableBucketStatsEntryVer14(U128 checksum) {
        if (checksum == null) {
            throw new NullPointerException("OFBsnGentableBucketStatsEntryVer14: property checksum cannot be null");
        }
        this.checksum = checksum;
    }

    @Override
    public U128 getChecksum() {
        return this.checksum;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnGentableBucketStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnGentableBucketStatsEntryVer14(");
        b.append("checksum=").append(this.checksum);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGentableBucketStatsEntryVer14 other = (OFBsnGentableBucketStatsEntryVer14)obj;
        return !(this.checksum == null ? other.checksum != null : !this.checksum.equals(other.checksum));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.checksum == null ? 0 : this.checksum.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnGentableBucketStatsEntryVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnGentableBucketStatsEntryVer14 message) {
            message.checksum.write16Bytes(bb);
        }
    }

    static class OFBsnGentableBucketStatsEntryVer14Funnel
    implements Funnel<OFBsnGentableBucketStatsEntryVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnGentableBucketStatsEntryVer14Funnel() {
        }

        public void funnel(OFBsnGentableBucketStatsEntryVer14 message, PrimitiveSink sink) {
            message.checksum.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnGentableBucketStatsEntry> {
        Reader() {
        }

        @Override
        public OFBsnGentableBucketStatsEntry readFrom(ChannelBuffer bb) throws OFParseError {
            U128 checksum = U128.read16Bytes(bb);
            OFBsnGentableBucketStatsEntryVer14 bsnGentableBucketStatsEntryVer14 = new OFBsnGentableBucketStatsEntryVer14(checksum);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnGentableBucketStatsEntryVer14);
            }
            return bsnGentableBucketStatsEntryVer14;
        }
    }

    static class Builder
    implements OFBsnGentableBucketStatsEntry.Builder {
        private boolean checksumSet;
        private U128 checksum;

        Builder() {
        }

        @Override
        public U128 getChecksum() {
            return this.checksum;
        }

        @Override
        public OFBsnGentableBucketStatsEntry.Builder setChecksum(U128 checksum) {
            this.checksum = checksum;
            this.checksumSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnGentableBucketStatsEntry build() {
            U128 checksum;
            U128 u128 = checksum = this.checksumSet ? this.checksum : DEFAULT_CHECKSUM;
            if (checksum == null) {
                throw new NullPointerException("Property checksum must not be null");
            }
            return new OFBsnGentableBucketStatsEntryVer14(checksum);
        }
    }

    static class BuilderWithParent
    implements OFBsnGentableBucketStatsEntry.Builder {
        final OFBsnGentableBucketStatsEntryVer14 parentMessage;
        private boolean checksumSet;
        private U128 checksum;

        BuilderWithParent(OFBsnGentableBucketStatsEntryVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public U128 getChecksum() {
            return this.checksum;
        }

        @Override
        public OFBsnGentableBucketStatsEntry.Builder setChecksum(U128 checksum) {
            this.checksum = checksum;
            this.checksumSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnGentableBucketStatsEntry build() {
            U128 checksum;
            U128 u128 = checksum = this.checksumSet ? this.checksum : this.parentMessage.checksum;
            if (checksum == null) {
                throw new NullPointerException("Property checksum must not be null");
            }
            return new OFBsnGentableBucketStatsEntryVer14(checksum);
        }
    }
}

