/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnGentableClearReply;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.GenTableId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnGentableClearReplyVer14
implements OFBsnGentableClearReply {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnGentableClearReplyVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 28;
    private static final long DEFAULT_XID = 0L;
    private static final long DEFAULT_DELETED_COUNT = 0L;
    private static final long DEFAULT_ERROR_COUNT = 0L;
    private final long xid;
    private final GenTableId tableId;
    private final long deletedCount;
    private final long errorCount;
    static final Reader READER = new Reader();
    static final OFBsnGentableClearReplyVer14Funnel FUNNEL = new OFBsnGentableClearReplyVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnGentableClearReplyVer14(long xid, GenTableId tableId, long deletedCount, long errorCount) {
        if (tableId == null) {
            throw new NullPointerException("OFBsnGentableClearReplyVer14: property tableId cannot be null");
        }
        this.xid = xid;
        this.tableId = tableId;
        this.deletedCount = deletedCount;
        this.errorCount = errorCount;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 49L;
    }

    @Override
    public GenTableId getTableId() {
        return this.tableId;
    }

    @Override
    public long getDeletedCount() {
        return this.deletedCount;
    }

    @Override
    public long getErrorCount() {
        return this.errorCount;
    }

    @Override
    public OFBsnGentableClearReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnGentableClearReplyVer14(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("tableId=").append(this.tableId);
        b.append(", ");
        b.append("deletedCount=").append(this.deletedCount);
        b.append(", ");
        b.append("errorCount=").append(this.errorCount);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGentableClearReplyVer14 other = (OFBsnGentableClearReplyVer14)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        if (this.deletedCount != other.deletedCount) {
            return false;
        }
        return this.errorCount == other.errorCount;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * (int)(this.deletedCount ^ this.deletedCount >>> 32);
        result = 31 * (int)(this.errorCount ^ this.errorCount >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnGentableClearReplyVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnGentableClearReplyVer14 message) {
            bb.writeByte(5);
            bb.writeByte(4);
            bb.writeShort(28);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(49);
            message.tableId.write2Bytes(bb);
            bb.writeZero(2);
            bb.writeInt(U32.t(message.deletedCount));
            bb.writeInt(U32.t(message.errorCount));
        }
    }

    static class OFBsnGentableClearReplyVer14Funnel
    implements Funnel<OFBsnGentableClearReplyVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnGentableClearReplyVer14Funnel() {
        }

        public void funnel(OFBsnGentableClearReplyVer14 message, PrimitiveSink sink) {
            sink.putByte((byte)5);
            sink.putByte((byte)4);
            sink.putShort((short)28);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(49);
            message.tableId.putTo(sink);
            sink.putLong(message.deletedCount);
            sink.putLong(message.errorCount);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnGentableClearReply> {
        Reader() {
        }

        @Override
        public OFBsnGentableClearReply readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 5) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_14(5), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 28) {
                throw new OFParseError("Wrong length: Expected=28(28), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 49) {
                throw new OFParseError("Wrong subtype: Expected=0x31L(0x31L), got=" + subtype);
            }
            GenTableId tableId = GenTableId.read2Bytes(bb);
            bb.skipBytes(2);
            long deletedCount = U32.f(bb.readInt());
            long errorCount = U32.f(bb.readInt());
            OFBsnGentableClearReplyVer14 bsnGentableClearReplyVer14 = new OFBsnGentableClearReplyVer14(xid, tableId, deletedCount, errorCount);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnGentableClearReplyVer14);
            }
            return bsnGentableClearReplyVer14;
        }
    }

    static class Builder
    implements OFBsnGentableClearReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean tableIdSet;
        private GenTableId tableId;
        private boolean deletedCountSet;
        private long deletedCount;
        private boolean errorCountSet;
        private long errorCount;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnGentableClearReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 49L;
        }

        @Override
        public GenTableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFBsnGentableClearReply.Builder setTableId(GenTableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public long getDeletedCount() {
            return this.deletedCount;
        }

        @Override
        public OFBsnGentableClearReply.Builder setDeletedCount(long deletedCount) {
            this.deletedCount = deletedCount;
            this.deletedCountSet = true;
            return this;
        }

        @Override
        public long getErrorCount() {
            return this.errorCount;
        }

        @Override
        public OFBsnGentableClearReply.Builder setErrorCount(long errorCount) {
            this.errorCount = errorCount;
            this.errorCountSet = true;
            return this;
        }

        @Override
        public OFBsnGentableClearReply build() {
            long xid;
            long l = xid = this.xidSet ? this.xid : 0L;
            if (!this.tableIdSet) {
                throw new IllegalStateException("Property tableId doesn't have default value -- must be set");
            }
            if (this.tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            long deletedCount = this.deletedCountSet ? this.deletedCount : 0L;
            long errorCount = this.errorCountSet ? this.errorCount : 0L;
            return new OFBsnGentableClearReplyVer14(xid, this.tableId, deletedCount, errorCount);
        }
    }

    static class BuilderWithParent
    implements OFBsnGentableClearReply.Builder {
        final OFBsnGentableClearReplyVer14 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean tableIdSet;
        private GenTableId tableId;
        private boolean deletedCountSet;
        private long deletedCount;
        private boolean errorCountSet;
        private long errorCount;

        BuilderWithParent(OFBsnGentableClearReplyVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnGentableClearReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 49L;
        }

        @Override
        public GenTableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFBsnGentableClearReply.Builder setTableId(GenTableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public long getDeletedCount() {
            return this.deletedCount;
        }

        @Override
        public OFBsnGentableClearReply.Builder setDeletedCount(long deletedCount) {
            this.deletedCount = deletedCount;
            this.deletedCountSet = true;
            return this;
        }

        @Override
        public long getErrorCount() {
            return this.errorCount;
        }

        @Override
        public OFBsnGentableClearReply.Builder setErrorCount(long errorCount) {
            this.errorCount = errorCount;
            this.errorCountSet = true;
            return this;
        }

        @Override
        public OFBsnGentableClearReply build() {
            GenTableId tableId;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            GenTableId genTableId = tableId = this.tableIdSet ? this.tableId : this.parentMessage.tableId;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            long deletedCount = this.deletedCountSet ? this.deletedCount : this.parentMessage.deletedCount;
            long errorCount = this.errorCountSet ? this.errorCount : this.parentMessage.errorCount;
            return new OFBsnGentableClearReplyVer14(xid, tableId, deletedCount, errorCount);
        }
    }
}

