/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnTimeReply;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTimeReplyVer14
implements OFBsnTimeReply {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTimeReplyVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 24;
    private static final long DEFAULT_XID = 0L;
    private static final U64 DEFAULT_TIME_MS = U64.ZERO;
    private final long xid;
    private final U64 timeMs;
    static final OFBsnTimeReplyVer14 DEFAULT = new OFBsnTimeReplyVer14(0L, DEFAULT_TIME_MS);
    static final Reader READER = new Reader();
    static final OFBsnTimeReplyVer14Funnel FUNNEL = new OFBsnTimeReplyVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTimeReplyVer14(long xid, U64 timeMs) {
        if (timeMs == null) {
            throw new NullPointerException("OFBsnTimeReplyVer14: property timeMs cannot be null");
        }
        this.xid = xid;
        this.timeMs = timeMs;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 45L;
    }

    @Override
    public U64 getTimeMs() {
        return this.timeMs;
    }

    @Override
    public OFBsnTimeReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTimeReplyVer14(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("timeMs=").append(this.timeMs);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTimeReplyVer14 other = (OFBsnTimeReplyVer14)obj;
        if (this.xid != other.xid) {
            return false;
        }
        return !(this.timeMs == null ? other.timeMs != null : !this.timeMs.equals(other.timeMs));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.timeMs == null ? 0 : this.timeMs.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTimeReplyVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnTimeReplyVer14 message) {
            bb.writeByte(5);
            bb.writeByte(4);
            bb.writeShort(24);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(45);
            bb.writeLong(message.timeMs.getValue());
        }
    }

    static class OFBsnTimeReplyVer14Funnel
    implements Funnel<OFBsnTimeReplyVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTimeReplyVer14Funnel() {
        }

        public void funnel(OFBsnTimeReplyVer14 message, PrimitiveSink sink) {
            sink.putByte((byte)5);
            sink.putByte((byte)4);
            sink.putShort((short)24);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(45);
            message.timeMs.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTimeReply> {
        Reader() {
        }

        @Override
        public OFBsnTimeReply readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 5) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_14(5), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 24) {
                throw new OFParseError("Wrong length: Expected=24(24), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 45) {
                throw new OFParseError("Wrong subtype: Expected=0x2dL(0x2dL), got=" + subtype);
            }
            U64 timeMs = U64.ofRaw(bb.readLong());
            OFBsnTimeReplyVer14 bsnTimeReplyVer14 = new OFBsnTimeReplyVer14(xid, timeMs);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTimeReplyVer14);
            }
            return bsnTimeReplyVer14;
        }
    }

    static class Builder
    implements OFBsnTimeReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean timeMsSet;
        private U64 timeMs;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnTimeReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 45L;
        }

        @Override
        public U64 getTimeMs() {
            return this.timeMs;
        }

        @Override
        public OFBsnTimeReply.Builder setTimeMs(U64 timeMs) {
            this.timeMs = timeMs;
            this.timeMsSet = true;
            return this;
        }

        @Override
        public OFBsnTimeReply build() {
            U64 timeMs;
            long xid = this.xidSet ? this.xid : 0L;
            U64 u64 = timeMs = this.timeMsSet ? this.timeMs : DEFAULT_TIME_MS;
            if (timeMs == null) {
                throw new NullPointerException("Property timeMs must not be null");
            }
            return new OFBsnTimeReplyVer14(xid, timeMs);
        }
    }

    static class BuilderWithParent
    implements OFBsnTimeReply.Builder {
        final OFBsnTimeReplyVer14 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean timeMsSet;
        private U64 timeMs;

        BuilderWithParent(OFBsnTimeReplyVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnTimeReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 45L;
        }

        @Override
        public U64 getTimeMs() {
            return this.timeMs;
        }

        @Override
        public OFBsnTimeReply.Builder setTimeMs(U64 timeMs) {
            this.timeMs = timeMs;
            this.timeMsSet = true;
            return this;
        }

        @Override
        public OFBsnTimeReply build() {
            U64 timeMs;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            U64 u64 = timeMs = this.timeMsSet ? this.timeMs : this.parentMessage.timeMs;
            if (timeMs == null) {
                throw new NullPointerException("Property timeMs must not be null");
            }
            return new OFBsnTimeReplyVer14(xid, timeMs);
        }
    }
}

