/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvActorSystemMac;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvActorSystemMacVer14
implements OFBsnTlvActorSystemMac {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvActorSystemMacVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 10;
    private static final MacAddress DEFAULT_VALUE = MacAddress.NONE;
    private final MacAddress value;
    static final OFBsnTlvActorSystemMacVer14 DEFAULT = new OFBsnTlvActorSystemMacVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvActorSystemMacVer14Funnel FUNNEL = new OFBsnTlvActorSystemMacVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvActorSystemMacVer14(MacAddress value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvActorSystemMacVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 41;
    }

    @Override
    public MacAddress getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvActorSystemMac.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvActorSystemMacVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvActorSystemMacVer14 other = (OFBsnTlvActorSystemMacVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvActorSystemMacVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnTlvActorSystemMacVer14 message) {
            bb.writeShort(41);
            bb.writeShort(10);
            message.value.write6Bytes(bb);
        }
    }

    static class OFBsnTlvActorSystemMacVer14Funnel
    implements Funnel<OFBsnTlvActorSystemMacVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvActorSystemMacVer14Funnel() {
        }

        public void funnel(OFBsnTlvActorSystemMacVer14 message, PrimitiveSink sink) {
            sink.putShort((short)41);
            sink.putShort((short)10);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvActorSystemMac> {
        Reader() {
        }

        @Override
        public OFBsnTlvActorSystemMac readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 41) {
                throw new OFParseError("Wrong type: Expected=0x29(0x29), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 10) {
                throw new OFParseError("Wrong length: Expected=10(10), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            MacAddress value = MacAddress.read6Bytes(bb);
            OFBsnTlvActorSystemMacVer14 bsnTlvActorSystemMacVer14 = new OFBsnTlvActorSystemMacVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvActorSystemMacVer14);
            }
            return bsnTlvActorSystemMacVer14;
        }
    }

    static class Builder
    implements OFBsnTlvActorSystemMac.Builder {
        private boolean valueSet;
        private MacAddress value;

        Builder() {
        }

        @Override
        public int getType() {
            return 41;
        }

        @Override
        public MacAddress getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvActorSystemMac.Builder setValue(MacAddress value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvActorSystemMac build() {
            MacAddress value;
            MacAddress macAddress = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvActorSystemMacVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvActorSystemMac.Builder {
        final OFBsnTlvActorSystemMacVer14 parentMessage;
        private boolean valueSet;
        private MacAddress value;

        BuilderWithParent(OFBsnTlvActorSystemMacVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 41;
        }

        @Override
        public MacAddress getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvActorSystemMac.Builder setValue(MacAddress value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvActorSystemMac build() {
            MacAddress value;
            MacAddress macAddress = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvActorSystemMacVer14(value);
        }
    }
}

