/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnLacpState;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvPartnerState;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnLacpStateSerializerVer14;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvPartnerStateVer14
implements OFBsnTlvPartnerState {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvPartnerStateVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 5;
    private static final Set<OFBsnLacpState> DEFAULT_VALUE = ImmutableSet.of();
    private final Set<OFBsnLacpState> value;
    static final OFBsnTlvPartnerStateVer14 DEFAULT = new OFBsnTlvPartnerStateVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvPartnerStateVer14Funnel FUNNEL = new OFBsnTlvPartnerStateVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvPartnerStateVer14(Set<OFBsnLacpState> value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvPartnerStateVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 54;
    }

    @Override
    public Set<OFBsnLacpState> getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvPartnerState.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvPartnerStateVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvPartnerStateVer14 other = (OFBsnTlvPartnerStateVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvPartnerStateVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnTlvPartnerStateVer14 message) {
            bb.writeShort(54);
            bb.writeShort(5);
            OFBsnLacpStateSerializerVer14.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvPartnerStateVer14Funnel
    implements Funnel<OFBsnTlvPartnerStateVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvPartnerStateVer14Funnel() {
        }

        public void funnel(OFBsnTlvPartnerStateVer14 message, PrimitiveSink sink) {
            sink.putShort((short)54);
            sink.putShort((short)5);
            OFBsnLacpStateSerializerVer14.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvPartnerState> {
        Reader() {
        }

        @Override
        public OFBsnTlvPartnerState readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 54) {
                throw new OFParseError("Wrong type: Expected=0x36(0x36), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 5) {
                throw new OFParseError("Wrong length: Expected=5(5), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            Set<OFBsnLacpState> value = OFBsnLacpStateSerializerVer14.readFrom(bb);
            OFBsnTlvPartnerStateVer14 bsnTlvPartnerStateVer14 = new OFBsnTlvPartnerStateVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvPartnerStateVer14);
            }
            return bsnTlvPartnerStateVer14;
        }
    }

    static class Builder
    implements OFBsnTlvPartnerState.Builder {
        private boolean valueSet;
        private Set<OFBsnLacpState> value;

        Builder() {
        }

        @Override
        public int getType() {
            return 54;
        }

        @Override
        public Set<OFBsnLacpState> getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvPartnerState.Builder setValue(Set<OFBsnLacpState> value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvPartnerState build() {
            Set<OFBsnLacpState> value;
            Set<OFBsnLacpState> set = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvPartnerStateVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvPartnerState.Builder {
        final OFBsnTlvPartnerStateVer14 parentMessage;
        private boolean valueSet;
        private Set<OFBsnLacpState> value;

        BuilderWithParent(OFBsnTlvPartnerStateVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 54;
        }

        @Override
        public Set<OFBsnLacpState> getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvPartnerState.Builder setValue(Set<OFBsnLacpState> value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvPartnerState build() {
            Set value;
            Set set = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvPartnerStateVer14(value);
        }
    }
}

