/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.PrimitiveSink;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFCapabilities;

public class OFCapabilitiesSerializerVer14 {
    public static final int FLOW_STATS_VAL = 1;
    public static final int TABLE_STATS_VAL = 2;
    public static final int PORT_STATS_VAL = 4;
    public static final int IP_REASM_VAL = 32;
    public static final int QUEUE_STATS_VAL = 64;
    public static final int GROUP_STATS_VAL = 8;
    public static final int PORT_BLOCKED_VAL = 256;

    public static Set<OFCapabilities> readFrom(ChannelBuffer bb) throws OFParseError {
        try {
            return OFCapabilitiesSerializerVer14.ofWireValue(bb.readInt());
        }
        catch (IllegalArgumentException e) {
            throw new OFParseError(e);
        }
    }

    public static void writeTo(ChannelBuffer bb, Set<OFCapabilities> set) {
        bb.writeInt(OFCapabilitiesSerializerVer14.toWireValue(set));
    }

    public static void putTo(Set<OFCapabilities> set, PrimitiveSink sink) {
        sink.putInt(OFCapabilitiesSerializerVer14.toWireValue(set));
    }

    public static Set<OFCapabilities> ofWireValue(int val) {
        EnumSet<OFCapabilities> set = EnumSet.noneOf(OFCapabilities.class);
        if ((val & 1) != 0) {
            set.add(OFCapabilities.FLOW_STATS);
        }
        if ((val & 2) != 0) {
            set.add(OFCapabilities.TABLE_STATS);
        }
        if ((val & 4) != 0) {
            set.add(OFCapabilities.PORT_STATS);
        }
        if ((val & 0x20) != 0) {
            set.add(OFCapabilities.IP_REASM);
        }
        if ((val & 0x40) != 0) {
            set.add(OFCapabilities.QUEUE_STATS);
        }
        if ((val & 8) != 0) {
            set.add(OFCapabilities.GROUP_STATS);
        }
        if ((val & 0x100) != 0) {
            set.add(OFCapabilities.PORT_BLOCKED);
        }
        return Collections.unmodifiableSet(set);
    }

    public static int toWireValue(Set<OFCapabilities> set) {
        int wireValue = 0;
        block9: for (OFCapabilities e : set) {
            switch (e) {
                case FLOW_STATS: {
                    wireValue |= 1;
                    continue block9;
                }
                case TABLE_STATS: {
                    wireValue |= 2;
                    continue block9;
                }
                case PORT_STATS: {
                    wireValue |= 4;
                    continue block9;
                }
                case IP_REASM: {
                    wireValue |= 0x20;
                    continue block9;
                }
                case QUEUE_STATS: {
                    wireValue |= 0x40;
                    continue block9;
                }
                case GROUP_STATS: {
                    wireValue |= 8;
                    continue block9;
                }
                case PORT_BLOCKED: {
                    wireValue |= 0x100;
                    continue block9;
                }
            }
            throw new IllegalArgumentException("Illegal enum value for type OFCapabilities in version 1.4: " + (Object)((Object)e));
        }
        return wireValue;
    }
}

