/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFErrorMsg;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.ver14.OFAsyncConfigFailedErrorMsgVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBadActionErrorMsgVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBadInstructionErrorMsgVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBadMatchErrorMsgVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBadPropertyErrorMsgVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBadRequestErrorMsgVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBundleFailedErrorMsgVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFExperimenterErrorMsgVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFFlowModFailedErrorMsgVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFFlowMonitorFailedErrorMsgVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFGroupModFailedErrorMsgVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFHelloFailedErrorMsgVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFMeterModFailedErrorMsgVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFPortModFailedErrorMsgVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFQueueOpFailedErrorMsgVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFRoleRequestFailedErrorMsgVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFSwitchConfigFailedErrorMsgVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFTableFeaturesFailedErrorMsgVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFTableModFailedErrorMsgVer14;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;

abstract class OFErrorMsgVer14 {
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 10;
    public static final Reader READER = new Reader();

    OFErrorMsgVer14() {
    }

    static class Reader
    implements OFMessageReader<OFErrorMsg> {
        Reader() {
        }

        @Override
        public OFErrorMsg readFrom(ChannelBuffer bb) throws OFParseError {
            if (bb.readableBytes() < 10) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 5) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_14(5), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 1) {
                throw new OFParseError("Wrong type: Expected=OFType.ERROR(1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 10) {
                throw new OFParseError("Wrong length: Expected to be >= 10, was: " + length);
            }
            U32.f(bb.readInt());
            short errType = bb.readShort();
            bb.readerIndex(start);
            switch (errType) {
                case 2: {
                    return OFBadActionErrorMsgVer14.READER.readFrom(bb);
                }
                case 1: {
                    return OFBadRequestErrorMsgVer14.READER.readFrom(bb);
                }
                case 5: {
                    return OFFlowModFailedErrorMsgVer14.READER.readFrom(bb);
                }
                case 0: {
                    return OFHelloFailedErrorMsgVer14.READER.readFrom(bb);
                }
                case 7: {
                    return OFPortModFailedErrorMsgVer14.READER.readFrom(bb);
                }
                case 9: {
                    return OFQueueOpFailedErrorMsgVer14.READER.readFrom(bb);
                }
                case 3: {
                    return OFBadInstructionErrorMsgVer14.READER.readFrom(bb);
                }
                case 4: {
                    return OFBadMatchErrorMsgVer14.READER.readFrom(bb);
                }
                case 6: {
                    return OFGroupModFailedErrorMsgVer14.READER.readFrom(bb);
                }
                case 10: {
                    return OFSwitchConfigFailedErrorMsgVer14.READER.readFrom(bb);
                }
                case 8: {
                    return OFTableModFailedErrorMsgVer14.READER.readFrom(bb);
                }
                case -1: {
                    return OFExperimenterErrorMsgVer14.READER.readFrom(bb);
                }
                case 11: {
                    return OFRoleRequestFailedErrorMsgVer14.READER.readFrom(bb);
                }
                case 12: {
                    return OFMeterModFailedErrorMsgVer14.READER.readFrom(bb);
                }
                case 13: {
                    return OFTableFeaturesFailedErrorMsgVer14.READER.readFrom(bb);
                }
                case 15: {
                    return OFAsyncConfigFailedErrorMsgVer14.READER.readFrom(bb);
                }
                case 14: {
                    return OFBadPropertyErrorMsgVer14.READER.readFrom(bb);
                }
                case 17: {
                    return OFBundleFailedErrorMsgVer14.READER.readFrom(bb);
                }
                case 16: {
                    return OFFlowMonitorFailedErrorMsgVer14.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator errType of class OFErrorMsgVer14: " + errType);
        }
    }
}

