/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.AbstractIterator;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.Iterator;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFFactories;
import org.projectfloodlight.openflow.protocol.OFMatchV3;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFOxmList;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.Match;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.ver14.OFOxmVer14;
import org.projectfloodlight.openflow.types.Masked;
import org.projectfloodlight.openflow.types.OFValueType;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFMatchV3Ver14
implements OFMatchV3 {
    private static final Logger logger = LoggerFactory.getLogger(OFMatchV3Ver14.class);
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 4;
    private static final OFOxmList DEFAULT_OXM_LIST = OFOxmList.EMPTY;
    private final OFOxmList oxmList;
    static final OFMatchV3Ver14 DEFAULT = new OFMatchV3Ver14(DEFAULT_OXM_LIST);
    static final Reader READER = new Reader();
    static final OFMatchV3Ver14Funnel FUNNEL = new OFMatchV3Ver14Funnel();
    static final Writer WRITER = new Writer();

    OFMatchV3Ver14(OFOxmList oxmList) {
        if (oxmList == null) {
            throw new NullPointerException("OFMatchV3Ver14: property oxmList cannot be null");
        }
        this.oxmList = oxmList;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public OFOxmList getOxmList() {
        return this.oxmList;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public <F extends OFValueType<F>> F get(MatchField<F> field) throws UnsupportedOperationException {
        if (!this.supports(field)) {
            throw new UnsupportedOperationException("OFMatchV3Ver14 does not support matching on field " + field.getName());
        }
        OFOxm<F> oxm = this.oxmList.get(field);
        if (oxm == null || !field.arePrerequisitesOK(this)) {
            return null;
        }
        return oxm.getValue();
    }

    @Override
    public <F extends OFValueType<F>> Masked<F> getMasked(MatchField<F> field) throws UnsupportedOperationException {
        if (!this.supportsMasked(field)) {
            throw new UnsupportedOperationException("OFMatchV3Ver14 does not support masked matching on field " + field.getName());
        }
        OFOxm<F> oxm = this.oxmList.get(field);
        if (oxm == null || !field.arePrerequisitesOK(this)) {
            return null;
        }
        if (oxm.getMask() == null) {
            return null;
        }
        return Masked.of(oxm.getValue(), oxm.getMask());
    }

    private static boolean supportsField(MatchField<?> field) {
        switch (field.id) {
            case ARP_OP: 
            case ARP_SHA: 
            case ARP_SPA: 
            case ARP_THA: 
            case ARP_TPA: 
            case BSN_EGR_PORT_GROUP_ID: 
            case BSN_GLOBAL_VRF_ALLOWED: 
            case BSN_INGRESS_PORT_GROUP_ID: 
            case BSN_INNER_ETH_DST: 
            case BSN_INNER_ETH_SRC: 
            case BSN_INNER_VLAN_VID: 
            case BSN_IN_PORTS_128: 
            case BSN_IN_PORTS_512: 
            case BSN_L2_CACHE_HIT: 
            case BSN_L3_DST_CLASS_ID: 
            case BSN_L3_INTERFACE_CLASS_ID: 
            case BSN_L3_SRC_CLASS_ID: 
            case BSN_LAG_ID: 
            case BSN_TCP_FLAGS: 
            case BSN_UDF0: 
            case BSN_UDF1: 
            case BSN_UDF2: 
            case BSN_UDF3: 
            case BSN_UDF4: 
            case BSN_UDF5: 
            case BSN_UDF6: 
            case BSN_UDF7: 
            case BSN_VLAN_XLATE_PORT_GROUP_ID: 
            case BSN_VRF: 
            case BSN_VXLAN_NETWORK_ID: 
            case ETH_DST: 
            case ETH_SRC: 
            case ETH_TYPE: 
            case EXP_OCH_SIGTYPE: 
            case EXP_OCH_SIG_ID: 
            case EXP_ODU_SIGTYPE: 
            case EXP_ODU_SIG_ID: 
            case ICMPV4_CODE: 
            case ICMPV4_TYPE: 
            case ICMPV6_CODE: 
            case ICMPV6_TYPE: 
            case IN_PHY_PORT: 
            case IN_PORT: 
            case IPV4_DST: 
            case IPV4_SRC: 
            case IPV6_DST: 
            case IPV6_EXTHDR: 
            case IPV6_FLABEL: 
            case IPV6_ND_SLL: 
            case IPV6_ND_TARGET: 
            case IPV6_ND_TLL: 
            case IPV6_SRC: 
            case IP_DSCP: 
            case IP_ECN: 
            case IP_PROTO: 
            case METADATA: 
            case MPLS_BOS: 
            case MPLS_LABEL: 
            case MPLS_TC: 
            case NSH_CH1: 
            case NSH_CH2: 
            case NSH_CH3: 
            case NSH_CH4: 
            case NSH_SI: 
            case NSH_SPI: 
            case OCH_SIGATT: 
            case OCH_SIGATT_BASIC: 
            case OCH_SIGID: 
            case OCH_SIGID_BASIC: 
            case OCH_SIGTYPE: 
            case OCH_SIGTYPE_BASIC: 
            case PBB_UCA: 
            case REG0: 
            case REG1: 
            case REG2: 
            case REG3: 
            case REG4: 
            case REG5: 
            case REG6: 
            case REG7: 
            case SCTP_DST: 
            case SCTP_SRC: 
            case TCP_DST: 
            case TCP_SRC: 
            case TUNNEL_ID: 
            case TUNNEL_IPV4_DST: 
            case TUNNEL_IPV4_SRC: 
            case UDP_DST: 
            case UDP_SRC: 
            case VLAN_PCP: 
            case VLAN_VID: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supports(MatchField<?> field) {
        return OFMatchV3Ver14.supportsField(field);
    }

    @Override
    public boolean supportsMasked(MatchField<?> field) {
        return OFMatchV3Ver14.supportsField(field);
    }

    @Override
    public boolean isExact(MatchField<?> field) {
        if (!this.supports(field)) {
            throw new UnsupportedOperationException("OFMatchV3Ver14 does not support matching on field " + field.getName());
        }
        OFOxm<?> oxm = this.oxmList.get(field);
        return oxm != null && !oxm.isMasked();
    }

    @Override
    public boolean isFullyWildcarded(MatchField<?> field) {
        if (!this.supports(field)) {
            throw new UnsupportedOperationException("OFMatchV3Ver14 does not support matching on field " + field.getName());
        }
        OFOxm<?> oxm = this.oxmList.get(field);
        return oxm == null;
    }

    @Override
    public boolean isPartiallyMasked(MatchField<?> field) {
        if (!this.supports(field)) {
            throw new UnsupportedOperationException("OFMatchV3Ver14 does not support matching on field " + field.getName());
        }
        OFOxm<?> oxm = this.oxmList.get(field);
        return oxm != null && oxm.isMasked();
    }

    @Override
    public Iterable<MatchField<?>> getMatchFields() {
        return new Iterable<MatchField<?>>(){

            @Override
            public Iterator<MatchField<?>> iterator() {
                return new MatchFieldIterator();
            }
        };
    }

    @Override
    public OFMatchV3.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFMatchV3Ver14(");
        boolean first = true;
        for (MatchField<?> field : this.getMatchFields()) {
            if (first) {
                first = false;
            } else {
                b.append(", ");
            }
            String name = field.getName();
            b.append(name).append('=').append(this.get(field));
            if (!this.isPartiallyMasked(field)) continue;
            b.append('/').append(this.getMasked(field).getMask());
        }
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFMatchV3Ver14 other = (OFMatchV3Ver14)obj;
        return !(this.oxmList == null ? other.oxmList != null : !this.oxmList.equals(other.oxmList));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.oxmList == null ? 0 : this.oxmList.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFMatchV3Ver14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFMatchV3Ver14 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(1);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            message.oxmList.writeTo(bb);
            int length = bb.writerIndex() - startIndex;
            int alignedLength = (length + 7) / 8 * 8;
            bb.setShort(lengthIndex, length);
            bb.writeZero(alignedLength - length);
        }
    }

    static class OFMatchV3Ver14Funnel
    implements Funnel<OFMatchV3Ver14> {
        private static final long serialVersionUID = 1L;

        OFMatchV3Ver14Funnel() {
        }

        public void funnel(OFMatchV3Ver14 message, PrimitiveSink sink) {
            sink.putShort((short)1);
            message.oxmList.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFMatchV3> {
        Reader() {
        }

        @Override
        public OFMatchV3 readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 1) {
                throw new OFParseError("Wrong type: Expected=0x1(0x1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 4) {
                throw new OFParseError("Wrong length: Expected to be >= 4, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFOxmList oxmList = OFOxmList.readFrom(bb, length - (bb.readerIndex() - start), OFOxmVer14.READER);
            bb.skipBytes((length + 7) / 8 * 8 - length);
            OFMatchV3Ver14 matchV3Ver14 = new OFMatchV3Ver14(oxmList);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)matchV3Ver14);
            }
            return matchV3Ver14;
        }
    }

    static class Builder
    implements OFMatchV3.Builder {
        private boolean oxmListSet;
        private OFOxmList oxmList;
        private OFOxmList.Builder oxmListBuilder;

        Builder() {
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public OFOxmList getOxmList() {
            return this.oxmList;
        }

        @Override
        public OFMatchV3.Builder setOxmList(OFOxmList oxmList) {
            this.oxmList = oxmList;
            this.oxmListSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFMatchV3 build() {
            OFOxmList oxmList;
            OFOxmList oFOxmList = oxmList = this.oxmListSet ? this.oxmList : DEFAULT_OXM_LIST;
            if (oxmList == null) {
                throw new NullPointerException("Property oxmList must not be null");
            }
            return new OFMatchV3Ver14(oxmList);
        }

        private void initBuilder() {
            if (this.oxmListBuilder != null) {
                return;
            }
            this.oxmListBuilder = new OFOxmList.Builder();
        }

        private void updateOxmList() {
            this.oxmList = this.oxmListBuilder.build();
            this.oxmListSet = true;
        }

        private <F extends OFValueType<F>> OFOxm<F> getOxm(MatchField<F> field) {
            return this.oxmListSet ? this.oxmList.get(field) : null;
        }

        @Override
        public <F extends OFValueType<F>> F get(MatchField<F> field) throws UnsupportedOperationException {
            OFOxm<F> value = this.getOxm(field);
            if (value == null) {
                return null;
            }
            return value.getValue();
        }

        @Override
        public <F extends OFValueType<F>> Masked<F> getMasked(MatchField<F> field) throws UnsupportedOperationException {
            OFOxm<F> value = this.getOxm(field);
            if (value == null || !value.isMasked()) {
                return null;
            }
            return Masked.of(value.getValue(), value.getMask());
        }

        @Override
        public boolean supports(MatchField<?> field) {
            return OFMatchV3Ver14.supportsField(field);
        }

        @Override
        public boolean supportsMasked(MatchField<?> field) {
            return OFMatchV3Ver14.supportsField(field);
        }

        @Override
        public boolean isExact(MatchField<?> field) {
            OFOxm<?> value = this.getOxm(field);
            return value != null && !value.isMasked();
        }

        @Override
        public boolean isFullyWildcarded(MatchField<?> field) {
            OFOxm<?> value = this.getOxm(field);
            return value == null;
        }

        @Override
        public boolean isPartiallyMasked(MatchField<?> field) {
            OFOxm<?> value = this.getOxm(field);
            return value != null && value.isMasked();
        }

        @Override
        public <F extends OFValueType<F>> Match.Builder setExact(MatchField<F> field, F value) {
            this.initBuilder();
            OFOxm<F> oxm = OFFactories.getFactory(OFVersion.OF_14).oxms().fromValue(value, field);
            this.oxmListBuilder.set(oxm);
            this.updateOxmList();
            return this;
        }

        @Override
        public <F extends OFValueType<F>> Match.Builder setMasked(MatchField<F> field, F value, F mask) {
            this.initBuilder();
            OFOxm<F> oxm = OFFactories.getFactory(OFVersion.OF_14).oxms().fromValueAndMask(value, mask, field);
            this.oxmListBuilder.set(oxm);
            this.updateOxmList();
            return this;
        }

        @Override
        public <F extends OFValueType<F>> Match.Builder setMasked(MatchField<F> field, Masked<F> valueWithMask) {
            this.initBuilder();
            OFOxm<F> oxm = OFFactories.getFactory(OFVersion.OF_14).oxms().fromMasked(valueWithMask, field);
            this.oxmListBuilder.set(oxm);
            this.updateOxmList();
            return this;
        }

        @Override
        public <F extends OFValueType<F>> Match.Builder wildcard(MatchField<F> field) {
            this.initBuilder();
            this.oxmListBuilder.unset(field);
            this.updateOxmList();
            return this;
        }
    }

    static class BuilderWithParent
    implements OFMatchV3.Builder {
        final OFMatchV3Ver14 parentMessage;
        private boolean oxmListSet;
        private OFOxmList oxmList;
        private OFOxmList.Builder oxmListBuilder;

        BuilderWithParent(OFMatchV3Ver14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public OFOxmList getOxmList() {
            return this.oxmList;
        }

        @Override
        public OFMatchV3.Builder setOxmList(OFOxmList oxmList) {
            this.oxmList = oxmList;
            this.oxmListSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFMatchV3 build() {
            OFOxmList oxmList;
            OFOxmList oFOxmList = oxmList = this.oxmListSet ? this.oxmList : this.parentMessage.oxmList;
            if (oxmList == null) {
                throw new NullPointerException("Property oxmList must not be null");
            }
            return new OFMatchV3Ver14(oxmList);
        }

        private void initBuilder() {
            if (this.oxmListBuilder != null) {
                return;
            }
            this.oxmListBuilder = new OFOxmList.Builder();
        }

        private void updateOxmList() {
            this.oxmList = this.oxmListBuilder.build();
            this.oxmListSet = true;
        }

        private <F extends OFValueType<F>> OFOxm<F> getOxm(MatchField<F> field) {
            return this.oxmListSet ? this.oxmList.get(field) : null;
        }

        @Override
        public <F extends OFValueType<F>> F get(MatchField<F> field) throws UnsupportedOperationException {
            OFOxm<F> value = this.getOxm(field);
            if (value == null) {
                return null;
            }
            return value.getValue();
        }

        @Override
        public <F extends OFValueType<F>> Masked<F> getMasked(MatchField<F> field) throws UnsupportedOperationException {
            OFOxm<F> value = this.getOxm(field);
            if (value == null || !value.isMasked()) {
                return null;
            }
            return Masked.of(value.getValue(), value.getMask());
        }

        @Override
        public boolean supports(MatchField<?> field) {
            return OFMatchV3Ver14.supportsField(field);
        }

        @Override
        public boolean supportsMasked(MatchField<?> field) {
            return OFMatchV3Ver14.supportsField(field);
        }

        @Override
        public boolean isExact(MatchField<?> field) {
            OFOxm<?> value = this.getOxm(field);
            return value != null && !value.isMasked();
        }

        @Override
        public boolean isFullyWildcarded(MatchField<?> field) {
            OFOxm<?> value = this.getOxm(field);
            return value == null;
        }

        @Override
        public boolean isPartiallyMasked(MatchField<?> field) {
            OFOxm<?> value = this.getOxm(field);
            return value != null && value.isMasked();
        }

        @Override
        public <F extends OFValueType<F>> Match.Builder setExact(MatchField<F> field, F value) {
            this.initBuilder();
            OFOxm<F> oxm = OFFactories.getFactory(OFVersion.OF_14).oxms().fromValue(value, field);
            this.oxmListBuilder.set(oxm);
            this.updateOxmList();
            return this;
        }

        @Override
        public <F extends OFValueType<F>> Match.Builder setMasked(MatchField<F> field, F value, F mask) {
            this.initBuilder();
            OFOxm<F> oxm = OFFactories.getFactory(OFVersion.OF_14).oxms().fromValueAndMask(value, mask, field);
            this.oxmListBuilder.set(oxm);
            this.updateOxmList();
            return this;
        }

        @Override
        public <F extends OFValueType<F>> Match.Builder setMasked(MatchField<F> field, Masked<F> valueWithMask) {
            this.initBuilder();
            OFOxm<F> oxm = OFFactories.getFactory(OFVersion.OF_14).oxms().fromMasked(valueWithMask, field);
            this.oxmListBuilder.set(oxm);
            this.updateOxmList();
            return this;
        }

        @Override
        public <F extends OFValueType<F>> Match.Builder wildcard(MatchField<F> field) {
            this.initBuilder();
            this.oxmListBuilder.unset(field);
            this.updateOxmList();
            return this;
        }
    }

    private class MatchFieldIterator
    extends AbstractIterator<MatchField<?>> {
        private Iterator<OFOxm<?>> oxmIterator;

        MatchFieldIterator() {
            this.oxmIterator = OFMatchV3Ver14.this.oxmList.iterator();
        }

        protected MatchField<?> computeNext() {
            while (this.oxmIterator.hasNext()) {
                OFOxm<?> oxm = this.oxmIterator.next();
                if (!oxm.getMatchField().arePrerequisitesOK(OFMatchV3Ver14.this)) continue;
                return oxm.getMatchField();
            }
            this.endOfData();
            return null;
        }
    }
}

