/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmIcmpv6Code;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmIcmpv6CodeVer14
implements OFOxmIcmpv6Code {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmIcmpv6CodeVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 5;
    private static final U8 DEFAULT_VALUE = U8.ZERO;
    private final U8 value;
    static final OFOxmIcmpv6CodeVer14 DEFAULT = new OFOxmIcmpv6CodeVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmIcmpv6CodeVer14Funnel FUNNEL = new OFOxmIcmpv6CodeVer14Funnel();
    static final Writer WRITER = new Writer();

    OFOxmIcmpv6CodeVer14(U8 value) {
        if (value == null) {
            throw new NullPointerException("OFOxmIcmpv6CodeVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 2147499009L;
    }

    @Override
    public U8 getValue() {
        return this.value;
    }

    @Override
    public MatchField<U8> getMatchField() {
        return MatchField.ICMPV6_CODE;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<U8> getCanonical() {
        return this;
    }

    @Override
    public U8 getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.4");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFOxmIcmpv6Code.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmIcmpv6CodeVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmIcmpv6CodeVer14 other = (OFOxmIcmpv6CodeVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmIcmpv6CodeVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmIcmpv6CodeVer14 message) {
            bb.writeInt(-2147468287);
            bb.writeByte((int)message.value.getRaw());
        }
    }

    static class OFOxmIcmpv6CodeVer14Funnel
    implements Funnel<OFOxmIcmpv6CodeVer14> {
        private static final long serialVersionUID = 1L;

        OFOxmIcmpv6CodeVer14Funnel() {
        }

        public void funnel(OFOxmIcmpv6CodeVer14 message, PrimitiveSink sink) {
            sink.putInt(-2147468287);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmIcmpv6Code> {
        Reader() {
        }

        @Override
        public OFOxmIcmpv6Code readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147468287) {
                throw new OFParseError("Wrong typeLen: Expected=0x80003c01L(0x80003c01L), got=" + typeLen);
            }
            U8 value = U8.of(bb.readByte());
            OFOxmIcmpv6CodeVer14 oxmIcmpv6CodeVer14 = new OFOxmIcmpv6CodeVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmIcmpv6CodeVer14);
            }
            return oxmIcmpv6CodeVer14;
        }
    }

    static class Builder
    implements OFOxmIcmpv6Code.Builder {
        private boolean valueSet;
        private U8 value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147499009L;
        }

        @Override
        public U8 getValue() {
            return this.value;
        }

        @Override
        public OFOxmIcmpv6Code.Builder setValue(U8 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U8> getMatchField() {
            return MatchField.ICMPV6_CODE;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U8> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public U8 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmIcmpv6Code build() {
            U8 value;
            U8 u8 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmIcmpv6CodeVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmIcmpv6Code.Builder {
        final OFOxmIcmpv6CodeVer14 parentMessage;
        private boolean valueSet;
        private U8 value;

        BuilderWithParent(OFOxmIcmpv6CodeVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147499009L;
        }

        @Override
        public U8 getValue() {
            return this.value;
        }

        @Override
        public OFOxmIcmpv6Code.Builder setValue(U8 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U8> getMatchField() {
            return MatchField.ICMPV6_CODE;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U8> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public U8 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmIcmpv6Code build() {
            U8 value;
            U8 u8 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmIcmpv6CodeVer14(value);
        }
    }
}

