/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmIpv6DstMasked;
import org.projectfloodlight.openflow.protocol.ver14.OFOxmIpv6DstVer14;
import org.projectfloodlight.openflow.types.IPv6Address;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmIpv6DstMaskedVer14
implements OFOxmIpv6DstMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmIpv6DstMaskedVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 36;
    private static final IPv6Address DEFAULT_VALUE = IPv6Address.NONE;
    private static final IPv6Address DEFAULT_VALUE_MASK = IPv6Address.NONE;
    private final IPv6Address value;
    private final IPv6Address mask;
    static final OFOxmIpv6DstMaskedVer14 DEFAULT = new OFOxmIpv6DstMaskedVer14(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmIpv6DstMaskedVer14Funnel FUNNEL = new OFOxmIpv6DstMaskedVer14Funnel();
    static final Writer WRITER = new Writer();

    OFOxmIpv6DstMaskedVer14(IPv6Address value, IPv6Address mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmIpv6DstMaskedVer14: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmIpv6DstMaskedVer14: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 2147497760L;
    }

    @Override
    public IPv6Address getValue() {
        return this.value;
    }

    @Override
    public IPv6Address getMask() {
        return this.mask;
    }

    @Override
    public MatchField<IPv6Address> getMatchField() {
        return MatchField.IPV6_DST;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<IPv6Address> getCanonical() {
        if (IPv6Address.NO_MASK.equals(this.mask)) {
            return new OFOxmIpv6DstVer14(this.value);
        }
        if (IPv6Address.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFOxmIpv6DstMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmIpv6DstMaskedVer14(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmIpv6DstMaskedVer14 other = (OFOxmIpv6DstMaskedVer14)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmIpv6DstMaskedVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmIpv6DstMaskedVer14 message) {
            bb.writeInt(-2147469536);
            message.value.write16Bytes(bb);
            message.mask.write16Bytes(bb);
        }
    }

    static class OFOxmIpv6DstMaskedVer14Funnel
    implements Funnel<OFOxmIpv6DstMaskedVer14> {
        private static final long serialVersionUID = 1L;

        OFOxmIpv6DstMaskedVer14Funnel() {
        }

        public void funnel(OFOxmIpv6DstMaskedVer14 message, PrimitiveSink sink) {
            sink.putInt(-2147469536);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmIpv6DstMasked> {
        Reader() {
        }

        @Override
        public OFOxmIpv6DstMasked readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147469536) {
                throw new OFParseError("Wrong typeLen: Expected=0x80003720L(0x80003720L), got=" + typeLen);
            }
            IPv6Address value = IPv6Address.read16Bytes(bb);
            IPv6Address mask = IPv6Address.read16Bytes(bb);
            OFOxmIpv6DstMaskedVer14 oxmIpv6DstMaskedVer14 = new OFOxmIpv6DstMaskedVer14(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmIpv6DstMaskedVer14);
            }
            return oxmIpv6DstMaskedVer14;
        }
    }

    static class Builder
    implements OFOxmIpv6DstMasked.Builder {
        private boolean valueSet;
        private IPv6Address value;
        private boolean maskSet;
        private IPv6Address mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147497760L;
        }

        @Override
        public IPv6Address getValue() {
            return this.value;
        }

        @Override
        public OFOxmIpv6DstMasked.Builder setValue(IPv6Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public IPv6Address getMask() {
            return this.mask;
        }

        @Override
        public OFOxmIpv6DstMasked.Builder setMask(IPv6Address mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<IPv6Address> getMatchField() {
            return MatchField.IPV6_DST;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<IPv6Address> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmIpv6DstMasked build() {
            IPv6Address mask;
            IPv6Address value;
            IPv6Address iPv6Address = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            IPv6Address iPv6Address2 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmIpv6DstMaskedVer14(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmIpv6DstMasked.Builder {
        final OFOxmIpv6DstMaskedVer14 parentMessage;
        private boolean valueSet;
        private IPv6Address value;
        private boolean maskSet;
        private IPv6Address mask;

        BuilderWithParent(OFOxmIpv6DstMaskedVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147497760L;
        }

        @Override
        public IPv6Address getValue() {
            return this.value;
        }

        @Override
        public OFOxmIpv6DstMasked.Builder setValue(IPv6Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public IPv6Address getMask() {
            return this.mask;
        }

        @Override
        public OFOxmIpv6DstMasked.Builder setMask(IPv6Address mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<IPv6Address> getMatchField() {
            return MatchField.IPV6_DST;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<IPv6Address> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmIpv6DstMasked build() {
            IPv6Address mask;
            IPv6Address value;
            IPv6Address iPv6Address = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            IPv6Address iPv6Address2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmIpv6DstMaskedVer14(value, mask);
        }
    }
}

