/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmIpv6Flabel;
import org.projectfloodlight.openflow.types.IPv6FlowLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmIpv6FlabelVer14
implements OFOxmIpv6Flabel {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmIpv6FlabelVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final IPv6FlowLabel DEFAULT_VALUE = IPv6FlowLabel.NONE;
    private final IPv6FlowLabel value;
    static final OFOxmIpv6FlabelVer14 DEFAULT = new OFOxmIpv6FlabelVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmIpv6FlabelVer14Funnel FUNNEL = new OFOxmIpv6FlabelVer14Funnel();
    static final Writer WRITER = new Writer();

    OFOxmIpv6FlabelVer14(IPv6FlowLabel value) {
        if (value == null) {
            throw new NullPointerException("OFOxmIpv6FlabelVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 2147497988L;
    }

    @Override
    public IPv6FlowLabel getValue() {
        return this.value;
    }

    @Override
    public MatchField<IPv6FlowLabel> getMatchField() {
        return MatchField.IPV6_FLABEL;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<IPv6FlowLabel> getCanonical() {
        return this;
    }

    @Override
    public IPv6FlowLabel getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.4");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFOxmIpv6Flabel.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmIpv6FlabelVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmIpv6FlabelVer14 other = (OFOxmIpv6FlabelVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmIpv6FlabelVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmIpv6FlabelVer14 message) {
            bb.writeInt(-2147469308);
            message.value.write4Bytes(bb);
        }
    }

    static class OFOxmIpv6FlabelVer14Funnel
    implements Funnel<OFOxmIpv6FlabelVer14> {
        private static final long serialVersionUID = 1L;

        OFOxmIpv6FlabelVer14Funnel() {
        }

        public void funnel(OFOxmIpv6FlabelVer14 message, PrimitiveSink sink) {
            sink.putInt(-2147469308);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmIpv6Flabel> {
        Reader() {
        }

        @Override
        public OFOxmIpv6Flabel readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147469308) {
                throw new OFParseError("Wrong typeLen: Expected=0x80003804L(0x80003804L), got=" + typeLen);
            }
            IPv6FlowLabel value = IPv6FlowLabel.read4Bytes(bb);
            OFOxmIpv6FlabelVer14 oxmIpv6FlabelVer14 = new OFOxmIpv6FlabelVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmIpv6FlabelVer14);
            }
            return oxmIpv6FlabelVer14;
        }
    }

    static class Builder
    implements OFOxmIpv6Flabel.Builder {
        private boolean valueSet;
        private IPv6FlowLabel value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147497988L;
        }

        @Override
        public IPv6FlowLabel getValue() {
            return this.value;
        }

        @Override
        public OFOxmIpv6Flabel.Builder setValue(IPv6FlowLabel value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<IPv6FlowLabel> getMatchField() {
            return MatchField.IPV6_FLABEL;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<IPv6FlowLabel> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public IPv6FlowLabel getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmIpv6Flabel build() {
            IPv6FlowLabel value;
            IPv6FlowLabel iPv6FlowLabel = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmIpv6FlabelVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmIpv6Flabel.Builder {
        final OFOxmIpv6FlabelVer14 parentMessage;
        private boolean valueSet;
        private IPv6FlowLabel value;

        BuilderWithParent(OFOxmIpv6FlabelVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147497988L;
        }

        @Override
        public IPv6FlowLabel getValue() {
            return this.value;
        }

        @Override
        public OFOxmIpv6Flabel.Builder setValue(IPv6FlowLabel value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<IPv6FlowLabel> getMatchField() {
            return MatchField.IPV6_FLABEL;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<IPv6FlowLabel> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public IPv6FlowLabel getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmIpv6Flabel build() {
            IPv6FlowLabel value;
            IPv6FlowLabel iPv6FlowLabel = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmIpv6FlabelVer14(value);
        }
    }
}

