/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmNshCh1;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmNshCh1Ver14
implements OFOxmNshCh1 {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmNshCh1Ver14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final U32 DEFAULT_VALUE = U32.ZERO;
    private final U32 value;
    static final OFOxmNshCh1Ver14 DEFAULT = new OFOxmNshCh1Ver14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmNshCh1Ver14Funnel FUNNEL = new OFOxmNshCh1Ver14Funnel();
    static final Writer WRITER = new Writer();

    OFOxmNshCh1Ver14(U32 value) {
        if (value == null) {
            throw new NullPointerException("OFOxmNshCh1Ver14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 85508L;
    }

    @Override
    public U32 getValue() {
        return this.value;
    }

    @Override
    public MatchField<U32> getMatchField() {
        return MatchField.NSH_CH1;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<U32> getCanonical() {
        return this;
    }

    @Override
    public U32 getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.4");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFOxmNshCh1.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmNshCh1Ver14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmNshCh1Ver14 other = (OFOxmNshCh1Ver14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmNshCh1Ver14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmNshCh1Ver14 message) {
            bb.writeInt(85508);
            bb.writeInt(message.value.getRaw());
        }
    }

    static class OFOxmNshCh1Ver14Funnel
    implements Funnel<OFOxmNshCh1Ver14> {
        private static final long serialVersionUID = 1L;

        OFOxmNshCh1Ver14Funnel() {
        }

        public void funnel(OFOxmNshCh1Ver14 message, PrimitiveSink sink) {
            sink.putInt(85508);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmNshCh1> {
        Reader() {
        }

        @Override
        public OFOxmNshCh1 readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 85508) {
                throw new OFParseError("Wrong typeLen: Expected=0x14e04L(0x14e04L), got=" + typeLen);
            }
            U32 value = U32.of(bb.readInt());
            OFOxmNshCh1Ver14 oxmNshCh1Ver14 = new OFOxmNshCh1Ver14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmNshCh1Ver14);
            }
            return oxmNshCh1Ver14;
        }
    }

    static class Builder
    implements OFOxmNshCh1.Builder {
        private boolean valueSet;
        private U32 value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 85508L;
        }

        @Override
        public U32 getValue() {
            return this.value;
        }

        @Override
        public OFOxmNshCh1.Builder setValue(U32 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U32> getMatchField() {
            return MatchField.NSH_CH1;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U32> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public U32 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmNshCh1 build() {
            U32 value;
            U32 u32 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmNshCh1Ver14(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmNshCh1.Builder {
        final OFOxmNshCh1Ver14 parentMessage;
        private boolean valueSet;
        private U32 value;

        BuilderWithParent(OFOxmNshCh1Ver14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 85508L;
        }

        @Override
        public U32 getValue() {
            return this.value;
        }

        @Override
        public OFOxmNshCh1.Builder setValue(U32 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U32> getMatchField() {
            return MatchField.NSH_CH1;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U32> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public U32 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmNshCh1 build() {
            U32 value;
            U32 u32 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmNshCh1Ver14(value);
        }
    }
}

