/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFPacketInReason;

public class OFPacketInReasonSerializerVer14 {
    public static final byte NO_MATCH_VAL = 0;
    public static final byte ACTION_VAL = 1;
    public static final byte INVALID_TTL_VAL = 2;
    public static final byte ACTION_SET_VAL = 3;
    public static final byte GROUP_VAL = 4;
    public static final byte PACKET_OUT_VAL = 5;
    public static final byte BSN_NEW_HOST_VAL = -128;
    public static final byte BSN_STATION_MOVE_VAL = -127;
    public static final byte BSN_BAD_VLAN_VAL = -126;
    public static final byte BSN_DESTINATION_LOOKUP_FAILURE_VAL = -125;
    public static final byte BSN_NO_ROUTE_VAL = -124;
    public static final byte BSN_ICMP_ECHO_REQUEST_VAL = -123;
    public static final byte BSN_DEST_NETWORK_UNREACHABLE_VAL = -122;
    public static final byte BSN_DEST_HOST_UNREACHABLE_VAL = -121;
    public static final byte BSN_DEST_PORT_UNREACHABLE_VAL = -120;
    public static final byte BSN_FRAGMENTATION_REQUIRED_VAL = -119;
    public static final byte BSN_ARP_VAL = -117;
    public static final byte BSN_DHCP_VAL = -116;
    public static final byte BSN_DEBUG_VAL = -115;
    public static final byte BSN_PACKET_OF_DEATH_VAL = -114;

    public static OFPacketInReason readFrom(ChannelBuffer bb) throws OFParseError {
        try {
            return OFPacketInReasonSerializerVer14.ofWireValue(bb.readByte());
        }
        catch (IllegalArgumentException e) {
            throw new OFParseError(e);
        }
    }

    public static void writeTo(ChannelBuffer bb, OFPacketInReason e) {
        bb.writeByte((int)OFPacketInReasonSerializerVer14.toWireValue(e));
    }

    public static void putTo(OFPacketInReason e, PrimitiveSink sink) {
        sink.putByte(OFPacketInReasonSerializerVer14.toWireValue(e));
    }

    public static OFPacketInReason ofWireValue(byte val) {
        switch (val) {
            case 0: {
                return OFPacketInReason.NO_MATCH;
            }
            case 1: {
                return OFPacketInReason.ACTION;
            }
            case 2: {
                return OFPacketInReason.INVALID_TTL;
            }
            case 3: {
                return OFPacketInReason.ACTION_SET;
            }
            case 4: {
                return OFPacketInReason.GROUP;
            }
            case 5: {
                return OFPacketInReason.PACKET_OUT;
            }
            case -128: {
                return OFPacketInReason.BSN_NEW_HOST;
            }
            case -127: {
                return OFPacketInReason.BSN_STATION_MOVE;
            }
            case -126: {
                return OFPacketInReason.BSN_BAD_VLAN;
            }
            case -125: {
                return OFPacketInReason.BSN_DESTINATION_LOOKUP_FAILURE;
            }
            case -124: {
                return OFPacketInReason.BSN_NO_ROUTE;
            }
            case -123: {
                return OFPacketInReason.BSN_ICMP_ECHO_REQUEST;
            }
            case -122: {
                return OFPacketInReason.BSN_DEST_NETWORK_UNREACHABLE;
            }
            case -121: {
                return OFPacketInReason.BSN_DEST_HOST_UNREACHABLE;
            }
            case -120: {
                return OFPacketInReason.BSN_DEST_PORT_UNREACHABLE;
            }
            case -119: {
                return OFPacketInReason.BSN_FRAGMENTATION_REQUIRED;
            }
            case -117: {
                return OFPacketInReason.BSN_ARP;
            }
            case -116: {
                return OFPacketInReason.BSN_DHCP;
            }
            case -115: {
                return OFPacketInReason.BSN_DEBUG;
            }
            case -114: {
                return OFPacketInReason.BSN_PACKET_OF_DEATH;
            }
        }
        throw new IllegalArgumentException("Illegal wire value for type OFPacketInReason in version 1.4: " + val);
    }

    public static byte toWireValue(OFPacketInReason e) {
        switch (e) {
            case NO_MATCH: {
                return 0;
            }
            case ACTION: {
                return 1;
            }
            case INVALID_TTL: {
                return 2;
            }
            case ACTION_SET: {
                return 3;
            }
            case GROUP: {
                return 4;
            }
            case PACKET_OUT: {
                return 5;
            }
            case BSN_NEW_HOST: {
                return -128;
            }
            case BSN_STATION_MOVE: {
                return -127;
            }
            case BSN_BAD_VLAN: {
                return -126;
            }
            case BSN_DESTINATION_LOOKUP_FAILURE: {
                return -125;
            }
            case BSN_NO_ROUTE: {
                return -124;
            }
            case BSN_ICMP_ECHO_REQUEST: {
                return -123;
            }
            case BSN_DEST_NETWORK_UNREACHABLE: {
                return -122;
            }
            case BSN_DEST_HOST_UNREACHABLE: {
                return -121;
            }
            case BSN_DEST_PORT_UNREACHABLE: {
                return -120;
            }
            case BSN_FRAGMENTATION_REQUIRED: {
                return -119;
            }
            case BSN_ARP: {
                return -117;
            }
            case BSN_DHCP: {
                return -116;
            }
            case BSN_DEBUG: {
                return -115;
            }
            case BSN_PACKET_OF_DEATH: {
                return -114;
            }
        }
        throw new IllegalArgumentException("Illegal enum value for type OFPacketInReason in version 1.4: " + (Object)((Object)e));
    }
}

